/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.debug.core.internal;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.debug.core.model.ScriptStackFrame;
import org.eclipse.dltk.internal.launching.LaunchConfigurationUtils;
import org.eclipse.dltk.launching.sourcelookup.DBGPSourceModule;
import org.eclipse.ldt.debug.core.internal.UnreachableStackFrame;

public class LuaSourceLookupDirector
extends AbstractSourceLookupDirector {
    public void initializeParticipants() {
        this.addParticipants(new ISourceLookupParticipant[]{new LuaSourceLookupParticipant()});
    }

    public Object getSourceElement(Object element) {
        ScriptStackFrame frame;
        UnreachableStackFrame unreachableStackFrame;
        if (element instanceof IScriptStackFrame && (unreachableStackFrame = UnreachableStackFrame.checkReachable((IScriptStackFrame)(frame = (ScriptStackFrame)element))) != null) {
            return unreachableStackFrame;
        }
        Object o = super.getSourceElement(element);
        if (o instanceof IFile || o instanceof IStorage) {
            return o;
        }
        if (element instanceof ScriptStackFrame) {
            ScriptStackFrame frame2 = (ScriptStackFrame)element;
            URI uri = frame2.getSourceURI();
            String path = uri.getPath();
            IProject project = LaunchConfigurationUtils.getProject((ILaunchConfiguration)this.getLaunchConfiguration());
            if (project == null) {
                return null;
            }
            IScriptProject scriptProject = DLTKCore.create((IProject)project);
            return new DBGPSourceModule((ScriptProject)scriptProject, path, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, frame2);
        }
        return null;
    }

    private static class LuaSourceLookupParticipant
    extends AbstractSourceLookupParticipant {
        private LuaSourceLookupParticipant() {
        }

        public String getSourceName(Object object) throws CoreException {
            URI uri = null;
            if (object instanceof URI) {
                uri = (URI)object;
            } else if (object instanceof ScriptStackFrame) {
                uri = ((ScriptStackFrame)object).getSourceURI();
            } else {
                return null;
            }
            return uri.toString();
        }
    }
}

