/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.model.view.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.jwt.we.model.view.Diagram;
import org.eclipse.jwt.we.model.view.EdgeDirection;
import org.eclipse.jwt.we.model.view.LayoutData;
import org.eclipse.jwt.we.model.view.Reference;
import org.eclipse.jwt.we.model.view.ReferenceEdge;
import org.eclipse.jwt.we.model.view.ViewFactory;
import org.eclipse.jwt.we.model.view.ViewPackage;
import org.eclipse.jwt.we.model.view.impl.DiagramImpl;
import org.eclipse.jwt.we.model.view.impl.LayoutDataImpl;
import org.eclipse.jwt.we.model.view.impl.ReferenceEdgeImpl;
import org.eclipse.jwt.we.model.view.impl.ReferenceImpl;

public class ViewFactoryImpl
extends EFactoryImpl
implements ViewFactory {
    public static final String copyright = "Copyright (c) 2005-2012  Eclipse Java Workflow Tooling (JWT) Project <www.eclipse.org/jwt>";

    public static ViewFactory init() {
        try {
            ViewFactory theViewFactory = (ViewFactory)EPackage.Registry.INSTANCE.getEFactory("org.eclipse.jwt/view");
            if (theViewFactory != null) {
                return theViewFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ViewFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createLayoutData();
            }
            case 1: {
                return this.createReference();
            }
            case 2: {
                return this.createReferenceEdge();
            }
            case 3: {
                return this.createDiagram();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 4: {
                return this.createEdgeDirectionFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 4: {
                return this.convertEdgeDirectionToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public LayoutData createLayoutData() {
        LayoutDataImpl layoutData = new LayoutDataImpl();
        return layoutData;
    }

    public Reference createReference() {
        ReferenceImpl reference = new ReferenceImpl();
        return reference;
    }

    public ReferenceEdge createReferenceEdge() {
        ReferenceEdgeImpl referenceEdge = new ReferenceEdgeImpl();
        return referenceEdge;
    }

    public Diagram createDiagram() {
        DiagramImpl diagram = new DiagramImpl();
        return diagram;
    }

    public EdgeDirection createEdgeDirectionFromString(EDataType eDataType, String initialValue) {
        EdgeDirection result = EdgeDirection.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertEdgeDirectionToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ViewPackage getViewPackage() {
        return (ViewPackage)this.getEPackage();
    }

    @Deprecated
    public static ViewPackage getPackage() {
        return ViewPackage.eINSTANCE;
    }
}

