/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.preferences.wrappers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jwt.we.editors.preferences.wrappers.WEPreferenceStoreInterface;
import org.eclipse.jwt.we.misc.util.FontUtil;
import org.eclipse.swt.graphics.Font;

public class FontPreferenceWrapper {
    private String preferenceKey;
    private Font cachedFont;
    private String cachedFontString;
    private Font cachedFontDefault;
    private String cachedFontStringDefault;
    private static List<Font> fontRegistry;

    public FontPreferenceWrapper(String preferenceKey) {
        this.preferenceKey = preferenceKey;
        fontRegistry = new ArrayList<Font>();
    }

    public Font get() {
        String fontDataString = WEPreferenceStoreInterface.getValueAsString(this.preferenceKey);
        if (this.cachedFont != null && !this.cachedFont.isDisposed() && this.cachedFontString.equals(fontDataString)) {
            return this.cachedFont;
        }
        this.cachedFont = FontUtil.deSerializeFont(fontDataString);
        this.cachedFontString = fontDataString;
        fontRegistry.add(this.cachedFont);
        return this.cachedFont;
    }

    public void set(Font value) {
        String fontDataString = FontUtil.serializeFont(value);
        WEPreferenceStoreInterface.setValueString(this.preferenceKey, fontDataString);
    }

    public Font getDefault() {
        String fontDataString = WEPreferenceStoreInterface.getDefaultValueAsString(this.preferenceKey);
        if (this.cachedFontDefault != null && !this.cachedFontDefault.isDisposed() && this.cachedFontStringDefault.equals(fontDataString)) {
            return this.cachedFontDefault;
        }
        this.cachedFontDefault = FontUtil.deSerializeFont(fontDataString);
        this.cachedFontStringDefault = fontDataString;
        fontRegistry.add(this.cachedFontDefault);
        return this.cachedFontDefault;
    }

    public void setDefault() {
        WEPreferenceStoreInterface.setDefaultValueString(this.preferenceKey);
    }

    public static void disposeFonts() {
        for (Font font : fontRegistry) {
            if (font.isDisposed()) continue;
            font.dispose();
        }
        fontRegistry.clear();
    }
}

