/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dom.html;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jst.pagedesigner.dom.html.ColStructure;
import org.eclipse.jst.pagedesigner.dom.html.TableChildElementPosition;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableUtil {
    private Element _fakeCell = null;
    private Element _table = null;
    private List[] _trCellLists = null;

    public static boolean hasRowSpanElement(Element tr) {
        List list = DOMUtil.getElementChildren(tr);
        for (Element ele : list) {
            int value = DOMUtil.getIntAttributeIgnoreCase(ele, "rowspan", 1);
            if (value <= 1) continue;
            return true;
        }
        return false;
    }

    public static boolean isAffectedByRowSpan(List trList, Element tr, int index) {
        Node parent = tr.getParentNode();
        int dex = index;
        while (--dex >= 0) {
            Element preTr = (Element)trList.get(dex);
            if (preTr.getParentNode() != parent) break;
            int maxRowSpan = TableUtil.countMaxRowSpan(preTr);
            if (maxRowSpan <= index - dex) continue;
            return true;
        }
        return false;
    }

    public static void getTrElements(Element element, List list) {
        NodeList nodeList = element.getChildNodes();
        int i = 0;
        int size = nodeList.getLength();
        while (i < size) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                Element ele = (Element)node;
                if (ele.getNodeName().equalsIgnoreCase("tr")) {
                    list.add(ele);
                } else if (ele.getNodeName().equalsIgnoreCase("thead") || ele.getNodeName().equalsIgnoreCase("tbody") || ele.getNodeName().equalsIgnoreCase("tfoot")) {
                    TableUtil.getTrElements(ele, list);
                }
            }
            ++i;
        }
    }

    public static int countRowIndexInDOMTree(Element table, int displayIndex) {
        int footRows = TableUtil.countSectionRows(table, "tfoot");
        if (footRows == 0) {
            return displayIndex;
        }
        int headRows = TableUtil.countSectionRows(table, "thead");
        ArrayList list = new ArrayList();
        TableUtil.getTrElements(table, list);
        int bodyRows = list.size() - headRows - footRows;
        if (displayIndex >= list.size() - footRows) {
            int index = displayIndex - bodyRows;
            return index;
        }
        if (displayIndex >= headRows) {
            int index = displayIndex + footRows;
            return index;
        }
        return displayIndex;
    }

    public static int countSectionRows(Element table, String sectionName) {
        NodeList nodeList = table.getChildNodes();
        int i = 0;
        int size = nodeList.getLength();
        while (i < size) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                List list;
                Element ele = (Element)node;
                if (node.getNodeName().equalsIgnoreCase(sectionName) && (list = DOMUtil.getChildElementsByTagIgnoreCase(ele, "tr")) != null) {
                    return list.size();
                }
            }
            ++i;
        }
        return 0;
    }

    public TableUtil(Element table) {
        this._table = table;
        this._trCellLists = this.fillTrCells();
    }

    public List[] getTrCellLists() {
        return this._trCellLists;
    }

    public TableChildElementPosition getPosition(Node node) {
        TableChildElementPosition position = new TableChildElementPosition();
        if (node == null) {
            return position;
        }
        String tagName = node.getLocalName();
        if ("tr".equalsIgnoreCase(tagName)) {
            ArrayList list = new ArrayList();
            TableUtil.getTrElements(this._table, list);
            int i = 0;
            int size = list.size();
            while (i < size) {
                Element tr = (Element)list.get(i);
                if (tr == node) {
                    position.setRowIndex(i);
                    break;
                }
                ++i;
            }
        } else if ("td".equalsIgnoreCase(tagName) || "th".equalsIgnoreCase(tagName)) {
            Element tr = (Element)node.getParentNode();
            TableChildElementPosition pos = this.getPosition(tr);
            position.setRowIndex(pos.getRowIndex());
            List[] lists = this.getTrCellLists();
            List list = lists[pos.getRowIndex()];
            int i = 0;
            int size = list.size();
            while (i < size) {
                Element td = (Element)list.get(i);
                if (td == node) {
                    position.setColumnIndex(i);
                    break;
                }
                ++i;
            }
        } else {
            boolean hasTDParent = false;
            Node childBackup = node;
            while (!"table".equalsIgnoreCase(childBackup.getParentNode().getLocalName())) {
                String localName = (childBackup = childBackup.getParentNode()).getLocalName();
                if (!"td".equalsIgnoreCase(localName) && !"th".equalsIgnoreCase(localName)) continue;
                hasTDParent = true;
                break;
            }
            if (hasTDParent) {
                position = this.getPosition(childBackup);
            }
        }
        return position;
    }

    public int getColumnCount() {
        List[] lists = this._trCellLists;
        if (lists != null) {
            int max = 0;
            int i = 0;
            int size = lists.length;
            while (i < size) {
                List list = lists[i];
                if (list.size() > max) {
                    max = list.size();
                }
                ++i;
            }
            return max;
        }
        return 0;
    }

    public boolean hasColumnSpanElement(int columnIndex) {
        List cells = this.getColumnCells(columnIndex);
        if (cells != null) {
            for (Element cell : cells) {
                int value = DOMUtil.getIntAttributeIgnoreCase(cell, "colspan", 1);
                if (value <= 1) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAffectedByColSpan(int columnIndex) {
        int index = columnIndex;
        while (--index >= 0) {
            List cells = this.getColumnCells(index);
            int max = this.countMaxColSpan(cells);
            if (max <= columnIndex - index) continue;
            return true;
        }
        return false;
    }

    public List getColumnCells(int columnIndex) {
        ArrayList list = new ArrayList();
        List[] lists = this._trCellLists;
        int i = 0;
        while (i < lists.length) {
            List tempList = lists[i];
            if (tempList.size() > columnIndex) {
                list.add(tempList.get(columnIndex));
            }
            ++i;
        }
        return list;
    }

    private static int countMaxRowSpan(Element tr) {
        List list = DOMUtil.getElementChildren(tr);
        int max = TableUtil.countMaxValue(list, "rowspan");
        return max;
    }

    private static int countMaxValue(List list, String attr) {
        int max = 1;
        for (Element ele : list) {
            int value = DOMUtil.getIntAttributeIgnoreCase(ele, attr, 1);
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    private int countMaxColSpan(List list) {
        int max = TableUtil.countMaxValue(list, "colspan");
        return max;
    }

    private Element getFakeElement() {
        if (this._fakeCell != null) {
            return this._fakeCell;
        }
        this._fakeCell = this._table.getOwnerDocument().createElement("fake");
        return this._fakeCell;
    }

    private List[] initialTrCells(List trList) {
        int size = trList.size();
        List[] lists = new ArrayList[size];
        if (trList != null) {
            int i = 0;
            int n = trList.size();
            while (i < n) {
                lists[i] = new ArrayList();
                Element tr = (Element)trList.get(i);
                List domCells = DOMUtil.getElementChildren(tr);
                for (Element cell : domCells) {
                    lists[i].add(cell);
                    int colSpan = DOMUtil.getIntAttributeIgnoreCase(cell, "colspan", 1);
                    while (--colSpan > 0) {
                        Element fakeElement = this.getFakeElement();
                        lists[i].add(fakeElement);
                    }
                }
                ++i;
            }
        }
        return lists;
    }

    private List[] fillTrCells() {
        int bodyRows;
        int footRows;
        ArrayList list = new ArrayList();
        TableUtil.getTrElements(this._table, list);
        List[] lists = this.initialTrCells(list);
        int size = lists.length;
        int headRows = TableUtil.countSectionRows(this._table, "thead");
        if (headRows > 0) {
            List[] headList = new ArrayList[headRows];
            int i = 0;
            while (i < headRows) {
                headList[i] = lists[i];
                ++i;
            }
            this.fillSectionTrCells(headList);
        }
        if ((footRows = TableUtil.countSectionRows(this._table, "tfoot")) > 0) {
            List[] footList = new ArrayList[footRows];
            int i = 0;
            while (i < footRows) {
                footList[i] = lists[headRows + i];
                ++i;
            }
            this.fillSectionTrCells(footList);
        }
        if ((bodyRows = size - headRows - footRows) > 0) {
            int bodyCount = 1;
            int k = 0;
            ArrayList<Integer> bodys = new ArrayList<Integer>();
            Element tr = (Element)list.get(headRows + footRows);
            Node node = tr.getParentNode();
            int i = 1;
            while (i < bodyRows) {
                Element tempTr = (Element)list.get(headRows + footRows + i);
                if (tempTr.getParentNode() != node) {
                    node = tempTr.getParentNode();
                    bodys.add(new Integer(i - k));
                    k = i;
                    ++bodyCount;
                }
                ++i;
            }
            bodys.add(new Integer(bodyRows - k));
            int j = 0;
            while (j < bodyCount) {
                int num = (Integer)bodys.get(j);
                List[] bodyList = new ArrayList[num];
                int m = headRows + footRows;
                int i2 = 0;
                while (i2 < num) {
                    bodyList[i2] = lists[m + i2];
                    ++i2;
                }
                this.fillSectionTrCells(bodyList);
                m += num;
                ++j;
            }
        }
        return lists;
    }

    private void fillSectionTrCells(List[] lists) {
        Element cell = null;
        if (lists != null) {
            int i = 1;
            int size = lists.length;
            while (i < size) {
                ArrayList<ColStructure> insertPoints = new ArrayList<ColStructure>();
                int j = 0;
                while (j < i) {
                    List list = lists[j];
                    int column = 0;
                    while (column < list.size()) {
                        int rowSpan;
                        cell = (Element)list.get(column);
                        if (!cell.getTagName().equalsIgnoreCase("fake") && (rowSpan = DOMUtil.getIntAttributeIgnoreCase(cell, "rowspan", 1)) > i - j) {
                            int colSpan = DOMUtil.getIntAttributeIgnoreCase(cell, "colspan", 1);
                            insertPoints.add(new ColStructure(column, colSpan));
                        }
                        ++column;
                    }
                    ++j;
                }
                if (insertPoints.size() > 0) {
                    Collections.sort(insertPoints);
                    List trCells = lists[i];
                    for (ColStructure cls : insertPoints) {
                        int loop = cls.getColSpan();
                        int column = cls.getColumn();
                        while (loop-- != 0) {
                            trCells.add(column++, this.getFakeElement());
                        }
                    }
                }
                ++i;
            }
        }
    }
}

