/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.validation;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.JSPCorePlugin;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParser;
import org.eclipse.jst.jsp.core.internal.java.jspel.ParseException;
import org.eclipse.jst.jsp.core.internal.java.jspel.Token;
import org.eclipse.jst.jsp.core.internal.java.jspel.TokenMgrError;
import org.eclipse.jst.jsp.core.internal.validation.JSPValidator;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class JSPELValidator
extends JSPValidator {
    private static final boolean DEBUG = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/jspvalidator"));
    private static final String PREFERENCE_NODE_QUALIFIER = JSPCorePlugin.getDefault().getBundle().getSymbolicName();
    private static final int MAX_REGIONS = 1000;
    private IValidator fMessageOriginator;
    private IPreferencesService fPreferencesService = null;
    private IScopeContext[] fScopes = null;

    public JSPELValidator() {
        this.fMessageOriginator = this;
    }

    public JSPELValidator(IValidator validator) {
        this.fMessageOriginator = validator;
    }

    /*
     * Exception decompiling
     */
    protected void validateFile(IFile file, IReporter reporter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 111->115)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void loadPreferences(IFile file) {
        ProjectScope projectScope;
        this.fScopes = new IScopeContext[]{new InstanceScope(), new DefaultScope()};
        this.fPreferencesService = Platform.getPreferencesService();
        if (file != null && file.isAccessible() && (projectScope = new ProjectScope(file.getProject())).getNode(PREFERENCE_NODE_QUALIFIER).getBoolean("validation.use-project-settings", false)) {
            this.fScopes = new IScopeContext[]{projectScope, new InstanceScope(), new DefaultScope()};
        }
    }

    int getMessageSeverity(String key) {
        int sev = this.fPreferencesService.getInt(PREFERENCE_NODE_QUALIFIER, key, 2, this.fScopes);
        switch (sev) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case -1: {
                return -1;
            }
        }
        return 2;
    }

    private void unloadPreferences() {
        this.fPreferencesService = null;
        this.fScopes = null;
    }

    protected void performValidation(IFile file, IReporter reporter, IStructuredDocument structuredDoc) {
        this.loadPreferences(file);
        IStructuredDocumentRegion curNode = structuredDoc.getFirstStructuredDocumentRegion();
        while (curNode != null && !reporter.isCancelled()) {
            if (curNode.getType() != "XML_COMMENT_TEXT" && curNode.getType() != "XML_CDATA_TEXT" && curNode.getType() != "UNDEFINED") {
                this.validateRegionContainer((ITextRegionCollection)curNode, reporter, file);
            }
            curNode = curNode.getNext();
        }
        this.unloadPreferences();
    }

    protected void validateRegionContainer(ITextRegionCollection container, IReporter reporter, IFile file) {
        ITextRegionCollection containerRegion = container;
        Iterator regions = containerRegion.getRegions().iterator();
        ITextRegion region = null;
        while (regions.hasNext() && !reporter.isCancelled()) {
            region = (ITextRegion)regions.next();
            String type = region.getType();
            if (type == null || !(region instanceof ITextRegionCollection)) continue;
            ITextRegionCollection parentRegion = (ITextRegionCollection)region;
            Iterator childRegions = parentRegion.getRegions().iterator();
            while (childRegions.hasNext() && !reporter.isCancelled()) {
                ITextRegion childRegion = (ITextRegion)childRegions.next();
                if (childRegion.getType() != "JSP_EL_OPEN") continue;
                this.validateELContent(parentRegion, childRegion, childRegions, reporter, file);
            }
        }
    }

    protected void validateELContent(ITextRegionCollection container, ITextRegion elOpenRegion, Iterator elRegions, IReporter reporter, IFile file) {
        block5: {
            int contentStart = elOpenRegion.getEnd();
            int contentDocStart = container.getEndOffset(elOpenRegion);
            int contentLength = container.getLength();
            int regionCount = 0;
            ITextRegion elRegion = null;
            while (elRegions != null && elRegions.hasNext() && regionCount++ < 1000) {
                elRegion = (ITextRegion)elRegions.next();
                if (elRegion.getType() == "JSP_EL_CLOSE") break;
            }
            String elText = container.getFullText().substring(contentStart, elRegion != null ? elRegion.getStart() : contentLength - 1);
            JSPELParser elParser = JSPELParser.createParser(elText);
            try {
                elParser.Expression();
            }
            catch (ParseException e) {
                int sev = this.getMessageSeverity("validation.el-general-syntax");
                if (sev != -1) {
                    Token curTok = e.currentToken;
                    int problemStartOffset = contentDocStart + curTok.beginColumn;
                    JSPValidator.LocalizedMessage message = new JSPValidator.LocalizedMessage(sev, JSPCoreMessages.JSPEL_Syntax);
                    message.setOffset(problemStartOffset);
                    message.setLength(curTok.endColumn - curTok.beginColumn + 1);
                    message.setTargetObject(file);
                    reporter.addMessage(this.fMessageOriginator, (IMessage)message);
                }
            }
            catch (TokenMgrError tokenMgrError) {
                int sev = this.getMessageSeverity("validation.el-lexical-failure");
                if (sev == -1) break block5;
                JSPValidator.LocalizedMessage message = new JSPValidator.LocalizedMessage(2, JSPCoreMessages.JSPEL_Token);
                message.setOffset(contentDocStart);
                message.setLength(contentLength);
                message.setTargetObject(file);
                reporter.addMessage(this.fMessageOriginator, (IMessage)message);
            }
        }
    }

    protected void validateXMLNode(ITextRegionCollection container, ITextRegion region, IReporter reporter, IFile file) {
        block4: {
            String elText = container.getText(region);
            JSPELParser elParser = JSPELParser.createParser(elText);
            int contentStart = container.getStartOffset(region);
            int contentLength = container.getLength();
            try {
                elParser.Expression();
            }
            catch (ParseException e) {
                int sev = this.getMessageSeverity("validation.el-general-syntax");
                if (sev != -1) {
                    Token curTok = e.currentToken;
                    int problemStartOffset = contentStart + curTok.beginColumn;
                    JSPValidator.LocalizedMessage message = new JSPValidator.LocalizedMessage(sev, JSPCoreMessages.JSPEL_Syntax);
                    message.setOffset(problemStartOffset);
                    message.setLength(curTok.endColumn - curTok.beginColumn + 1);
                    message.setTargetObject(file);
                    reporter.addMessage(this.fMessageOriginator, (IMessage)message);
                }
            }
            catch (TokenMgrError tokenMgrError) {
                int sev = this.getMessageSeverity("validation.el-lexical-failure");
                if (sev == -1) break block4;
                JSPValidator.LocalizedMessage message = new JSPValidator.LocalizedMessage(2, JSPCoreMessages.JSPEL_Token);
                message.setOffset(contentStart);
                message.setLength(contentLength);
                message.setTargetObject(file);
                reporter.addMessage(this.fMessageOriginator, (IMessage)message);
            }
        }
    }
}

