/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.navigator;

import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.navigator.internal.J2EELabelProvider;
import org.eclipse.jst.j2ee.navigator.internal.plugin.J2EENavigatorPlugin;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.jee.ui.internal.navigator.ear.AbstractEarNode;
import org.eclipse.jst.jee.ui.internal.navigator.ear.GroupEARProvider;
import org.eclipse.jst.jee.ui.plugin.JEEUIPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.componentcore.internal.util.VirtualReferenceUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class Ear5LabelProvider
extends J2EELabelProvider {
    private static ImageDescriptor IMG_MODULES_NODE;
    private static ImageDescriptor IMG_MODULE_UTIL;
    private static ImageDescriptor IMG_MODULE_WEB;
    private static ImageDescriptor IMG_MODULE_EJB;
    private static ImageDescriptor IMG_MODULE_CLIENT;
    private static ImageDescriptor IMG_MODULE_CONNECTOR;
    private static HashMap<String, ImageDescriptor> typeToDescriptor;

    static {
        try {
            IMG_MODULES_NODE = J2EENavigatorPlugin.getDefault().getImageDescriptor("folder.gif");
            IMG_MODULE_UTIL = ImageDescriptor.createFromURL((URL)((URL)J2EEPlugin.getPlugin().getImage("utiljar_obj")));
            IMG_MODULE_WEB = ImageDescriptor.createFromURL((URL)((URL)J2EEPlugin.getPlugin().getImage("full/obj16/module_web_obj")));
            IMG_MODULE_EJB = ImageDescriptor.createFromURL((URL)((URL)J2EEPlugin.getPlugin().getImage("full/obj16/module_ejb_obj")));
            IMG_MODULE_CLIENT = ImageDescriptor.createFromURL((URL)((URL)J2EEPlugin.getPlugin().getImage("module_clientapp_obj")));
            IMG_MODULE_CONNECTOR = ImageDescriptor.createFromURL((URL)((URL)J2EEPlugin.getPlugin().getImage("full/obj16/connector_module")));
        }
        catch (RuntimeException e) {
            String msg = e.getMessage() != null ? e.getMessage() : e.toString();
            JEEUIPlugin.logError(msg, e);
            IMG_MODULES_NODE = ImageDescriptor.getMissingImageDescriptor();
            IMG_MODULE_UTIL = ImageDescriptor.getMissingImageDescriptor();
            IMG_MODULE_WEB = ImageDescriptor.getMissingImageDescriptor();
            IMG_MODULE_EJB = ImageDescriptor.getMissingImageDescriptor();
            IMG_MODULE_CLIENT = ImageDescriptor.getMissingImageDescriptor();
            IMG_MODULE_CONNECTOR = ImageDescriptor.getMissingImageDescriptor();
        }
        typeToDescriptor = new HashMap();
        typeToDescriptor.put("jst.appclient", IMG_MODULE_CLIENT);
        typeToDescriptor.put("jst.web", IMG_MODULE_WEB);
        typeToDescriptor.put("jst.ejb", IMG_MODULE_EJB);
        typeToDescriptor.put("jst.connector", IMG_MODULE_CONNECTOR);
        typeToDescriptor.put("jst.utility", IMG_MODULE_UTIL);
    }

    public Image getImage(Object element) {
        Image ret = null;
        if (element instanceof AbstractEarNode) {
            ret = J2EENavigatorPlugin.getDefault().getImage(IMG_MODULES_NODE);
        } else if (element instanceof IVirtualReference) {
            IVirtualComponent component = ((IVirtualReference)element).getReferencedComponent();
            if (component.isBinary()) {
                ret = J2EENavigatorPlugin.getDefault().getImage(IMG_MODULE_UTIL);
            } else {
                String type = JavaEEProjectUtilities.getJ2EEComponentType((IVirtualComponent)component);
                ImageDescriptor desc = typeToDescriptor.get(type);
                ret = J2EENavigatorPlugin.getDefault().getImage(desc == null ? IMG_MODULE_UTIL : desc);
            }
        } else if (element instanceof GroupEARProvider) {
            ret = ((GroupEARProvider)element).getImage();
        }
        return ret;
    }

    public String getText(Object element) {
        String ret = null;
        if (element instanceof AbstractEarNode) {
            ret = ((AbstractEarNode)element).getText();
        } else if (element instanceof IVirtualReference) {
            IVirtualComponent component = ((IVirtualReference)element).getReferencedComponent();
            String archiveName = ((IVirtualReference)element).getArchiveName();
            if (component.isBinary()) {
                ret = archiveName != null ? archiveName : new Path(component.getDeployedName()).lastSegment();
            } else {
                String type = JavaEEProjectUtilities.getJ2EEComponentType((IVirtualComponent)component);
                if (archiveName == null) {
                    archiveName = VirtualReferenceUtilities.INSTANCE.getDefaultArchiveName((IVirtualReference)element);
                }
                if (type.equals("jst.web")) {
                    ret = "Web " + archiveName;
                } else if (type.equals("jst.ejb")) {
                    ret = "EJB " + archiveName;
                } else if (type.equals("jst.appclient")) {
                    ret = "APP Client " + archiveName;
                } else if (type.equals("jst.connector")) {
                    ret = "Connector " + archiveName;
                } else if (type.equals("jst.utility")) {
                    ret = archiveName;
                }
            }
        } else if (element instanceof GroupEARProvider) {
            ret = ((GroupEARProvider)element).getText();
        }
        return ret;
    }
}

