/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.service;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecoretools.design.service.DesignServices;
import org.eclipse.emf.ecoretools.design.service.EGenericsServices;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class EReferenceServices {
    private static final String CARDINALITY_SEPARATOR = "..";
    public static final String EOPPOSITE_SEPARATOR = " - ";
    public static final String DERIVED_PREFIX = "/";
    public static final String CARDINALITY_UNBOUNDED = "*";
    public static final String CARDINALITY_UNBOUNDED_ALTERNATIVE = "-1";
    private static final String TYPE_SEPARATOR = ":";

    public String getEOppositeEReferenceName(EReference ref) {
        if (ref.getEOpposite() != null) {
            return String.valueOf(this.render(ref.getEOpposite())) + EOPPOSITE_SEPARATOR + this.render(ref);
        }
        return "";
    }

    public List<EReference> getInverseEReferences(EObject ctx) {
        Session sess = SessionManager.INSTANCE.getSession(ctx);
        ArrayList result = Lists.newArrayList();
        if (sess != null) {
            for (EStructuralFeature.Setting setting : sess.getSemanticCrossReferencer().getInverseReferences(ctx)) {
                if (!(setting.getEObject() instanceof EReference)) continue;
                result.add((EReference)setting.getEObject());
            }
        }
        return result;
    }

    public void setEType(EObject host, EObject target) {
        if (host instanceof ETypedElement) {
            EGenericsServices.setETypeWithGenerics((ETypedElement)host, target);
        }
    }

    public String eKeysLabel(EReference ref) {
        String result = "";
        ArrayList names = Lists.newArrayList();
        for (EAttribute attr : ref.getEKeys()) {
            if (attr.getName() == null) continue;
            names.add(attr.getName());
        }
        result = String.valueOf(result) + Joiner.on((char)',').join((Iterable)names);
        return result;
    }

    public EObject getEReferenceTarget(EReference ref) {
        return EGenericsServices.getETypeOrParameter((ETypedElement)ref);
    }

    public EObject getEdgeTargetSemantic(EObject any, DEdge view) {
        return ((DSemanticDecorator)view.getTargetNode()).getTarget();
    }

    public EObject getEdgeSourceSemantic(EObject any, DEdge view) {
        return ((DSemanticDecorator)view.getSourceNode()).getTarget();
    }

    public List<EReference> getEOppositeEReferences(EPackage context, DSemanticDiagram diagram) {
        Set<EClass> eClasses = new DesignServices().getDisplayedEClasses(diagram);
        LinkedHashSet references = Sets.newLinkedHashSet();
        for (EClass clazz : eClasses) {
            references.addAll(clazz.getEReferences());
        }
        HashMap<String, EReference> map = new HashMap<String, EReference>();
        for (EReference ref : references) {
            if (ref.getEOpposite() == null) continue;
            String key1 = String.valueOf(ref.getEOpposite().hashCode()) + ref.hashCode();
            String key2 = String.valueOf(ref.hashCode()) + ref.getEOpposite().hashCode();
            if (map.get(key1) != null || map.get(key2) != null) continue;
            map.put(key1, ref);
        }
        return new ArrayList<EReference>(map.values());
    }

    public String render(EReference ref) {
        StringBuilder sb = new StringBuilder();
        this.renderCardinality(ref, sb);
        this.renderName(ref, sb);
        return sb.toString();
    }

    public String renderAsNode(EReference ref) {
        StringBuilder sb = new StringBuilder();
        this.renderName(ref, sb);
        this.renderType(ref, sb);
        return sb.toString();
    }

    private void renderType(EReference ref, StringBuilder sb) {
        String typeName = EGenericsServices.getETypeLabel((ETypedElement)ref);
        if (typeName != null) {
            if (ref.getName() != null) {
                sb.append(" ");
            }
            sb.append(TYPE_SEPARATOR).append(" ").append(typeName);
        }
    }

    private void renderCardinality(EReference ref, StringBuilder sb) {
        sb.append("[");
        sb.append(this.renderBound(ref.getLowerBound()));
        sb.append(CARDINALITY_SEPARATOR);
        sb.append(this.renderBound(ref.getUpperBound()));
        sb.append("]");
    }

    private String renderBound(int bound) {
        if (bound == -1) {
            return CARDINALITY_UNBOUNDED;
        }
        return String.valueOf(bound);
    }

    private void renderName(EReference ref, StringBuilder sb) {
        if (ref.getName() != null) {
            sb.append(" ");
            if (ref.isDerived()) {
                sb.append(DERIVED_PREFIX);
            }
            sb.append(ref.getName());
        }
    }

    public String superTypesLabel(EClass any) {
        ArrayList reifiedTypes = Lists.newArrayList();
        ArrayList typeParameters = Lists.newArrayList();
        for (EGenericType genType : any.getEGenericSuperTypes()) {
            if (genType.getEClassifier() != null) {
                for (ETypeParameter param : genType.getEClassifier().getETypeParameters()) {
                    if (param.getName() != null) {
                        typeParameters.add(param.getName());
                        continue;
                    }
                    typeParameters.add("?");
                }
            }
            for (EGenericType argument : genType.getETypeArguments()) {
                if (argument.getEClassifier() != null && argument.getEClassifier().getName() != null) {
                    reifiedTypes.add(argument.getEClassifier().getName());
                    continue;
                }
                if (argument.getETypeParameter() != null && argument.getETypeParameter().getName() != null) {
                    reifiedTypes.add(argument.getETypeParameter().getName());
                    continue;
                }
                reifiedTypes.add("?");
            }
        }
        if (reifiedTypes.size() > 0) {
            return "<<bind " + Joiner.on((char)',').join((Iterable)typeParameters) + ">> " + Joiner.on((char)',').join((Iterable)reifiedTypes);
        }
        return null;
    }

    public void createTypeArgumentsIfNeeded(EClass host, EClass target) {
        for (EGenericType genSuperType : host.getEGenericSuperTypes()) {
            if (genSuperType.getEClassifier() == null) continue;
            int parameters = genSuperType.getEClassifier().getETypeParameters().size();
            if (genSuperType.getETypeArguments().size() > parameters) {
                int i = genSuperType.getETypeArguments().size();
                while (i > parameters) {
                    genSuperType.getETypeArguments().remove(i);
                    --i;
                }
                continue;
            }
            if (genSuperType.getETypeArguments().size() >= parameters) continue;
            int delta = parameters - genSuperType.getETypeArguments().size();
            int i = 0;
            while (i < delta) {
                genSuperType.getETypeArguments().add((Object)EcoreFactory.eINSTANCE.createEGenericType());
                ++i;
            }
        }
    }

    public EReference performEdit(EReference ref, String editString) {
        if ("0".equals(editString.trim())) {
            ref.setLowerBound(0);
        } else if ("1".equals(editString.trim())) {
            ref.setLowerBound(1);
        } else if ("11".equals(editString.trim())) {
            ref.setLowerBound(1);
            ref.setUpperBound(1);
        } else if (CARDINALITY_UNBOUNDED.equals(editString.trim())) {
            ref.setUpperBound(-1);
        } else if (CARDINALITY_UNBOUNDED_ALTERNATIVE.equals(editString.trim())) {
            ref.setUpperBound(-1);
        } else {
            this.editName(ref, editString);
            this.editCardinality(ref, editString);
        }
        return ref;
    }

    private void editName(EReference ref, String editString) {
        String namePart = this.extractNamePart(ref, editString);
        if (namePart != null && namePart.trim().length() > 0) {
            boolean derived = namePart.startsWith(DERIVED_PREFIX);
            ref.setDerived(derived);
            ref.setName(namePart.substring(derived ? DERIVED_PREFIX.length() : 0).trim());
        }
    }

    private String extractNamePart(EReference ref, String name) {
        int end = name.indexOf("]");
        if (end != -1 && end < name.length()) {
            return name.substring(end + 1).trim();
        }
        return name.trim();
    }

    private void editCardinality(EReference ref, String editString) {
        List<Integer> card = this.parseCardinality(editString);
        if (card.get(0) != null) {
            ref.setLowerBound(card.get(0).intValue());
        }
        if (card.get(1) != null) {
            ref.setUpperBound(card.get(1).intValue());
        }
    }

    public List<Integer> parseCardinality(String editString) {
        ArrayList result = Lists.newArrayList((Object[])new Integer[]{null, null});
        String spec = this.extractCardinalityPart(editString);
        if (spec != null && spec.contains(CARDINALITY_SEPARATOR)) {
            String[] parts = spec.split(Pattern.quote(CARDINALITY_SEPARATOR));
            switch (parts.length) {
                case 0: {
                    break;
                }
                case 1: {
                    if (spec.startsWith(CARDINALITY_SEPARATOR)) {
                        result.set(1, this.parseBound(parts[0]));
                        break;
                    }
                    if (!spec.endsWith(CARDINALITY_SEPARATOR)) break;
                    result.set(0, this.parseBound(parts[0]));
                    break;
                }
                default: {
                    result.set(0, this.parseBound(parts[0]));
                    result.set(1, this.parseBound(parts[1]));
                }
            }
        }
        return result;
    }

    private Integer parseBound(String bound) {
        if (CARDINALITY_UNBOUNDED.equals(bound.trim())) {
            return -1;
        }
        try {
            return Integer.parseInt(bound.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public String extractCardinalityPart(String editString) {
        int start = editString.indexOf("[");
        int end = editString.indexOf("]");
        if (start != -1 && end != -1 && start < end && end < editString.length()) {
            return editString.substring(start + 1, end).trim();
        }
        return null;
    }
}

