/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.util.collection.CloseableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectIDIterator
implements CloseableIterator<CDOID> {
    private IMappingStrategy mappingStrategy;
    private IIDHandler idHandler;
    private IDBStoreAccessor accessor;
    private ResultSet currentResultSet;
    private CDOID nextID;
    private boolean closed;

    public ObjectIDIterator(IMappingStrategy mappingStrategy, IDBStoreAccessor accessor) {
        this.mappingStrategy = mappingStrategy;
        this.accessor = accessor;
        this.idHandler = this.getMappingStrategy().getStore().getIDHandler();
    }

    public void close() {
        this.closeCurrentResultSet();
        this.nextID = null;
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public IMappingStrategy getMappingStrategy() {
        return this.mappingStrategy;
    }

    public IDBStoreAccessor getAccessor() {
        return this.accessor;
    }

    public boolean hasNext() {
        block6: {
            if (this.closed) {
                return false;
            }
            this.nextID = null;
            if (this.currentResultSet == null) {
                this.currentResultSet = this.getNextResultSet();
                if (this.currentResultSet == null) {
                    return false;
                }
            }
            try {
                if (!this.currentResultSet.next()) break block6;
                this.nextID = this.idHandler.getCDOID(this.currentResultSet, 1);
                return true;
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        this.closeCurrentResultSet();
        this.currentResultSet = null;
        return false;
    }

    protected void closeCurrentResultSet() {
        DBUtil.close((ResultSet)this.currentResultSet);
    }

    public CDOID next() {
        if (this.nextID == null) {
            throw new NoSuchElementException();
        }
        return this.nextID;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected abstract ResultSet getNextResultSet();
}

