/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.common;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.emf.cdo.common.lob.CDOLobInfo;
import org.eclipse.emf.cdo.common.lob.CDOLobStore;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.DigestWriter;
import org.eclipse.net4j.util.io.ExpectedFileInputStream;
import org.eclipse.net4j.util.io.ExpectedFileReader;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.OMPlatform;

public class CDOLobStoreImpl
implements CDOLobStore {
    public static final CDOLobStoreImpl INSTANCE = new CDOLobStoreImpl();
    private File folder;
    private int tempID;

    public CDOLobStoreImpl(File folder) {
        this.folder = folder;
        if (folder.exists()) {
            this.checkDirectory();
        }
    }

    public CDOLobStoreImpl() {
        this(CDOLobStoreImpl.getDefaultFolder());
    }

    public File getFolder() {
        if (!this.folder.exists()) {
            this.folder.mkdirs();
        }
        this.checkDirectory();
        return this.folder;
    }

    public File getBinaryFile(byte[] id) {
        return new File(this.getFolder(), String.valueOf(HexUtil.bytesToHex((byte[])id)) + ".blob");
    }

    public InputStream getBinary(CDOLobInfo info) throws IOException {
        File file = this.getBinaryFile(info.getID());
        long expectedSize = info.getSize();
        return new ExpectedFileInputStream(file, expectedSize);
    }

    public CDOLobInfo putBinary(InputStream contents) throws IOException {
        long size;
        File tempFile = this.getTempFile();
        MessageDigest digest = this.createDigest();
        digest.update("BINARY".getBytes());
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(tempFile);
            DigestOutputStream dos = new DigestOutputStream(fos, digest);
            size = IOUtil.copyBinary((InputStream)contents, (OutputStream)dos);
        }
        catch (Throwable throwable) {
            IOUtil.close(fos);
            throw throwable;
        }
        IOUtil.close((Closeable)fos);
        byte[] id = digest.digest();
        this.makePermanent(tempFile, this.getBinaryFile(id));
        return new CDOLobInfo(id, size);
    }

    public File getCharacterFile(byte[] id) {
        return new File(this.getFolder(), String.valueOf(HexUtil.bytesToHex((byte[])id)) + ".clob");
    }

    public Reader getCharacter(CDOLobInfo info) throws IOException {
        File file = this.getCharacterFile(info.getID());
        long expectedSize = info.getSize();
        return new ExpectedFileReader(file, expectedSize);
    }

    public CDOLobInfo putCharacter(Reader contents) throws IOException {
        long size;
        File tempFile = this.getTempFile();
        MessageDigest digest = this.createDigest();
        digest.update("CHARACTER".getBytes());
        FileWriter fw = null;
        try {
            fw = new FileWriter(tempFile);
            DigestWriter dw = new DigestWriter((Writer)fw, digest);
            size = IOUtil.copyCharacter((Reader)contents, (Writer)dw);
        }
        catch (Throwable throwable) {
            IOUtil.close(fw);
            throw throwable;
        }
        IOUtil.close((Closeable)fw);
        byte[] id = digest.digest();
        this.makePermanent(tempFile, this.getCharacterFile(id));
        return new CDOLobInfo(id, size);
    }

    public String toString() {
        return "CDOLobStore[" + this.folder + "]";
    }

    protected MessageDigest createDigest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    protected synchronized File getTempFile() {
        File file;
        do {
            ++this.tempID;
        } while ((file = new File(this.getFolder(), "contents" + this.tempID + ".tmp")).exists());
        return file;
    }

    private void makePermanent(File tempFile, File file) {
        if (file.exists()) {
            tempFile.delete();
        } else {
            tempFile.renameTo(file);
        }
    }

    private void checkDirectory() {
        if (!this.folder.isDirectory()) {
            throw new IORuntimeException("Not a folder: " + this.folder.getAbsolutePath());
        }
    }

    private static File getDefaultFolder() {
        String path = OMPlatform.INSTANCE.getProperty("java.io.tmpdir");
        return new File(new File(path), "cdo_lobs");
    }
}

