/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.platform.pde;

import org.eclipse.core.runtime.Assert;
import org.eclipse.egf.core.platform.internal.pde.AbstractPlatformExtensionPoint;
import org.eclipse.egf.core.platform.pde.IPlatformBundle;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPoint;
import org.eclipse.emf.common.util.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlatformExtensionPoint
extends AbstractPlatformExtensionPoint
implements IPlatformExtensionPoint,
Comparable<IPlatformExtensionPoint> {
    private String _id;

    public PlatformExtensionPoint(IPlatformBundle bundle, String id) {
        super(bundle);
        Assert.isNotNull((Object)id);
        Assert.isLegal((id.trim().length() > 0 ? 1 : 0) != 0);
        this._id = id.trim();
    }

    public PlatformExtensionPoint(IPlatformBundle bundle, String id, String uniqueIdentifier, int handleId) {
        super(bundle, uniqueIdentifier, handleId);
        Assert.isNotNull((Object)id);
        Assert.isLegal((id.trim().length() > 0 ? 1 : 0) != 0);
        this._id = id.trim();
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public String getUniqueIdentifier() {
        return this._uniqueIdentifier;
    }

    @Override
    public int getHandleId() {
        return this._handleId;
    }

    @Override
    public IPlatformBundle getPlatformBundle() {
        return this._platformBundle;
    }

    @Override
    public int compareTo(IPlatformExtensionPoint platformExtensionPoint) {
        return this.getId().compareTo(platformExtensionPoint.getId());
    }

    public int hashCode() {
        return (String.valueOf(this._platformBundle.getBundleId()) + URI.decode((String)this.getId())).hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof IPlatformExtensionPoint)) {
            return false;
        }
        IPlatformExtensionPoint platformExtensionPoint = (IPlatformExtensionPoint)object;
        if (!platformExtensionPoint.getPlatformBundle().equals(this.getPlatformBundle())) {
            return false;
        }
        if (this.getId().compareTo(platformExtensionPoint.getId()) != 0) {
            return false;
        }
        if (this.getUniqueIdentifier() != null && platformExtensionPoint.getUniqueIdentifier() != null) {
            if (this.getUniqueIdentifier().compareTo(platformExtensionPoint.getUniqueIdentifier()) != 0) {
                return false;
            }
            return this.getHandleId() == platformExtensionPoint.getHandleId();
        }
        return true;
    }

    public String toString() {
        return this.getId();
    }
}

