/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.internal.tools.wizards.classes;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.internal.tools.Messages;
import org.eclipse.e4.internal.tools.wizards.classes.AbstractNewClassPage;
import org.eclipse.e4.internal.tools.wizards.classes.NewAddonClassWizard;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.pde.core.project.IBundleProjectDescription;
import org.eclipse.pde.core.project.IBundleProjectService;
import org.eclipse.pde.core.project.IPackageImportDescription;
import org.eclipse.pde.core.project.IRequiredBundleDescription;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public abstract class AbstractNewClassWizard
extends Wizard
implements INewWizard {
    private static final String JAVA = ".java";
    protected IPackageFragmentRoot root;
    protected IFile file;
    private IStructuredSelection selection;

    public AbstractNewClassWizard() {
        this.setWindowTitle(Messages.AbstractNewClassWizard_NewClass);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.root = this.getFragmentRoot(this.getInitialJavaElement(selection));
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public void addPage(IWizardPage page) {
        super.addPage(page);
        if (page instanceof AbstractNewClassPage) {
            ((AbstractNewClassPage)page).init(this.getSelection());
        }
    }

    protected IJavaElement getInitialJavaElement(IStructuredSelection selection) {
        IAdaptable adaptable;
        Object selectedElement;
        IJavaElement jelem = null;
        if (!(selection == null || selection.isEmpty() || !((selectedElement = selection.getFirstElement()) instanceof IAdaptable) || (jelem = (IJavaElement)(adaptable = (IAdaptable)selectedElement).getAdapter(IJavaElement.class)) != null && jelem.exists())) {
            jelem = null;
            IResource resource = (IResource)adaptable.getAdapter(IResource.class);
            if (resource != null && resource.getType() != 8) {
                while (jelem == null && resource.getType() != 4) {
                    resource = resource.getParent();
                    jelem = (IJavaElement)resource.getAdapter(IJavaElement.class);
                }
                if (jelem == null) {
                    jelem = JavaCore.create((IResource)resource);
                }
            }
        }
        return jelem;
    }

    protected IPackageFragmentRoot getFragmentRoot(IJavaElement elem) {
        IPackageFragmentRoot initRoot = null;
        if (elem != null) {
            initRoot = (IPackageFragmentRoot)elem.getAncestor(3);
            try {
                IJavaProject jproject;
                if ((initRoot == null || initRoot.getKind() != 1) && (jproject = elem.getJavaProject()) != null) {
                    initRoot = null;
                    if (jproject.exists()) {
                        IPackageFragmentRoot[] roots = jproject.getPackageFragmentRoots();
                        int i = 0;
                        while (i < roots.length) {
                            if (roots[i].getKind() == 1) {
                                initRoot = roots[i];
                                break;
                            }
                            ++i;
                        }
                    }
                    if (initRoot == null) {
                        initRoot = jproject.getPackageFragmentRoot(jproject.getResource());
                    }
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return initRoot;
    }

    protected abstract String getContent();

    public AbstractNewClassPage.JavaClass getDomainClass() {
        return ((AbstractNewClassPage)this.getPages()[0]).getClazz();
    }

    protected void checkRequiredBundles() {
        IProject project = this.getDomainClass().getFragmentRoot().getJavaProject().getProject();
        BundleContext context = FrameworkUtil.getBundle(NewAddonClassWizard.class).getBundleContext();
        ServiceReference ref = context.getServiceReference(IBundleProjectService.class);
        IBundleProjectService service = (IBundleProjectService)context.getService(ref);
        try {
            IBundleProjectDescription description = service.getDescription(project);
            Set<String> requiredBundles = this.getRequiredBundles();
            IRequiredBundleDescription[] arTmp = description.getRequiredBundles();
            IPackageImportDescription[] currentImportPacks = description.getPackageImports();
            Set<String> requiredImportPacks = this.getImportedPackages();
            ArrayList<IRequiredBundleDescription> descs = new ArrayList<IRequiredBundleDescription>();
            ArrayList<IPackageImportDescription> imDescs = new ArrayList<IPackageImportDescription>();
            if (arTmp != null) {
                descs.addAll(Arrays.asList(arTmp));
            }
            for (IRequiredBundleDescription bd : descs) {
                requiredBundles.remove(bd.getName());
            }
            if (requiredBundles.size() > 0) {
                for (String b : requiredBundles) {
                    descs.add(service.newRequiredBundle(b, null, false, false));
                }
                description.setRequiredBundles(descs.toArray(new IRequiredBundleDescription[0]));
                description.apply((IProgressMonitor)new NullProgressMonitor());
            }
            if (currentImportPacks != null) {
                imDescs.addAll(Arrays.asList(currentImportPacks));
            }
            for (IPackageImportDescription ds : imDescs) {
                requiredImportPacks.remove(ds.getName());
            }
            if (!requiredImportPacks.isEmpty()) {
                for (String i : requiredImportPacks) {
                    String[] parts = i.split(";");
                    VersionRange r = AbstractNewClassWizard.findVersionRange(parts);
                    boolean optional = AbstractNewClassWizard.isOptional(parts);
                    imDescs.add(service.newPackageImport(parts[0], r, optional));
                }
                description.setPackageImports(imDescs.toArray(new IPackageImportDescription[0]));
                description.apply((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private static VersionRange findVersionRange(String[] parts) {
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if (p.startsWith("version=")) {
                String version = p.substring("version=".length() + 1, p.length() - 1);
                return new VersionRange(version.trim());
            }
            ++n2;
        }
        return null;
    }

    private static boolean isOptional(String[] parts) {
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if (p.startsWith("resolution:=")) {
                return p.contains("optional");
            }
            ++n2;
        }
        return false;
    }

    protected Set<String> getRequiredBundles() {
        HashSet<String> rv = new HashSet<String>();
        return rv;
    }

    protected Set<String> getImportedPackages() {
        HashSet<String> rv = new HashSet<String>();
        rv.add("javax.inject;version=\"1.0.0\"");
        return rv;
    }

    public boolean performFinish() {
        AbstractNewClassPage.JavaClass clazz = this.getDomainClass();
        String content = this.getContent();
        if (clazz.getFragmentRoot() == null) {
            return false;
        }
        this.checkRequiredBundles();
        IPackageFragment fragment = clazz.getPackageFragment();
        boolean exists = false;
        if (fragment != null) {
            try {
                IJavaElement[] children;
                IJavaElement[] iJavaElementArray = children = clazz.getFragmentRoot().getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement iJavaElement = iJavaElementArray[n2];
                    IPackageFragment pf = (IPackageFragment)iJavaElement;
                    if (pf.getElementName().equals(fragment.getElementName())) {
                        exists = true;
                        break;
                    }
                    ++n2;
                }
                if (!exists) {
                    fragment = clazz.getFragmentRoot().createPackageFragment(fragment.getElementName(), true, null);
                }
            }
            catch (JavaModelException e1) {
                e1.printStackTrace();
            }
            String cuName = String.valueOf(clazz.getName()) + JAVA;
            ICompilationUnit unit = fragment.getCompilationUnit(cuName);
            IResource resource = unit.getResource();
            this.file = (IFile)resource;
            try {
                if (!this.file.exists()) {
                    this.file.create((InputStream)new ByteArrayInputStream(content.getBytes()), true, null);
                } else {
                    this.file.setContents((InputStream)new ByteArrayInputStream(content.getBytes()), 3, null);
                }
                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)this.file);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else {
            String cuName = String.valueOf(clazz.getName()) + JAVA;
            IFolder p = (IFolder)clazz.getFragmentRoot().getResource();
            this.file = p.getFile(cuName);
            try {
                if (!this.file.exists()) {
                    this.file.create((InputStream)new ByteArrayInputStream(content.getBytes()), true, null);
                } else {
                    this.file.setContents((InputStream)new ByteArrayInputStream(content.getBytes()), 3, null);
                }
                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)this.file);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public IFile getFile() {
        return this.file;
    }
}

