/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.actions.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.ui.actions.ActionMessages;
import org.eclipse.dltk.internal.ui.actions.ActionUtil;
import org.eclipse.dltk.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.internal.ui.actions.refactoring.ContributedRefactoringAction;
import org.eclipse.dltk.internal.ui.actions.refactoring.MoveAction;
import org.eclipse.dltk.internal.ui.actions.refactoring.RenameAction;
import org.eclipse.dltk.internal.ui.editor.ModelTextSelection;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.dltk.utils.LazyExtensionManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.QuickMenuCreator;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.operations.UndoRedoActionGroup;
import org.eclipse.ui.part.Page;

public class RefactorActionGroup
extends ActionGroup {
    private static final String PERF_REFACTOR_ACTION_GROUP = "org.eclipse.dltk.ui/perf/explorer/RefactorActionGroup";
    public static final String MENU_ID = "org.eclipse.dltk.ui.refactoring.menu";
    public static final String GROUP_REORG = "reorgGroup";
    public static final String GROUP_TYPE = "typeGroup";
    public static final String GROUP_CODING = "codingGroup";
    public static final String GROUP_CODING2 = "codingGroup2";
    private static final String GROUP_REORG2 = "reorgGroup2";
    private static final String GROUP_TYPE2 = "typeGroup2";
    private IWorkbenchSite fSite;
    private ScriptEditor fEditor;
    private String fGroupName = "group.reorganize";
    protected SelectionDispatchAction fMoveAction;
    protected SelectionDispatchAction fRenameAction;
    protected UndoRedoActionGroup fUndoRedoActionGroup;
    private final List<SelectionDispatchAction> fActions = new ArrayList<SelectionDispatchAction>();
    private final List<ContributedRefactoringAction> fContributedActions = new ArrayList<ContributedRefactoringAction>();
    private static final String QUICK_MENU_ID = "org.eclipse.dltk.ui.edit.text.script.refactor.quickMenu";
    private IHandlerActivation fQuickAccessHandlerActivation;
    private IHandlerService fHandlerService;
    private Action fNoActionAvailable = new NoActionAvailable();

    public RefactorActionGroup(IViewPart part, IDLTKLanguageToolkit toolkit) {
        this((IWorkbenchSite)part.getSite(), toolkit);
        IUndoContext workspaceContext = (IUndoContext)ResourcesPlugin.getWorkspace().getAdapter(IUndoContext.class);
        this.fUndoRedoActionGroup = new UndoRedoActionGroup((IWorkbenchPartSite)part.getViewSite(), workspaceContext, true);
        this.installQuickAccessAction();
    }

    public RefactorActionGroup(Page page, IDLTKLanguageToolkit toolkit) {
        this((IWorkbenchSite)page.getSite(), toolkit);
        this.installQuickAccessAction();
    }

    public RefactorActionGroup(ScriptEditor editor, String groupName) {
        LazyExtensionManager.Descriptor[] delegates;
        PerformanceStats stats = PerformanceStats.getStats((String)PERF_REFACTOR_ACTION_GROUP, (Object)((Object)this));
        stats.startRun();
        this.fSite = editor.getEditorSite();
        this.fEditor = editor;
        this.fGroupName = groupName;
        ISelection selection = editor.getSelectionProvider().getSelection();
        this.fRenameAction = new RenameAction(editor);
        this.initAction(this.fRenameAction, selection, "org.eclipse.dltk.ui.edit.text.script.rename.element");
        editor.setAction("RenameElement", (IAction)this.fRenameAction);
        this.fMoveAction = new MoveAction(editor);
        this.initAction(this.fMoveAction, selection, "org.eclipse.dltk.ui.edit.text.script.move.element");
        editor.setAction("MoveElement", (IAction)this.fMoveAction);
        LazyExtensionManager.Descriptor[] descriptorArray = delegates = new LazyExtensionManager<IEditorActionDelegate>("org.eclipse.dltk.ui.refactoring"){

            protected boolean isValidElement(IConfigurationElement element) {
                return "action".equals(element.getName()) && RefactorActionGroup.this.fEditor.getLanguageToolkit().getNatureId().equals(element.getAttribute("nature"));
            }
        }.getDescriptors();
        int n = delegates.length;
        int n2 = 0;
        while (n2 < n) {
            LazyExtensionManager.Descriptor descriptor = descriptorArray[n2];
            IEditorActionDelegate delegate = (IEditorActionDelegate)descriptor.get();
            if (delegate != null) {
                ContributedRefactoringAction action = new ContributedRefactoringAction(this.fEditor, delegate);
                String id = descriptor.getAttribute("id");
                action.setId(id);
                action.setText(descriptor.getAttribute("label"));
                this.initAction(action, selection, id);
                editor.setAction(id, (IAction)action);
                this.fContributedActions.add(action);
            }
            ++n2;
        }
        this.installQuickAccessAction();
        stats.endRun();
    }

    private RefactorActionGroup(IWorkbenchSite site, IDLTKLanguageToolkit toolkit) {
        PerformanceStats stats = PerformanceStats.getStats((String)PERF_REFACTOR_ACTION_GROUP, (Object)((Object)this));
        stats.startRun();
        this.fSite = site;
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fMoveAction = new MoveAction(site);
        this.initUpdatingAction(this.fMoveAction, provider, selection, "org.eclipse.dltk.ui.edit.text.script.move.element");
        this.fRenameAction = new RenameAction(site);
        this.initUpdatingAction(this.fRenameAction, provider, selection, "org.eclipse.dltk.ui.edit.text.script.rename.element");
        stats.endRun();
    }

    private void installQuickAccessAction() {
        this.fHandlerService = (IHandlerService)this.fSite.getService(IHandlerService.class);
        if (this.fHandlerService != null) {
            final QuickMenuCreator creator = new QuickMenuCreator(){

                protected void fillMenu(IMenuManager menu) {
                    RefactorActionGroup.this.fillQuickMenu(menu);
                }
            };
            AbstractHandler handler = new AbstractHandler(){

                public Object execute(ExecutionEvent event) throws ExecutionException {
                    creator.createMenu();
                    return null;
                }
            };
            this.fQuickAccessHandlerActivation = this.fHandlerService.activateHandler(QUICK_MENU_ID, (IHandler)handler);
        }
    }

    private void initAction(SelectionDispatchAction action, ISelection selection, String actionDefinitionId) {
        this.initUpdatingAction(action, null, selection, actionDefinitionId);
    }

    private void initUpdatingAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection, String actionDefinitionId) {
        action.setActionDefinitionId(actionDefinitionId);
        action.update(selection);
        if (provider != null) {
            provider.addSelectionChangedListener((ISelectionChangedListener)action);
        }
        this.fActions.add(action);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("org.eclipse.dltk.ui.actions.Move", (IAction)this.fMoveAction);
        actionBars.setGlobalActionHandler("org.eclipse.dltk.ui.actions.Rename", (IAction)this.fRenameAction);
        for (ContributedRefactoringAction action : this.fContributedActions) {
            actionBars.setGlobalActionHandler(action.getId(), (IAction)action);
        }
        if (this.fUndoRedoActionGroup != null) {
            this.fUndoRedoActionGroup.fillActionBars(actionBars);
        }
    }

    public void retargetFileMenuActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.fRenameAction);
        actionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.fMoveAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        this.addRefactorSubmenu(menu);
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        this.disposeAction(this.fMoveAction, provider);
        this.disposeAction(this.fRenameAction, provider);
        for (ContributedRefactoringAction action : this.fContributedActions) {
            this.disposeAction(action, provider);
        }
        if (this.fQuickAccessHandlerActivation != null && this.fHandlerService != null) {
            this.fHandlerService.deactivateHandler(this.fQuickAccessHandlerActivation);
        }
        if (this.fUndoRedoActionGroup != null) {
            this.fUndoRedoActionGroup.dispose();
        }
        super.dispose();
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }

    private void addRefactorSubmenu(IMenuManager menu) {
        String menuText = ActionMessages.RefactorMenu_label;
        MenuManager refactorSubmenu = new MenuManager(menuText, MENU_ID);
        refactorSubmenu.setActionDefinitionId(QUICK_MENU_ID);
        if (this.fEditor != null) {
            IModelElement element = SelectionConverter.getInput((IEditorPart)this.fEditor);
            if (element != null && ActionUtil.isOnBuildPath(element)) {
                refactorSubmenu.addMenuListener(manager -> this.refactorMenuShown(manager));
                refactorSubmenu.add((IAction)this.fNoActionAvailable);
                menu.appendToGroup(this.fGroupName, (IContributionItem)refactorSubmenu);
            }
        } else {
            ISelection selection = this.fSite.getSelectionProvider().getSelection();
            for (SelectionDispatchAction action : this.fActions) {
                action.update(selection);
            }
            if (this.fillRefactorMenu((IMenuManager)refactorSubmenu) > 0) {
                menu.appendToGroup(this.fGroupName, (IContributionItem)refactorSubmenu);
            }
        }
    }

    private int fillRefactorMenu(IMenuManager refactorSubmenu) {
        int added = 0;
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_REORG));
        added += this.addAction(refactorSubmenu, (IAction)this.fRenameAction);
        added += this.addAction(refactorSubmenu, (IAction)this.fMoveAction);
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_CODING));
        for (IAction iAction : this.fContributedActions) {
            added += this.addAction(refactorSubmenu, iAction);
        }
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_REORG2));
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_TYPE));
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_CODING2));
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_TYPE2));
        return added;
    }

    private int addAction(IMenuManager menu, IAction action) {
        if (action != null && action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 1;
    }

    private void refactorMenuShown(final IMenuManager refactorSubmenu) {
        Menu menu = ((MenuManager)refactorSubmenu).getMenu();
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent e) {
                RefactorActionGroup.this.refactorMenuHidden(refactorSubmenu);
            }
        });
        ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        ModelTextSelection javaSelection = new ModelTextSelection(this.getEditorInput(), this.getDocument(), textSelection.getOffset(), textSelection.getLength());
        for (SelectionDispatchAction action : this.fActions) {
            action.update((ISelection)javaSelection);
        }
        refactorSubmenu.removeAll();
        if (this.fillRefactorMenu(refactorSubmenu) == 0) {
            refactorSubmenu.add((IAction)this.fNoActionAvailable);
        }
    }

    private void refactorMenuHidden(IMenuManager manager) {
        ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        for (SelectionDispatchAction action : this.fActions) {
            action.update((ISelection)textSelection);
        }
    }

    private IModelElement getEditorInput() {
        return DLTKUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.fEditor.getEditorInput());
    }

    private IDocument getDocument() {
        return DLTKUIPlugin.getDefault().getSourceModuleDocumentProvider().getDocument(this.fEditor.getEditorInput());
    }

    private void fillQuickMenu(IMenuManager menu) {
        if (this.fEditor != null) {
            IModelElement element = SelectionConverter.getInput((IEditorPart)this.fEditor);
            if (element == null || !ActionUtil.isOnBuildPath(element)) {
                menu.add((IAction)this.fNoActionAvailable);
                return;
            }
            ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
            ModelTextSelection scriptSelection = new ModelTextSelection(this.getEditorInput(), this.getDocument(), textSelection.getOffset(), textSelection.getLength());
            for (SelectionDispatchAction action : this.fActions) {
                action.update((ISelection)scriptSelection);
            }
            this.fillRefactorMenu(menu);
            for (SelectionDispatchAction action : this.fActions) {
                action.update((ISelection)textSelection);
            }
        } else {
            ISelection selection = this.fSite.getSelectionProvider().getSelection();
            for (SelectionDispatchAction action : this.fActions) {
                action.update(selection);
            }
            this.fillRefactorMenu(menu);
        }
    }

    private static class NoActionAvailable
    extends Action {
        public NoActionAvailable() {
            this.setEnabled(true);
            this.setText(ActionMessages.RefactorActionGroup_noRefactoringAvailable);
        }
    }
}

