/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.commonui;

import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.commonui.ContextAccessibleTableViewer;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.commonui.ICompositeProvider;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.commonui.Messages;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.commonui.ParameterDataCellModifier;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.commonui.ParameterVariableSectionLabelProvider;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.commonui.ParametersData;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.commonui.ParametersRowData;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.commonui.PseudoFormToolkit;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.AccessibleTableViewer;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.TableCellEditor;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.TableComboBoxCellEditor;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.TableDataContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ParametersTableProvider
implements ICompositeProvider {
    private boolean _useGroup = true;
    private Shell _sShell = null;
    private Composite _groupParameter = null;
    private Table _table = null;
    private Composite _composite = null;
    protected ContextAccessibleTableViewer _viewer;
    private ParametersData _data;
    private FormToolkit formToolkit = null;
    private String[] inOutItems = new String[]{"IN", "OUT"};
    private String[] _dataTypes = new String[0];
    protected boolean _enforcePrefix = false;
    protected boolean _supportsExp = false;
    private int border = 0;
    private Listener _changeListener;

    public ParametersTableProvider() {
    }

    public ParametersTableProvider(boolean useGroup) {
        this._useGroup = useGroup;
    }

    public ParametersTableProvider(boolean useGroup, boolean enforcePrefix) {
        this(useGroup, enforcePrefix, false);
    }

    public ParametersTableProvider(boolean useGroup, boolean enforcePrefix, boolean supportsExp) {
        this._useGroup = useGroup;
        this._enforcePrefix = enforcePrefix;
        this._supportsExp = supportsExp;
    }

    private FormToolkit getFormToolkit() {
        if (this.formToolkit == null) {
            this.formToolkit = new PseudoFormToolkit(Display.getCurrent());
        }
        return this.formToolkit;
    }

    public Composite createTheTable(Composite parent) {
        if (this._groupParameter == null) {
            this.createSShell();
        }
        this._groupParameter.setParent(parent);
        this._table.setSelection(0);
        return this._groupParameter;
    }

    private void createSShell() {
        this._sShell = new Shell();
        this._sShell.setLayout((Layout)new GridLayout());
        this.createComposite();
    }

    private void createComposite() {
        GridData gridData1 = new GridData();
        this._composite = new Composite((Composite)this._sShell, 0);
        this._composite.setLayout((Layout)new GridLayout());
        this._composite.setLayoutData((Object)gridData1);
        gridData1.horizontalAlignment = 4;
        gridData1.verticalAlignment = 4;
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.grabExcessVerticalSpace = true;
        this.createGroupParameters();
    }

    public Composite getComposite(Composite parent, FormToolkit formToolkit, int style) {
        if (this._groupParameter == null) {
            this.formToolkit = formToolkit;
            this.border = style & 0x800;
            this.createSShell();
        }
        this._groupParameter.setParent(parent);
        this._table.setSelection(0);
        return this._groupParameter;
    }

    private void createGroupParameters() {
        GridData gridData = new GridData();
        GridLayout gridLayout = new GridLayout();
        if (this._useGroup) {
            this._groupParameter = new Group(this._composite, 0);
            ((Group)this._groupParameter).setText(Messages.wizard_createSP_page2_parameters_label);
        } else {
            this._groupParameter = this.getFormToolkit().createComposite(this._composite, 0);
            gridLayout.marginHeight = 1;
        }
        this.createTable();
        this._viewer.getCursor().setSelection(0, 0);
        this._groupParameter.setLayout((Layout)gridLayout);
        this._groupParameter.setLayoutData((Object)gridData);
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 5;
        gridData.heightHint = 80;
        this.getFormToolkit().paintBordersFor(this._groupParameter);
        this._table.pack();
    }

    private void configureTable() {
        this._viewer.getTable().setHeaderVisible(true);
        this._viewer.getTable().setLinesVisible(true);
        this._viewer.getTable().setLayoutData((Object)new GridData(1808));
        CellEditor[] editors = new CellEditor[this._data.getColumnCount()];
        String[] properties = new String[this._data.getColumnCount()];
        int i = 0;
        while (i < this._data.getColumnCount()) {
            TableColumn col = new TableColumn(this._viewer.getTable(), 0);
            col.setText(this._data.getColumnName(i));
            col.pack();
            col.setWidth(ParametersData.COLUMN_LENGTH[i]);
            TableCellEditor currentEditor = null;
            switch (i) {
                case 0: {
                    currentEditor = new TableCellEditor((AccessibleTableViewer)this._viewer);
                    break;
                }
                case 1: {
                    currentEditor = new TableCellEditor((AccessibleTableViewer)this._viewer);
                    break;
                }
                case 2: {
                    currentEditor = new TableComboBoxCellEditor((AccessibleTableViewer)this._viewer, this._dataTypes);
                    break;
                }
                case 3: {
                    currentEditor = new TableComboBoxCellEditor((AccessibleTableViewer)this._viewer, this.inOutItems, 8);
                    break;
                }
                case 4: {
                    currentEditor = new TableCellEditor((AccessibleTableViewer)this._viewer);
                    break;
                }
            }
            editors[i] = currentEditor;
            properties[i] = this._data.getColumnName(i);
            ++i;
        }
        this._viewer.setColumnProperties(properties);
        this._viewer.setCellEditors(editors);
        this._viewer.setCellModifier((ICellModifier)this.createParameterDataCellModifier());
    }

    protected ParameterDataCellModifier createParameterDataCellModifier() {
        return new ParameterDataCellModifier(this._viewer, this._enforcePrefix, this._supportsExp){

            public boolean canChange(Object obj, int index) {
                return false;
            }
        };
    }

    private void createTable() {
        this._table = this.getFormToolkit().createTable(this._groupParameter, this.border | 2 | 0x10000);
        this._viewer = new ContextAccessibleTableViewer(this._table, 1);
        this._viewer.setLabelProvider((IBaseLabelProvider)new ParameterVariableSectionLabelProvider());
        this._viewer.setContentProvider((IContentProvider)new TableDataContentProvider());
        this._data = this.createParametersData();
        this.configureTable();
        this._viewer.setInput((Object)this._data);
    }

    protected ParametersData createParametersData() {
        return new ParametersData();
    }

    public Table getTable() {
        return this._table;
    }

    public boolean setFocus() {
        return this._table.setFocus();
    }

    public void enableTable(boolean status) {
        this._table.setEnabled(status);
        this._table.setLinesVisible(true);
    }

    public void setInOutItems(String[] inOutItems) {
        this.inOutItems = inOutItems;
        this.updateInOutField();
    }

    public void setDataTypes(String[] types) {
        this._dataTypes = types;
        if (this._table == null) {
            return;
        }
        TableComboBoxCellEditor editor = (TableComboBoxCellEditor)this._viewer.getCellEditors()[2];
        editor.setItems(this._dataTypes);
        ((CCombo)editor.getControl()).setVisibleItemCount(this._dataTypes.length > 20 ? 20 : this._dataTypes.length);
    }

    public void updateInOutField() {
        if (this._table == null) {
            return;
        }
        TableComboBoxCellEditor editor = (TableComboBoxCellEditor)this._viewer.getCellEditors()[3];
        editor.setItems(this.inOutItems);
        ((CCombo)editor.getControl()).setVisibleItemCount(this.inOutItems.length);
        ParametersData data = (ParametersData)((Object)this._viewer.getInput());
        for (ParametersRowData row : data.getRows()) {
            String inout;
            String string = inout = row.getValue(3) == null ? "" : row.getValue(3).toString();
            if (inout.equals("")) continue;
            this.persistToDataModel(row, 3, inout.trim());
            this._viewer.doRefresh(false);
            this._table.redraw();
        }
    }

    public void persistToDataModel(ParametersRowData row, int columnIndex, Object obj) {
        row.updateValueWithoutNotification(columnIndex, obj);
    }

    public void focus() {
        this._viewer.getCursor().setSelection(0, 0);
    }

    public ParametersData geData() {
        return this._data;
    }

    public void setData(ParametersData data) {
        this._data = data;
        this._viewer.setInput((Object)this._data);
    }

    public AccessibleTableViewer getViewer() {
        return this._viewer;
    }
}

