/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.traditional;

import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalRenderingMessages;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ColorAndEffectFieldEditor
extends FieldEditor {
    private final String nameBold;
    private final String nameItalic;
    private final String nameBox;
    private ColorSelector colorSelector;
    private Button checkBold;
    private Button checkItalic;
    private Button checkBox;

    public ColorAndEffectFieldEditor(String name, String nameBold, String nameItalic, String nameBox, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.nameBold = nameBold;
        this.nameItalic = nameItalic;
        this.nameBox = nameBox;
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.checkItalic.getLayoutData()).horizontalSpan = numColumns - 4;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        control.setLayoutData((Object)new GridData());
        this.colorSelector = new ColorSelector(parent);
        this.colorSelector.getButton().setLayoutData((Object)new GridData());
        this.checkBold = new Button(parent, 32);
        this.checkBold.setText(TraditionalRenderingMessages.getString("ColorAndEffectFieldEditor.bold"));
        this.checkBold.setLayoutData((Object)new GridData());
        this.checkItalic = new Button(parent, 32);
        this.checkItalic.setText(TraditionalRenderingMessages.getString("ColorAndEffectFieldEditor.italic"));
        this.checkItalic.setLayoutData((Object)new GridData());
        this.checkBox = new Button(parent, 32);
        this.checkBox.setText(TraditionalRenderingMessages.getString("ColorAndEffectFieldEditor.box"));
        this.checkBox.setLayoutData((Object)new GridData());
    }

    protected void doLoad() {
        IPreferenceStore store = this.getPreferenceStore();
        this.colorSelector.setColorValue(PreferenceConverter.getColor((IPreferenceStore)store, (String)this.getPreferenceName()));
        this.checkBold.setSelection(store.getBoolean(this.nameBold));
        this.checkItalic.setSelection(store.getBoolean(this.nameItalic));
        this.checkBox.setSelection(store.getBoolean(this.nameBox));
    }

    protected void doLoadDefault() {
        IPreferenceStore store = this.getPreferenceStore();
        this.colorSelector.setColorValue(PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)this.getPreferenceName()));
        this.checkBold.setSelection(store.getDefaultBoolean(this.nameBold));
        this.checkItalic.setSelection(store.getDefaultBoolean(this.nameItalic));
        this.checkBox.setSelection(store.getDefaultBoolean(this.nameBox));
    }

    protected void doStore() {
        IPreferenceStore store = this.getPreferenceStore();
        PreferenceConverter.setValue((IPreferenceStore)store, (String)this.getPreferenceName(), (RGB)this.colorSelector.getColorValue());
        store.setValue(this.nameBold, this.checkBold.getSelection());
        store.setValue(this.nameItalic, this.checkItalic.getSelection());
        store.setValue(this.nameBox, this.checkBox.getSelection());
    }

    public int getNumberOfControls() {
        return 5;
    }
}

