/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.launch;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.internal.core.InternalDebugCoreMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.launch.LaunchConfigurationTargetedDelegate;

public abstract class CoreBuildLaunchConfigDelegate
extends LaunchConfigurationTargetedDelegate {
    protected ICBuildConfigurationManager configManager = CDebugCorePlugin.getService(ICBuildConfigurationManager.class);
    protected IToolChainManager toolChainManager = CDebugCorePlugin.getService(IToolChainManager.class);

    public static IProject getProject(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getMappedResources()[0].getProject();
    }

    protected ICBuildConfiguration getBuildConfiguration(IProject project, String mode, ILaunchTarget target, IProgressMonitor monitor) throws CoreException {
        HashMap properties = new HashMap();
        properties.putAll(target.getAttributes());
        Collection tcs = this.toolChainManager.getToolChainsMatching(properties);
        if (!tcs.isEmpty()) {
            IToolChain toolChain = (IToolChain)tcs.iterator().next();
            return this.configManager.getBuildConfiguration(project, toolChain, mode, monitor);
        }
        return null;
    }

    protected IBinary getBinary(ICBuildConfiguration buildConfig) throws CoreException {
        IBinary[] binaries = buildConfig.getBuildOutput();
        IBinary exeFile = null;
        IBinary[] iBinaryArray = binaries;
        int n = binaries.length;
        int n2 = 0;
        while (n2 < n) {
            IBinary binary = iBinaryArray[n2];
            if (binary.isExecutable()) {
                exeFile = binary;
                break;
            }
            ++n2;
        }
        if (exeFile == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.debug.core", InternalDebugCoreMessages.CoreBuildLaunchConfigDelegate_noBinaries));
        }
        return exeFile;
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        IProject project = CoreBuildLaunchConfigDelegate.getProject(configuration);
        return new IProject[]{project};
    }

    public static String getBuildAttributeName(String mode) {
        return "COREBUILD_" + mode;
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, ILaunchTarget target, IProgressMonitor monitor) throws CoreException {
        IProject project = CoreBuildLaunchConfigDelegate.getProject(configuration);
        ICBuildConfiguration buildConfig = this.getBuildConfiguration(project, mode, target, monitor);
        if (buildConfig != null) {
            IProjectDescription desc = project.getDescription();
            desc.setActiveBuildConfig(buildConfig.getBuildConfiguration().getName());
            project.setDescription(desc, monitor);
            Map buildProps = configuration.getAttribute(CoreBuildLaunchConfigDelegate.getBuildAttributeName(mode), buildConfig.getDefaultProperties());
            buildConfig.setProperties(buildProps);
        }
        return this.superBuildForLaunch(configuration, mode, monitor);
    }
}

