/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.actions;

import java.util.List;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.editparts.BPELEditPart;
import org.eclipse.bpel.ui.editparts.ProcessEditPart;
import org.eclipse.bpel.ui.figures.ILayoutAware;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;

public class ToggleLayoutOrientationAction
extends SelectionAction {
    public static final String ACTION_ID = "ToggleLayoutOrientationAction";

    public ToggleLayoutOrientationAction(IWorkbenchPart part) {
        super(part);
        this.setId(ACTION_ID);
        this.setText(this.getText());
    }

    public void run() {
        BPELEditor editor;
        editor.setHorizontalLayout(!(editor = (BPELEditor)this.getWorkbenchPart()).isHorizontalLayout());
        ProcessEditPart process = (ProcessEditPart)editor.getGraphicalViewer().getEditPartRegistry().get(editor.getProcess());
        this.doSwitchOrientation(process, editor.isHorizontalLayout());
        this.setText(this.getText());
        editor.refreshGraphicalViewer();
    }

    private void doSwitchOrientation(BPELEditPart part, boolean horizontal) {
        List children = part.getChildren();
        for (BPELEditPart child : children) {
            this.doSwitchOrientation(child, horizontal);
        }
        if (part instanceof ILayoutAware) {
            ((ILayoutAware)((Object)part)).switchLayout(horizontal);
        }
    }

    protected boolean calculateEnabled() {
        List sel = this.getSelectedObjects();
        return sel.size() > 0 && sel.get(0) instanceof Process;
    }

    public String getText() {
        BPELEditor editor = (BPELEditor)this.getWorkbenchPart();
        if (editor.isHorizontalLayout()) {
            return Messages.ToggleLayoutOrientation_2;
        }
        return Messages.ToggleLayoutOrientation_1;
    }
}

