/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.decorator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.bpel.common.ui.Messages;
import org.eclipse.bpel.common.ui.decorator.DecorationLayout;
import org.eclipse.bpel.common.ui.decorator.IMarkerConstants;
import org.eclipse.bpel.common.ui.layouts.AlignedFlowLayout;
import org.eclipse.bpel.common.ui.layouts.FillParentLayout;
import org.eclipse.bpel.common.ui.markers.ModelMarkerUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class EditPartMarkerDecorator {
    protected EObject modelObject;
    private List<EObject> modelObjects = new ArrayList<EObject>();
    private boolean fillParent = false;
    protected Layer decorationLayer;
    private AbstractLayout decorationLayout;
    private AbstractLayout figureLayout;
    protected boolean resizeChildren = true;
    private Object defaultConstraint = IMarkerConstants.CENTER;
    static IMarker[] EMPTY_MARKERS = new IMarker[0];

    public EditPartMarkerDecorator(EObject aModelObject) {
        this(aModelObject, null, null);
    }

    public EditPartMarkerDecorator(List<EObject> aListOfModelObjects) {
        this(aListOfModelObjects, null, null);
    }

    public EditPartMarkerDecorator(EObject aModelObject, AbstractLayout aLayout) {
        this(aModelObject, aLayout, null);
    }

    public EditPartMarkerDecorator(List<EObject> aListOfModelObjects, AbstractLayout aLayout) {
        this(aListOfModelObjects, aLayout, null);
    }

    public EditPartMarkerDecorator(EObject aModelObject, AbstractLayout aFigureLayout, AbstractLayout aDecorationLayout) {
        this.modelObject = aModelObject;
        this.setFigureLayout(aFigureLayout);
        if (aDecorationLayout == null) {
            aDecorationLayout = new DecorationLayout();
        }
        this.setDecorationLayout((AbstractLayout)aDecorationLayout);
    }

    public EditPartMarkerDecorator(List<EObject> aListOfModelObjects, AbstractLayout aLayout, AbstractLayout aDecorationLayout) {
        this((EObject)null, aLayout, aDecorationLayout);
        this.modelObjects = aListOfModelObjects;
    }

    public void setFillParent(boolean fillParentSwitch) {
        this.fillParent = fillParentSwitch;
    }

    protected void refreshMarkers() {
        if (this.decorationLayer == null) {
            return;
        }
        for (List<IMarker> markerList : this.sortByType(this.getMarkers())) {
            IMarker[] list = markerList.toArray(EMPTY_MARKERS);
            Object constraint = this.getConstraint(list[0]);
            IFigure markerFigure = this.createFigureForMarkers(list);
            if (markerFigure == null) continue;
            this.decorationLayer.add(markerFigure, constraint);
        }
    }

    protected Collection<List<IMarker>> sortByType(IMarker[] markers) {
        HashMap<String, ArrayList<IMarker>> sorter = new HashMap<String, ArrayList<IMarker>>();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                IMarker m = iMarkerArray[n2];
                String type = null;
                try {
                    type = m.getType();
                }
                catch (CoreException coreException) {
                    break block4;
                }
                ArrayList<IMarker> list = (ArrayList<IMarker>)sorter.get(type);
                if (list == null) {
                    list = new ArrayList<IMarker>();
                    sorter.put(type, list);
                }
                list.add(m);
            }
            ++n2;
        }
        return sorter.values();
    }

    public void refresh() {
        if (this.decorationLayer != null) {
            this.decorationLayer.removeAll();
        }
        this.refreshMarkers();
    }

    protected Image getImage(IMarker marker) {
        return ModelMarkerUtil.getImage(marker);
    }

    protected IMarker[] getMarkers() {
        return this.getMarkerMap().values().toArray(EMPTY_MARKERS);
    }

    public IFigure createFigure(IFigure figure) {
        LayeredPane pane = new LayeredPane();
        Layer layer = new Layer();
        if (this.figureLayout == null) {
            this.figureLayout = this.fillParent ? new FillParentLayout() : new AlignedFlowLayout(){

                @Override
                protected void setBoundsOfChild(IFigure parent, IFigure child, Rectangle bounds) {
                    parent.getClientArea(Rectangle.SINGLETON);
                    bounds.translate(Rectangle.SINGLETON.x, Rectangle.SINGLETON.y);
                    if (EditPartMarkerDecorator.this.resizeChildren) {
                        child.setBounds(bounds);
                    } else {
                        child.setLocation(bounds.getLocation());
                    }
                }
            };
        }
        layer.setLayoutManager((LayoutManager)this.figureLayout);
        pane.add((IFigure)layer);
        layer.add(figure);
        if (this.decorationLayer == null) {
            this.decorationLayer = new Layer();
        }
        this.decorationLayer.setLayoutManager((LayoutManager)this.decorationLayout);
        pane.add((IFigure)this.decorationLayer);
        return pane;
    }

    public void setDecorationLayout(AbstractLayout layout) {
        this.decorationLayout = layout;
        if (this.decorationLayer != null) {
            this.decorationLayer.setLayoutManager((LayoutManager)this.decorationLayout);
        }
    }

    public void setResizeChildren(boolean resizeChildrenFlag) {
        this.resizeChildren = resizeChildrenFlag;
    }

    public void setFigureLayout(AbstractLayout layout) {
        this.figureLayout = layout;
    }

    public EObject getModelObject() {
        return this.modelObject;
    }

    public List<EObject> getModelObjects() {
        return this.modelObjects;
    }

    protected Map<Object, IMarker> getMarkerMap() {
        return Collections.emptyMap();
    }

    protected int getPriority(IMarker marker) {
        block10: {
            int severity;
            block12: {
                block11: {
                    Integer priority = null;
                    try {
                        priority = (Integer)marker.getAttribute("org.eclipse.bpel.common.ui.uiModelMarker.priority");
                    }
                    catch (CoreException coreException) {
                    }
                    catch (ClassCastException classCastException) {}
                    if (priority != null) {
                        return priority;
                    }
                    try {
                        if (!marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) break block10;
                        severity = marker.getAttribute("severity", 0);
                        if (severity != 2) break block11;
                        return 60;
                    }
                    catch (CoreException coreException) {}
                }
                if (severity != 1) break block12;
                return 50;
            }
            if (severity == 0) {
                return 20;
            }
        }
        return 5;
    }

    protected Object getConstraint(IMarker marker) {
        try {
            String key;
            Object constraint;
            if (marker.isSubtypeOf("org.eclipse.bpel.common.ui.graphicalMarker") && (constraint = this.convertAnchorKeyToConstraint(key = marker.getAttribute("org.eclipse.bpel.common.ui.graphicalMarker.anchorPoint", ""))) != null) {
                return constraint;
            }
        }
        catch (CoreException coreException) {}
        return this.defaultConstraint;
    }

    protected Object convertAnchorKeyToConstraint(String key) {
        if (key.equals("TOP_CENTRE")) {
            return IMarkerConstants.TOP;
        }
        if (key.equals("BOTTOM_CENTRE")) {
            return IMarkerConstants.BOTTOM;
        }
        if (key.equals("LEFT")) {
            return IMarkerConstants.LEFT;
        }
        if (key.equals("RIGHT")) {
            return IMarkerConstants.RIGHT;
        }
        if (key.equals("CENTRE")) {
            return IMarkerConstants.CENTER;
        }
        if (key.equals("TOP_LEFT")) {
            return IMarkerConstants.TOP_LEFT;
        }
        if (key.equals("TOP_RIGHT")) {
            return IMarkerConstants.TOP_RIGHT;
        }
        if (key.equals("BOTTOM_LEFT")) {
            return IMarkerConstants.BOTTOM_LEFT;
        }
        if (key.equals("BOTTOM_RIGHT")) {
            return IMarkerConstants.BOTTOM_RIGHT;
        }
        return null;
    }

    public Object getDefaultConstraint() {
        return this.defaultConstraint;
    }

    public void setDefaultConstraint(Object aDefaultContraint) {
        this.defaultConstraint = aDefaultContraint;
    }

    protected IFigure createFigureForMarker(IMarker marker) {
        Image image = this.getImage(marker);
        String text = this.getText(marker);
        if (image != null) {
            ImageFigure imageFigure = new ImageFigure(image);
            if (text != null) {
                imageFigure.setToolTip((IFigure)new Label(text));
            }
            return imageFigure;
        }
        return null;
    }

    protected IFigure createFigureForMarkers(IMarker[] markers) {
        if (markers.length == 1) {
            return this.createFigureForMarker(markers[0]);
        }
        Image image = null;
        StringBuilder builder = new StringBuilder(128);
        builder.append(NLS.bind((String)Messages.EditPartMarkerEectorator_1, (Object[])new Object[]{markers.length}));
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            String text;
            IMarker m = iMarkerArray[n2];
            if (image == null) {
                image = this.getImage(m);
            }
            if ((text = this.getText(m)) != null) {
                builder.append("\no ").append(text);
            }
            ++n2;
        }
        if (image != null) {
            ImageFigure imageFigure = new ImageFigure(image);
            imageFigure.setToolTip((IFigure)new Label(builder.toString()));
            return imageFigure;
        }
        return null;
    }

    protected String getText(IMarker marker) {
        return ModelMarkerUtil.getText(marker);
    }

    protected boolean isAcceptable(IMarker marker) {
        return true;
    }
}

