/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.command;

import java.util.EventObject;
import org.eclipse.bpel.common.ui.command.ICommandFramework;
import org.eclipse.bpel.common.ui.details.IOngoingChange;
import org.eclipse.bpel.common.ui.editmodel.EditModelCommandStack;
import org.eclipse.bpel.common.ui.editmodel.PlaceHolderCommand;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;

public class EditModelCommandFramework
implements ICommandFramework {
    IOngoingChange fCurrentChange;
    CommandStack fCommandStack;
    boolean fIgnoreEvents = false;

    public EditModelCommandFramework(EditModelCommandStack editModelCommandStack) {
        this.fCommandStack = editModelCommandStack;
        editModelCommandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                if (EditModelCommandFramework.this.fIgnoreEvents || !(event instanceof EditModelCommandStack.SharedCommandStackChangedEvent)) {
                    return;
                }
                EditModelCommandStack.SharedCommandStackChangedEvent e = (EditModelCommandStack.SharedCommandStackChangedEvent)event;
                if (e.getProperty() == 1) {
                    EditModelCommandFramework.this.applyCurrentChange();
                }
                if (e.getProperty() == 3) {
                    EditModelCommandFramework.this.applyCurrentChange();
                }
            }
        });
    }

    @Override
    public void abortCurrentChange() {
        this.finishCurrentChange(true);
    }

    @Override
    public void applyCurrentChange() {
        this.finishCurrentChange(false);
    }

    @Override
    public void notifyChangeInProgress(IOngoingChange ongoingChange) {
        if (this.fCurrentChange != ongoingChange) {
            this.applyCurrentChange();
            if (this.fCommandStack.getUndoCommand() instanceof PlaceHolderCommand) {
                throw new IllegalStateException();
            }
            PlaceHolderCommand placeholderCommand = new PlaceHolderCommand(ongoingChange.getLabel());
            this.fIgnoreEvents = true;
            try {
                this.fCommandStack.execute((Command)placeholderCommand);
            }
            finally {
                this.fIgnoreEvents = false;
            }
            this.fCurrentChange = ongoingChange;
        }
    }

    @Override
    public void notifyChangeDone(IOngoingChange ongoingChange) {
        if (this.fCurrentChange == ongoingChange) {
            this.applyCurrentChange();
        }
    }

    @Override
    public void execute(Command command) {
        this.fCommandStack.execute(command);
    }

    protected void finishCurrentChange(boolean changeUndone) {
        if (this.fCurrentChange == null) {
            return;
        }
        IOngoingChange change = this.fCurrentChange;
        this.fCurrentChange = null;
        if (this.fIgnoreEvents) {
            throw new IllegalStateException();
        }
        if (!(this.fCommandStack.getUndoCommand() instanceof PlaceHolderCommand)) {
            throw new IllegalStateException();
        }
        this.fIgnoreEvents = true;
        try {
            this.fCommandStack.undo();
        }
        finally {
            this.fIgnoreEvents = false;
        }
        Command cmd = change.createApplyCommand();
        if (cmd != null) {
            cmd.setLabel(change.getLabel());
            if (changeUndone) {
                change.restoreOldState();
            } else {
                this.fCommandStack.execute(cmd);
            }
        } else {
            change.restoreOldState();
        }
    }
}

