/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.logging.Logger;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class BaseDialog
extends TrayDialog {
    private static final String DIALOG_HEIGHT = "DIALOG_HEIGHT";
    private static final String DIALOG_WIDTH = "DIALOG_WIDTH";
    protected Logger logger = Logger.getLogger(BaseDialog.class.getName());
    private String title;
    private String okLabel = null;
    protected Object result;
    private IDialogSettings dialogSettings;

    protected BaseDialog(String title) {
        this(UIUtil.getDefaultShell(), title);
    }

    protected BaseDialog(Shell parentShell) {
        this(parentShell, null);
    }

    protected BaseDialog(Shell parentShell, String title) {
        super(parentShell);
        this.setHelpAvailable(false);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.title = title;
    }

    public int open() {
        if (this.getShell() == null) {
            this.create();
        }
        if (this.initDialog()) {
            if (Policy.TRACING_DIALOGS) {
                String[] result = ((Object)((Object)this)).getClass().getName().split("\\.");
                System.out.println("Dialog >> Open " + result[result.length - 1]);
            }
            return super.open();
        }
        return 1;
    }

    protected boolean initDialog() {
        return true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
        if (this.getShell() != null) {
            this.getShell().setText(newTitle);
        }
    }

    public String getTitle() {
        return this.title;
    }

    protected Button getOkButton() {
        return this.getButton(0);
    }

    protected void setOkButtonText(String label) {
        this.okLabel = label;
    }

    public Object getResult() {
        return this.result;
    }

    protected final void setResult(Object value) {
        this.result = value;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0 && this.okLabel != null) {
            return super.createButton(parent, id, this.okLabel, defaultButton);
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        if (this.dialogSettings == null) {
            this.dialogSettings = this.loadDialogSettings();
        }
        return this.dialogSettings;
    }

    private IDialogSettings loadDialogSettings() {
        if (!this.needRememberLastSize()) {
            return null;
        }
        IDialogSettings dialogSettings = ReportPlugin.getDefault().getDialogSettings();
        StringBuffer buf = new StringBuffer();
        Object curShell = this.getShell();
        while (curShell != null) {
            buf.append(String.valueOf(curShell.toString()) + '/');
            Composite parent = curShell.getParent();
            curShell = parent != null ? parent.getShell() : null;
        }
        if (buf.length() > 0) {
            buf.deleteCharAt(buf.length() - 1);
            String sectionName = buf.toString();
            IDialogSettings setting = dialogSettings.getSection(sectionName);
            if (setting == null) {
                setting = dialogSettings.addNewSection(sectionName);
            }
            return setting;
        }
        return dialogSettings;
    }

    protected Point getInitialSize() {
        try {
            IDialogSettings setting = this.getDialogBoundsSettings();
            if (setting != null) {
                int width = setting.getInt(DIALOG_WIDTH);
                int height = setting.getInt(DIALOG_HEIGHT);
                return new Point(width, height);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return this.getDefaultSize();
    }

    protected Point getDefaultSize() {
        return super.getInitialSize();
    }

    protected void initializeBounds() {
        Button defaultButton;
        Shell shell = this.getShell();
        if (shell != null && shell.getDisplay().getDismissalAlignment() == 131072 && (defaultButton = shell.getDefaultButton()) != null && this.isContained(this.buttonBar, (Control)defaultButton)) {
            defaultButton.moveBelow(null);
            ((Composite)this.buttonBar).layout();
        }
        Point size = !this.needRememberLastSize() ? this.getShell().computeSize(-1, -1, true) : this.getInitialSize();
        Point location = this.getInitialLocation(size);
        this.getShell().setBounds(this.getConstrainedShellBounds(new Rectangle(location.x, location.y, size.x, size.y)));
    }

    private boolean isContained(Control container, Control control) {
        Composite parent;
        while ((parent = control.getParent()) != null) {
            if (parent == container) {
                return true;
            }
            control = parent;
        }
        return false;
    }

    protected boolean needRememberLastSize() {
        return false;
    }
}

