/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.SortedDependencies;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Es6SortedDependencies<INPUT extends DependencyInfo>
implements SortedDependencies<INPUT> {
    private final List<INPUT> userOrderedInputs = new ArrayList<INPUT>();
    private final List<INPUT> importOrderedInputs = new ArrayList<INPUT>();
    private final Set<INPUT> completedInputs = new HashSet<INPUT>();
    private final Map<String, INPUT> nonExportingInputs = new LinkedHashMap<String, INPUT>();
    private final Map<String, INPUT> exportingInputBySymbolName = new HashMap<String, INPUT>();
    private final Multimap<INPUT, INPUT> importedInputByImportingInput = LinkedHashMultimap.create();

    public Es6SortedDependencies(List<INPUT> userOrderedInputs) {
        this.userOrderedInputs.addAll(userOrderedInputs);
        this.processInputs();
    }

    @Override
    public List<INPUT> getDependenciesOf(List<INPUT> rootInputs, boolean sorted) {
        Preconditions.checkArgument((boolean)this.userOrderedInputs.containsAll(rootInputs));
        HashSet<DependencyInfo> includedInputs = new HashSet<DependencyInfo>();
        ArrayDeque<INPUT> worklist = new ArrayDeque<INPUT>(rootInputs);
        while (!worklist.isEmpty()) {
            DependencyInfo input = (DependencyInfo)worklist.pop();
            if (!includedInputs.add(input)) continue;
            for (String symbolName : input.getRequires()) {
                DependencyInfo importedSymbolName = (DependencyInfo)this.exportingInputBySymbolName.get(symbolName);
                if (importedSymbolName == null) continue;
                worklist.add(importedSymbolName);
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DependencyInfo input : sorted ? this.importOrderedInputs : this.userOrderedInputs) {
            if (!includedInputs.contains(input)) continue;
            builder.add((Object)input);
        }
        return builder.build();
    }

    @Override
    public INPUT getInputProviding(String symbolName) throws SortedDependencies.MissingProvideException {
        INPUT input = this.maybeGetInputProviding(symbolName);
        if (input != null) {
            return input;
        }
        throw new SortedDependencies.MissingProvideException(symbolName);
    }

    @Override
    public List<INPUT> getInputsWithoutProvides() {
        return ImmutableList.copyOf(this.nonExportingInputs.values());
    }

    @Override
    public List<INPUT> getSortedDependenciesOf(List<INPUT> roots) {
        return this.getDependenciesOf(roots, true);
    }

    @Override
    public List<INPUT> getSortedList() {
        return Collections.unmodifiableList(this.importOrderedInputs);
    }

    @Override
    public INPUT maybeGetInputProviding(String symbol) {
        if (this.exportingInputBySymbolName.containsKey(symbol)) {
            return (INPUT)((DependencyInfo)this.exportingInputBySymbolName.get(symbol));
        }
        return (INPUT)((DependencyInfo)this.nonExportingInputs.get(Es6SortedDependencies.toModuleName(Es6SortedDependencies.createUri(symbol))));
    }

    private static String toModuleName(URI filename) {
        String moduleName = filename.toString();
        if (moduleName.endsWith(".js")) {
            moduleName = moduleName.substring(0, moduleName.length() - 3);
        }
        moduleName = moduleName.replaceAll("^\\./", "").replace('/', '$').replace('\\', '$').replace('-', '_').replace(':', '_').replace('.', '_').replace("%20", "_");
        return "module$" + moduleName;
    }

    private static URI createUri(String input) {
        String forwardSlashes = input.replace(':', '-').replace('\\', '/').replace(" ", "%20");
        return URI.create(forwardSlashes).normalize();
    }

    private void orderInput(INPUT input) {
        if (this.completedInputs.contains(input)) {
            return;
        }
        this.completedInputs.add(input);
        for (DependencyInfo importedInput : this.importedInputByImportingInput.get(input)) {
            this.orderInput(importedInput);
        }
        this.importOrderedInputs.add(input);
    }

    private void processInputs() {
        for (DependencyInfo userOrderedInput : this.userOrderedInputs) {
            if (userOrderedInput.getProvides().isEmpty()) {
                this.nonExportingInputs.put(Es6SortedDependencies.toModuleName(Es6SortedDependencies.createUri(userOrderedInput.getName())), userOrderedInput);
            }
            for (String providedSymbolName : userOrderedInput.getProvides()) {
                this.exportingInputBySymbolName.put(providedSymbolName, userOrderedInput);
            }
        }
        for (DependencyInfo userOrderedInput : this.userOrderedInputs) {
            for (String symbolName : userOrderedInput.getRequires()) {
                DependencyInfo importedInput = (DependencyInfo)this.exportingInputBySymbolName.get(symbolName);
                if (importedInput == null) continue;
                this.importedInputByImportingInput.put((Object)userOrderedInput, (Object)importedInput);
            }
        }
        for (DependencyInfo userOrderedInput : this.userOrderedInputs) {
            this.orderInput(userOrderedInput);
        }
        this.completedInputs.clear();
        this.importedInputByImportingInput.clear();
    }
}

