/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.actions;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.tools.PasteTool;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.internal.core.editor.actions.ActionUtils;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMementoTransfer;

public class PasteAction
extends Action {
    private final IEditPartViewer m_viewer;

    public PasteAction(IEditPartViewer viewer) {
        this.m_viewer = viewer;
        ActionUtils.copyPresentation((IAction)this, (ActionFactory)ActionFactory.PASTE);
    }

    public void run() {
        Control focusControl = Display.getCurrent().getFocusControl();
        if (focusControl instanceof Text) {
            ((Text)focusControl).paste();
            return;
        }
        List<JavaInfoMemento> mementos = PasteAction.getMementos();
        if (mementos != null) {
            this.m_viewer.getEditDomain().setActiveTool((Tool)new PasteTool(mementos));
        }
    }

    private static List<JavaInfoMemento> getMementos() {
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        try {
            List list = (List)clipboard.getContents((Transfer)JavaInfoMementoTransfer.getInstance());
            return list;
        }
        finally {
            clipboard.dispose();
        }
    }
}

