/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.psystem.ITypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.KeyedEnumerablePConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.TypeJudgement;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;

public class TypeConstraint
extends KeyedEnumerablePConstraint<IInputKey>
implements ITypeConstraint {
    private TypeJudgement equivalentJudgement;

    public TypeConstraint(PBody pBody, Tuple variablesTuple, IInputKey inputKey) {
        super(pBody, variablesTuple, inputKey);
        this.equivalentJudgement = new TypeJudgement(inputKey, variablesTuple);
        if (!inputKey.isEnumerable()) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getSimpleName()) + " applicable for enumerable input keys only; received instead " + inputKey);
        }
        if (variablesTuple.getSize() != inputKey.getArity()) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getSimpleName()) + " applied for variable tuple " + variablesTuple + " having wrong arity for input key " + inputKey);
        }
    }

    @Override
    protected String keyToString() {
        return ((IInputKey)this.supplierKey).getPrettyPrintableName();
    }

    @Override
    public TypeJudgement getEquivalentJudgement() {
        return this.equivalentJudgement;
    }

    @Override
    public Set<TypeJudgement> getImpliedJudgements(IQueryMetaContext context) {
        return Collections.singleton(this.equivalentJudgement);
    }

    @Override
    public Map<Set<PVariable>, Set<PVariable>> getFunctionalDependencies(IQueryMetaContext context) {
        return ITypeConstraint.TypeConstraintUtil.getFunctionalDependencies(context, (IInputKey)this.supplierKey, this.variablesTuple);
    }

    @Override
    public void doReplaceVariable(PVariable obsolete, PVariable replacement) {
        super.doReplaceVariable(obsolete, replacement);
        this.equivalentJudgement = new TypeJudgement((IInputKey)this.getSupplierKey(), this.variablesTuple);
    }
}

