/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.validation.core.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.addon.validation.core.api.IConstraintSpecification;
import org.eclipse.viatra.addon.validation.core.api.Severity;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;

public class ConstraintSpecification
implements IConstraintSpecification {
    private final IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> querySpecification;
    private final String messageFormat;
    private final Severity severity;
    private final List<String> keyNames;
    private final List<String> propertyNames;
    private final Set<List<String>> symmetricKeyNames;
    private final Set<List<String>> symmetricPropertyNames;

    private ConstraintSpecification(ConstraintSpecificationBuilder builder) {
        String parameterName;
        this.querySpecification = builder.querySpecification;
        this.messageFormat = builder.messageFormat;
        this.severity = builder.severity;
        List parameters = this.querySpecification.getParameters();
        if (!builder.keys.isEmpty()) {
            this.keyNames = builder.keys;
        } else {
            this.keyNames = new ArrayList<String>();
            for (PParameter parameter : parameters) {
                parameterName = parameter.getName();
                this.keyNames.add(parameterName);
            }
        }
        this.propertyNames = new ArrayList<String>();
        for (PParameter parameter : parameters) {
            parameterName = parameter.getName();
            if (this.keyNames.contains(parameterName)) continue;
            this.propertyNames.add(parameterName);
        }
        this.symmetricKeyNames = new HashSet<List<String>>();
        this.symmetricPropertyNames = new HashSet<List<String>>();
        for (List symmetrics : builder.symmetricParameterNames) {
            if (this.keyNames.containsAll(symmetrics)) {
                this.symmetricKeyNames.add(symmetrics);
                continue;
            }
            if (!this.propertyNames.containsAll(symmetrics)) continue;
            this.symmetricPropertyNames.add(symmetrics);
        }
    }

    @Override
    public String getMessageFormat() {
        return this.messageFormat;
    }

    @Override
    public Map<String, Object> getKeyObjects(IPatternMatch signature) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : this.keyNames) {
            Object keyObject = signature.get(key);
            map.put(key, keyObject);
        }
        return map;
    }

    @Override
    public List<String> getKeyNames() {
        return Collections.unmodifiableList(new ArrayList<String>(this.keyNames));
    }

    @Override
    public List<String> getPropertyNames() {
        return Collections.unmodifiableList(new ArrayList<String>(this.propertyNames));
    }

    @Override
    public Severity getSeverity() {
        return this.severity;
    }

    @Override
    public Set<List<String>> getSymmetricPropertyNames() {
        return Collections.unmodifiableSet(new HashSet<List<String>>(this.symmetricPropertyNames));
    }

    @Override
    public Set<List<String>> getSymmetricKeyNames() {
        return Collections.unmodifiableSet(new HashSet<List<String>>(this.symmetricKeyNames));
    }

    @Override
    public IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> getQuerySpecification() {
        return this.querySpecification;
    }

    /* synthetic */ ConstraintSpecification(ConstraintSpecificationBuilder constraintSpecificationBuilder, ConstraintSpecification constraintSpecification) {
        this(constraintSpecificationBuilder);
    }

    public static class ConstraintSpecificationBuilder {
        private final IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> querySpecification;
        private final String messageFormat;
        private final Severity severity;
        private List<String> keys;
        private Set<List<String>> symmetricParameterNames;

        public ConstraintSpecificationBuilder(IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> querySpecification, String messageFormat, Severity severity) {
            this.querySpecification = querySpecification;
            this.messageFormat = messageFormat;
            this.severity = severity;
            this.keys = new ArrayList<String>();
            this.symmetricParameterNames = new HashSet<List<String>>();
            if (this.querySpecification == null) {
                throw new IllegalStateException("A queryspecification must be provided!");
            }
            if (this.messageFormat == null) {
                throw new IllegalStateException("A message format must be provided!");
            }
        }

        public ConstraintSpecificationBuilder keyNames(List<String> keyNames) {
            this.keys = keyNames;
            return this;
        }

        public ConstraintSpecificationBuilder symmetricParameters(List<String> symmetricParameters) {
            List parameters = this.querySpecification.getParameters();
            ArrayList<String> parameterNames = new ArrayList<String>();
            for (PParameter parameter : parameters) {
                String parameterName = parameter.getName();
                parameterNames.add(parameterName);
            }
            for (String symmetricParameter : symmetricParameters) {
                if (parameterNames.contains(symmetricParameter)) continue;
                throw new IllegalStateException("A provided symmetric parameter name (" + symmetricParameter + ") is not in the query specification's pattern's parameter list!");
            }
            if (!this.keys.containsAll(symmetricParameters)) {
                for (String symmetricParameter : symmetricParameters) {
                    if (!this.keys.contains(symmetricParameter)) continue;
                    throw new IllegalStateException("The provided symmetric parameter names must be either all key parameters or neither of them can be a key parameter!");
                }
            }
            this.symmetricParameterNames.add(symmetricParameters);
            return this;
        }

        public ConstraintSpecification build() {
            ConstraintSpecification constraintSpecification = new ConstraintSpecification(this, null);
            List parameters = constraintSpecification.getQuerySpecification().getParameters();
            ArrayList<String> parameterNames = new ArrayList<String>();
            for (PParameter parameter : parameters) {
                String parameterName = parameter.getName();
                parameterNames.add(parameterName);
            }
            if (!parameterNames.containsAll(constraintSpecification.getKeyNames())) {
                throw new IllegalStateException("A provided key parameter name is not in the query specification's pattern's parameter list!");
            }
            return constraintSpecification;
        }
    }
}

