/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.common.ui.internal.util;

import java.net.URL;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.common.ui.internal.MoDiscoCommonUIPlugin;
import org.eclipse.swt.graphics.Image;

public class ImageProvider {
    private static final String MODISCO_LOGO = "icons/logoMoDiscoMini.gif";
    protected static final String CATALOG_ICON_URL = "/icons/catalog.png";
    protected static final String ERROR_ICON_URL = "/icons/error.png";
    private static ImageProvider instance = new ImageProvider();
    private Image modiscoLogo;
    private Image catalog = null;

    public static ImageProvider getInstance() {
        return instance;
    }

    private ImageDescriptor createImageDescriptor(String resourcePath) {
        URL url = MoDiscoCommonUIPlugin.getDefault().getBundle().getResource(resourcePath);
        if (url == null) {
            MoDiscoLogger.logError((String)("resource not found: " + resourcePath), (Plugin)MoDiscoCommonUIPlugin.getDefault());
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return ImageDescriptor.createFromURL((URL)url);
    }

    public Image getModiscoLogo() {
        if (this.modiscoLogo == null) {
            this.modiscoLogo = this.createImageDescriptor(MODISCO_LOGO).createImage();
        }
        return this.modiscoLogo;
    }

    public ImageDescriptor getModiscoLogoDescriptor() {
        return this.createImageDescriptor(MODISCO_LOGO);
    }

    public Image getCatalogIcon() {
        if (this.catalog == null) {
            this.catalog = this.createImageDescriptor(CATALOG_ICON_URL).createImage();
        }
        return this.catalog;
    }

    public Image getErrorIcon() {
        if (this.catalog == null) {
            this.catalog = this.createImageDescriptor(ERROR_ICON_URL).createImage();
        }
        return this.catalog;
    }
}

