/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.panes.oql.textPartitioning;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;

public class MultilineNonConsumingRule
implements IRule,
IPredicateRule {
    String startSequence;
    String[] endSequences;
    IToken token;

    public MultilineNonConsumingRule(String startSequence, String[] endSequences, IToken token) {
        this.startSequence = startSequence;
        this.endSequences = endSequences;
        this.token = token;
    }

    public IToken evaluate(ICharacterScanner arg0, boolean resume) {
        if (!resume) {
            return this.evaluate(arg0);
        }
        this.findEndToken(arg0, this.endSequences);
        return this.token;
    }

    public IToken getSuccessToken() {
        return this.token;
    }

    public IToken evaluate(ICharacterScanner arg0) {
        if (this.startsWith(arg0, this.startSequence)) {
            this.findEndToken(arg0, this.endSequences);
            return this.token;
        }
        return new BadToken();
    }

    private boolean startsWith(ICharacterScanner sequence, String beginningSequence) {
        char[] seqRead = new char[beginningSequence.length()];
        int read = sequence.read();
        int numRead = 1;
        int offset = 0;
        while (offset < beginningSequence.length() && read != -1) {
            seqRead[offset] = (char)read;
            read = sequence.read();
            ++numRead;
            ++offset;
        }
        String strRead = new String(seqRead);
        if (strRead.equalsIgnoreCase(beginningSequence)) {
            return true;
        }
        this.rewind(sequence, numRead);
        return false;
    }

    private boolean findEndToken(ICharacterScanner sequence, String[] endSequences) {
        char[][] endSeq = new char[endSequences.length][];
        int[] endSeqOffset = new int[endSequences.length];
        int i = 0;
        while (i < endSequences.length) {
            endSeq[i] = endSequences[i].toCharArray();
            ++i;
        }
        int currentC = sequence.read();
        int sequenceFound = -1;
        while (currentC != -1 && sequenceFound == -1) {
            sequenceFound = this.performStep((char)currentC, endSeqOffset, endSeq);
            currentC = sequence.read();
        }
        if (sequenceFound != -1) {
            this.rewind(sequence, endSequences[sequenceFound].length() + 1);
            return true;
        }
        return false;
    }

    private int performStep(char character, int[] offsets, char[][] endSeq) {
        int i = 0;
        while (i < offsets.length) {
            if (Character.toUpperCase(character) == Character.toUpperCase(endSeq[i][offsets[i]])) {
                int n = i;
                offsets[n] = offsets[n] + 1;
                if (offsets[i] == endSeq[i].length) {
                    return i;
                }
            } else {
                offsets[i] = 0;
            }
            ++i;
        }
        return -1;
    }

    private void rewind(ICharacterScanner sequence, int length) {
        int i = 0;
        while (i < length) {
            sequence.unread();
            ++i;
        }
    }

    public static class BadToken
    implements IToken {
        public Object getData() {
            return null;
        }

        public boolean isEOF() {
            return false;
        }

        public boolean isOther() {
            return false;
        }

        public boolean isUndefined() {
            return true;
        }

        public boolean isWhitespace() {
            return false;
        }
    }
}

