/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import java.util.function.Predicate;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.launch.BaseResourceAwareLaunchShortcut;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchConfigurationUtils;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchMessages;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageBuildDialog;
import org.eclipse.linuxtools.internal.docker.ui.wizards.NewDockerConnection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class BuildDockerImageShortcut
extends BaseResourceAwareLaunchShortcut {
    @Override
    protected void launch(IResource resource, String mode) {
        Predicate<ILaunchConfiguration> predicate = config -> {
            try {
                String sourcePath = config.getAttribute("sourcePathLocation", "");
                boolean workspaceRelative = config.getAttribute("sourcePathWorkspaceRelativeLocation", false);
                String dockerfileName = config.getAttribute("dockerfileName", "Dockerfile");
                IPath dockerfilePath = BuildDockerImageShortcut.getPath(sourcePath, workspaceRelative).append(dockerfileName);
                return dockerfilePath.equals((Object)resource.getLocation());
            }
            catch (CoreException e) {
                Activator.log(e);
                return false;
            }
        };
        ILaunchConfiguration config2 = this.findLaunchConfiguration("org.eclipse.linuxtools.docker.ui.buildDockerImageLaunchConfigurationType", resource, predicate);
        if (config2 != null) {
            DebugUITools.launch((ILaunchConfiguration)config2, (String)mode);
        } else {
            Activator.log(new DockerException(LaunchMessages.getString("BuildDockerImageShortcut.launchconfig.error")));
        }
    }

    @Override
    protected ILaunchConfiguration createConfiguration(IResource dockerfile) {
        block4: {
            if (DockerConnectionManager.getInstance().hasConnections()) break block4;
            Display.getDefault().asyncExec(() -> {
                boolean confirm = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)LaunchMessages.getString("BuildDockerImageShortcut.no.connections.msg"), (String)LaunchMessages.getString("BuildDockerImageShortcut.no.connections.desc"));
                if (confirm) {
                    NewDockerConnection newConnWizard = new NewDockerConnection();
                    CommandUtils.openWizard((IWizard)newConnWizard, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                }
            });
            return null;
        }
        try {
            ImageBuildDialog dialog = new ImageBuildDialog(this.getActiveWorkbenchShell());
            int result = dialog.open();
            if (result == 0) {
                return LaunchConfigurationUtils.createBuildImageLaunchConfiguration(dialog.getConnection(), dialog.getRepoName(), dockerfile);
            }
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        return null;
    }
}

