/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jface.text.Position;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.java.CompilationUnitHelper;
import org.eclipse.jst.jsp.core.internal.java.IJSPTranslation;
import org.eclipse.jst.jsp.core.internal.java.JSP2ServletNameUtil;
import org.eclipse.jst.jsp.core.internal.java.JSPProblemRequestor;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslator;

public class JSPTranslation
implements IJSPTranslation {
    private static final boolean DEBUG;
    private String fClassname = "";
    private IJavaProject fJavaProject = null;
    private HashMap fJava2JspMap = null;
    private HashMap fJsp2JavaMap = null;
    private HashMap fJava2JspImportsMap = null;
    private HashMap fJava2JspUseBeanMap = null;
    private HashMap fJava2JspIndirectMap = null;
    private String fJavaText = "";
    private String fJspText = "";
    ICompilationUnit fCompilationUnit = null;
    private IProgressMonitor fProgressMonitor = null;
    private byte[] fLock = new byte[0];
    private String fMangledName;
    private String fJspName;
    private List<IProblem> fTranslationProblems;
    private Collection fIncludedPaths;
    private JSPTranslator fTranslator;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/jsptranslation");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public JSPTranslation(IJavaProject javaProj, JSPTranslator translator) {
        this.fJavaProject = javaProj;
        this.fTranslator = translator;
        this.initialize();
    }

    private void initialize() {
        if (this.fTranslator != null) {
            this.fJavaText = this.fTranslator.getTranslation().toString();
            this.fJspText = this.fTranslator.getJspText();
            this.fClassname = this.fTranslator.getClassname();
            this.fJava2JspMap = this.fTranslator.getJava2JspRanges();
            this.fJsp2JavaMap = this.fTranslator.getJsp2JavaRanges();
            this.fJava2JspImportsMap = this.fTranslator.getJava2JspImportRanges();
            this.fJava2JspUseBeanMap = this.fTranslator.getJava2JspUseBeanRanges();
            this.fJava2JspIndirectMap = this.fTranslator.getJava2JspIndirectRanges();
            this.fTranslationProblems = this.fTranslator.getTranslationProblems();
            this.fIncludedPaths = this.fTranslator.getIncludedPaths();
        }
    }

    protected JSPTranslator getTranslator() {
        return this.fTranslator;
    }

    public IJavaProject getJavaProject() {
        return this.fJavaProject;
    }

    @Override
    public String getJavaText() {
        return this.fJavaText;
    }

    public String getJspText() {
        return this.fJspText;
    }

    public String getJavaPath() {
        ICompilationUnit cu = this.getCompilationUnit();
        return cu != null ? cu.getPath().toString() : "";
    }

    @Override
    public int getJavaOffset(int jspOffset) {
        int result = -1;
        int offsetInRange = 0;
        Position javaPos = null;
        for (Position jspPos : this.fJsp2JavaMap.keySet()) {
            if (!jspPos.includes(jspOffset) && jspPos.offset + jspPos.length != jspOffset) continue;
            offsetInRange = jspOffset - jspPos.offset;
            javaPos = (Position)this.fJsp2JavaMap.get(jspPos);
            if (javaPos != null) {
                result = javaPos.offset + offsetInRange;
                break;
            }
            Logger.log(4, "JavaPosition was null!" + jspOffset);
            break;
        }
        return result;
    }

    @Override
    public int getJspOffset(int javaOffset) {
        int result = -1;
        int offsetInRange = 0;
        Position javaPos2 = null;
        for (Position javaPos2 : this.fJava2JspMap.keySet()) {
            if (!javaPos2.includes(javaOffset) && javaPos2.offset + javaPos2.length != javaOffset) continue;
            offsetInRange = javaOffset - javaPos2.offset;
            Position jspPos = (Position)this.fJava2JspMap.get(javaPos2);
            if (jspPos != null) {
                result = jspPos.offset + offsetInRange;
                break;
            }
            Logger.log(4, "jspPosition was null!" + javaOffset);
            break;
        }
        return result;
    }

    public Collection getIncludedPaths() {
        return this.fIncludedPaths;
    }

    public HashMap getJava2JspMap() {
        return this.fJava2JspMap;
    }

    public HashMap getJsp2JavaMap() {
        return this.fJsp2JavaMap;
    }

    public boolean javaSpansMultipleJspPartitions(int javaOffset, int javaLength) {
        HashMap java2jsp = this.getJava2JspMap();
        int count = 0;
        Iterator it = java2jsp.keySet().iterator();
        Position javaRange = null;
        while (it.hasNext()) {
            javaRange = (Position)it.next();
            if (javaRange.overlapsWith(javaOffset, javaLength)) {
                ++count;
            }
            if (count <= 1) continue;
            return true;
        }
        return false;
    }

    public Position[] getJavaRanges(int offset, int length) {
        ArrayList<Position> results = new ArrayList<Position>();
        Iterator it = this.getJava2JspMap().keySet().iterator();
        Position p = null;
        while (it.hasNext()) {
            p = (Position)it.next();
            if (!p.overlapsWith(offset, length)) continue;
            results.add(p);
        }
        return results.toArray(new Position[results.size()]);
    }

    public boolean isImport(int javaOffset) {
        return this.isInRanges(javaOffset, this.fJava2JspImportsMap);
    }

    public boolean isUseBean(int javaOffset) {
        return this.isInRanges(javaOffset, this.fJava2JspUseBeanMap);
    }

    @Override
    public boolean isIndirect(int javaOffset) {
        return this.isInRanges(javaOffset, this.fJava2JspIndirectMap, false);
    }

    private boolean isInRanges(int javaOffset, HashMap ranges) {
        return this.isInRanges(javaOffset, ranges, true);
    }

    private boolean isInRanges(int javaOffset, HashMap ranges, boolean includeEndOffset) {
        for (Position javaPos : ranges.keySet()) {
            if (!javaPos.includes(javaOffset) && (!includeEndOffset || javaPos.offset + javaPos.length != javaOffset)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICompilationUnit getCompilationUnit() {
        byte[] byArray = this.fLock;
        synchronized (this.fLock) {
            block6: {
                try {
                    if (this.fCompilationUnit == null) {
                        this.fCompilationUnit = this.createCompilationUnit();
                    }
                }
                catch (JavaModelException jme) {
                    if (!DEBUG) break block6;
                    Logger.logException("error creating JSP working copy... ", jme);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.fCompilationUnit;
        }
    }

    private String getMangledName() {
        return this.fMangledName;
    }

    private void setMangledName(String mangledName) {
        this.fMangledName = mangledName;
    }

    private String getJspName() {
        return this.fJspName;
    }

    private void setJspName(String jspName) {
        this.fJspName = jspName;
    }

    public String fixupMangledName(String displayString) {
        if (displayString == null) {
            return null;
        }
        if (this.getJspName() == null || this.getMangledName() == null) {
            this.initJspAndServletNames();
        }
        return displayString.replaceAll(this.getMangledName(), this.getJspName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initJspAndServletNames() {
        ICompilationUnit cu = this.getCompilationUnit();
        if (cu != null) {
            String cuName = null;
            ICompilationUnit iCompilationUnit = cu;
            synchronized (iCompilationUnit) {
                cuName = cu.getPath().lastSegment();
            }
            if (cuName != null) {
                this.setMangledName(cuName.substring(0, cuName.lastIndexOf(46)));
                String unmangled = JSP2ServletNameUtil.unmangle(cuName);
                int endIdx = unmangled.lastIndexOf(46);
                this.setJspName(unmangled.substring(unmangled.lastIndexOf(47) + 1, endIdx > 0 ? endIdx : unmangled.length()));
            }
        }
    }

    private ICompilationUnit createCompilationUnit() throws JavaModelException {
        IJavaProject je = this.getJavaProject();
        if (je == null || !je.exists()) {
            return null;
        }
        String name = String.valueOf(this.getClassname()) + ".java";
        IPackageFragmentRoot packageFragmentRoot = null;
        IPackageFragmentRoot[] packageFragmentRoots = je.getPackageFragmentRoots();
        int i = 0;
        while (i < packageFragmentRoots.length) {
            if (!packageFragmentRoots[i].isArchive() && !packageFragmentRoots[i].isExternal()) {
                packageFragmentRoot = packageFragmentRoots[i];
                break;
            }
            ++i;
        }
        if (packageFragmentRoot == null) {
            if (DEBUG) {
                System.out.println("** Abort create working copy: cannot create working copy: JSP is not in a Java project with source package fragment root");
            }
            return null;
        }
        IPackageFragment fragment = packageFragmentRoot.getPackageFragment("");
        ICompilationUnit cu = fragment.getCompilationUnit(name).getWorkingCopy(this.getWorkingCopyOwner(), this.getProgressMonitor());
        this.setContents(cu);
        if (DEBUG) {
            System.out.println("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
            System.out.println("(+) JSPTranslation [" + this + "] finished creating CompilationUnit: " + cu);
            System.out.println("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        }
        return cu;
    }

    private JSPProblemRequestor getProblemRequestor() {
        return CompilationUnitHelper.getInstance().getProblemRequestor();
    }

    public WorkingCopyOwner getWorkingCopyOwner() {
        return CompilationUnitHelper.getInstance().getWorkingCopyOwner();
    }

    private IProgressMonitor getProgressMonitor() {
        if (this.fProgressMonitor == null) {
            this.fProgressMonitor = new NullProgressMonitor();
        }
        return this.fProgressMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getProblems() {
        List problems = this.getProblemRequestor().getCollectedProblems();
        if (problems != null) {
            if (this.fTranslationProblems.isEmpty()) {
                return problems;
            }
            ArrayList<IProblem> combinedProblems = null;
            List list = problems;
            synchronized (list) {
                combinedProblems = new ArrayList<IProblem>(problems);
            }
            combinedProblems.addAll(this.fTranslationProblems);
            return combinedProblems;
        }
        return this.fTranslationProblems;
    }

    @Override
    public void setProblemCollectingActive(boolean collect) {
        ICompilationUnit cu = this.getCompilationUnit();
        if (cu != null) {
            this.getProblemRequestor().setIsActive(collect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retranslate(JSPTranslator translator) {
        this.fTranslator = translator;
        this.initialize();
        byte[] byArray = this.fLock;
        synchronized (this.fLock) {
            this.setContents(this.getCompilationUnit());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconcileCompilationUnit() {
        ICompilationUnit cu = this.getCompilationUnit();
        boolean isClosed = false;
        if (cu != null) {
            try {
                try {
                    ICompilationUnit iCompilationUnit = cu;
                    synchronized (iCompilationUnit) {
                        boolean bl = isClosed = !cu.isOpen();
                        if (isClosed) {
                            cu.becomeWorkingCopy(null);
                        }
                        cu.reconcile(0, true, this.getWorkingCopyOwner(), this.getProgressMonitor());
                    }
                }
                catch (JavaModelException e) {
                    Logger.logException(e);
                    if (isClosed) {
                        this.release();
                    }
                }
            }
            finally {
                if (isClosed) {
                    this.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setContents(ICompilationUnit cu) {
        if (cu == null) {
            return;
        }
        ICompilationUnit iCompilationUnit = cu;
        synchronized (iCompilationUnit) {
            IBuffer buffer;
            try {
                buffer = cu.getBuffer();
            }
            catch (JavaModelException e) {
                e.printStackTrace();
                buffer = null;
            }
            if (buffer != null) {
                buffer.setContents(this.getJavaText());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IJavaElement[] getElementsFromJspRange(int jspStart, int jspEnd) {
        IJavaElement[] EMTPY_RESULT_SET;
        int javaPositionStart = this.getJavaOffset(jspStart);
        int javaPositionEnd = this.getJavaOffset(jspEnd);
        IJavaElement[] result = EMTPY_RESULT_SET = new IJavaElement[0];
        try {
            ICompilationUnit cu = this.getCompilationUnit();
            if (cu != null) {
                ICompilationUnit iCompilationUnit = cu;
                synchronized (iCompilationUnit) {
                    int cuDocLength = cu.getBuffer().getLength();
                    int javaLength = javaPositionEnd - javaPositionStart;
                    if (cuDocLength > 0 && javaPositionStart >= 0 && javaLength >= 0 && javaPositionEnd < cuDocLength) {
                        result = cu.codeSelect(javaPositionStart, javaLength);
                    }
                }
            }
            if (result == null || result.length == 0) {
                return EMTPY_RESULT_SET;
            }
        }
        catch (JavaModelException x) {
            Logger.logException(x);
        }
        return result;
    }

    public String getClassname() {
        return this.fClassname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        byte[] byArray = this.fLock;
        synchronized (this.fLock) {
            if (this.fCompilationUnit != null) {
                WorkspaceJob discarder = new WorkspaceJob(this.fClassname){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        try {
                            if (DEBUG) {
                                System.out.println("------------------------------------------------------------------");
                                System.out.println("(-) JSPTranslation [" + (Object)((Object)this) + "] discarding CompilationUnit: " + JSPTranslation.this.fCompilationUnit);
                                System.out.println("------------------------------------------------------------------");
                            }
                            JSPTranslation.this.fCompilationUnit.discardWorkingCopy();
                        }
                        catch (JavaModelException javaModelException) {}
                        return Status.OK_STATUS;
                    }
                };
                discarder.schedule();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

