/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.ui.actions;

import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.common.adapt.IAdaptable;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.viewer.IViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Event;

public abstract class AbstractViewerAction
extends Action
implements IAdaptable.Bound<IViewer> {
    private ReadOnlyObjectWrapper<IViewer> viewerProperty = new ReadOnlyObjectWrapper();
    private ChangeListener<Boolean> activationListener = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                AbstractViewerAction.this.register();
            } else {
                AbstractViewerAction.this.unregister();
            }
        }
    };

    protected AbstractViewerAction(String text) {
        this(text, 1, null);
    }

    protected AbstractViewerAction(String text, int style, ImageDescriptor imageDescriptor) {
        super(text, style);
        this.setImageDescriptor(imageDescriptor);
        this.setEnabled(false);
    }

    public ReadOnlyObjectProperty<IViewer> adaptableProperty() {
        return this.viewerProperty;
    }

    protected abstract ITransactionalOperation createOperation(Event var1);

    public IViewer getAdaptable() {
        return (IViewer)this.viewerProperty.get();
    }

    protected IViewer getViewer() {
        return this.getAdaptable();
    }

    protected void register() {
        this.setEnabled(true);
    }

    public void run() {
        throw new UnsupportedOperationException("Only runWithEvent(Event) supported.");
    }

    public void runWithEvent(Event event) {
        if (!this.isEnabled()) {
            return;
        }
        ITransactionalOperation operation = this.createOperation(event);
        if (operation != null) {
            try {
                this.getViewer().getDomain().execute(operation, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            if (event != null) {
                event.doit = false;
            }
        }
    }

    public void setAdaptable(IViewer viewer) {
        if (this.viewerProperty.get() == viewer) {
            return;
        }
        if (this.viewerProperty.get() != null) {
            ((IViewer)this.viewerProperty.get()).activeProperty().removeListener(this.activationListener);
            if (((IViewer)this.viewerProperty.get()).isActive()) {
                this.unregister();
            }
        }
        this.viewerProperty.set((Object)viewer);
        if (this.viewerProperty.get() != null) {
            ((IViewer)this.viewerProperty.get()).activeProperty().addListener(this.activationListener);
            if (((IViewer)this.viewerProperty.get()).isActive()) {
                this.register();
            }
        }
    }

    protected void unregister() {
        this.setEnabled(false);
    }
}

