/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.core.liqp.tags;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.embedcdt.core.liqp.TemplateContext;
import org.eclipse.embedcdt.core.liqp.exceptions.ExceededMaxIterationsException;
import org.eclipse.embedcdt.core.liqp.nodes.BlockNode;
import org.eclipse.embedcdt.core.liqp.nodes.LNode;
import org.eclipse.embedcdt.core.liqp.tags.Tag;

class For
extends Tag {
    private static final String OFFSET = "offset";
    private static final String LIMIT = "limit";
    private static final String CONTINUE = "continue";
    private static final String FORLOOP = "forloop";
    private static final String LENGTH = "length";
    private static final String INDEX = "index";
    private static final String INDEX0 = "index0";
    private static final String RINDEX = "rindex";
    private static final String RINDEX0 = "rindex0";
    private static final String FIRST = "first";
    private static final String LAST = "last";
    private static final String NAME = "name";

    For() {
    }

    @Override
    public Object render(TemplateContext context, LNode ... nodes) {
        boolean array = super.asBoolean(nodes[0].render(context));
        String id = super.asString(nodes[1].render(context));
        TemplateContext nestedContext = new TemplateContext(context);
        nestedContext.put(FORLOOP, new HashMap());
        Object rendered = array ? this.renderArray(id, nestedContext, nodes) : this.renderRange(id, nestedContext, nodes);
        return rendered;
    }

    private Object renderArray(String id, TemplateContext context, LNode ... tokens) {
        StringBuilder builder = new StringBuilder();
        Map<String, Integer> attributes = this.getAttributes(5, context, tokens);
        int offset = attributes.get(OFFSET);
        int limit = attributes.get(LIMIT);
        Object[] array = super.asArray(tokens[2].render(context));
        LNode block = tokens[3];
        LNode blockIfEmptyOrNull = tokens[4];
        if (array == null || array.length == 0) {
            return blockIfEmptyOrNull == null ? null : blockIfEmptyOrNull.render(context);
        }
        int length = Math.min(limit, array.length);
        Map forLoopMap = (Map)context.get(FORLOOP);
        forLoopMap.put(NAME, String.valueOf(id) + "-" + tokens[2].toString());
        int continueIndex = offset;
        int i = offset;
        int n = 0;
        while (n < limit && i < array.length) {
            context.incrementIterations();
            continueIndex = i;
            boolean first = i == offset;
            boolean last = n == limit - 1 || i == array.length - 1;
            context.put(id, array[i]);
            forLoopMap.put(LENGTH, length);
            forLoopMap.put(INDEX, n + 1);
            forLoopMap.put(INDEX0, n);
            forLoopMap.put(RINDEX, length - n);
            forLoopMap.put(RINDEX0, length - n - 1);
            forLoopMap.put(FIRST, first);
            forLoopMap.put(LAST, last);
            List<LNode> children = ((BlockNode)block).getChildren();
            boolean isBreak = false;
            for (LNode node : children) {
                Object value = node.render(context);
                if (value == Tag.Statement.CONTINUE) break;
                if (value == Tag.Statement.BREAK) {
                    isBreak = true;
                    break;
                }
                if (value != null && value.getClass().isArray()) {
                    Object[] arr;
                    Object[] objectArray = arr = (Object[])value;
                    int n2 = arr.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        Object obj = objectArray[n3];
                        builder.append(String.valueOf(obj));
                        ++n3;
                    }
                    continue;
                }
                builder.append(super.asString(value));
            }
            if (isBreak) break;
            ++i;
            ++n;
        }
        context.put(CONTINUE, continueIndex + 1, true);
        return builder.toString();
    }

    private Object renderRange(String id, TemplateContext context, LNode ... tokens) {
        StringBuilder builder = new StringBuilder();
        Map<String, Integer> attributes = this.getAttributes(5, context, tokens);
        int offset = attributes.get(OFFSET);
        int limit = attributes.get(LIMIT);
        LNode block = tokens[4];
        try {
            int from = super.asNumber(tokens[2].render(context)).intValue();
            int to = super.asNumber(tokens[3].render(context)).intValue();
            int length = to - from;
            Map forLoopMap = (Map)context.get(FORLOOP);
            int continueIndex = from + offset;
            int i = from + offset;
            int n = 0;
            while (i <= to && n < limit) {
                context.incrementIterations();
                continueIndex = i;
                boolean first = i == from + offset;
                boolean last = i == to || n == limit - 1;
                context.put(id, i);
                forLoopMap.put(LENGTH, length);
                forLoopMap.put(INDEX, n + 1);
                forLoopMap.put(INDEX0, n);
                forLoopMap.put(RINDEX, length - n);
                forLoopMap.put(RINDEX0, length - n - 1);
                forLoopMap.put(FIRST, first);
                forLoopMap.put(LAST, last);
                List<LNode> children = ((BlockNode)block).getChildren();
                boolean isBreak = false;
                for (LNode node : children) {
                    Object value = node.render(context);
                    if (value == null) continue;
                    if (value == Tag.Statement.CONTINUE) break;
                    if (value == Tag.Statement.BREAK) {
                        isBreak = true;
                        break;
                    }
                    if (super.isArray(value)) {
                        Object[] arr;
                        Object[] objectArray = arr = super.asArray(value);
                        int n2 = arr.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            Object obj = objectArray[n3];
                            builder.append(String.valueOf(obj));
                            ++n3;
                        }
                        continue;
                    }
                    builder.append(super.asString(value));
                }
                if (isBreak) break;
                ++i;
                ++n;
            }
            context.put(CONTINUE, continueIndex + 1);
        }
        catch (ExceededMaxIterationsException e) {
            throw e;
        }
        catch (Exception exception) {}
        return builder.toString();
    }

    private Map<String, Integer> getAttributes(int fromIndex, TemplateContext context, LNode ... tokens) {
        HashMap<String, Integer> attributes = new HashMap<String, Integer>();
        attributes.put(OFFSET, 0);
        attributes.put(LIMIT, Integer.MAX_VALUE);
        int i = fromIndex;
        while (i < tokens.length) {
            Object[] attribute = super.asArray(tokens[i].render(context));
            try {
                attributes.put(super.asString(attribute[0]), super.asNumber(attribute[1]).intValue());
            }
            catch (Exception exception) {}
            ++i;
        }
        return attributes;
    }
}

