/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.Supplier;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jface.window.Window;
import org.eclipse.papyrus.infra.core.sasheditor.Activator;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.AbstractPageModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IEditorModel;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IEditorPage;
import org.eclipse.papyrus.infra.core.sasheditor.internal.AbstractPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.IMultiEditorManager;
import org.eclipse.papyrus.infra.core.sasheditor.internal.IPartVisitor;
import org.eclipse.papyrus.infra.core.sasheditor.internal.PagePart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.PapyrusProblemEditorPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.PartLists;
import org.eclipse.papyrus.infra.core.sasheditor.internal.TabFolderPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.dnd.IDropTarget;
import org.eclipse.papyrus.infra.core.sasheditor.internal.eclipsecopy.IMultiPageEditorSite;
import org.eclipse.papyrus.infra.core.sasheditor.internal.eclipsecopy.MultiPageEditorSite;
import org.eclipse.papyrus.infra.tools.util.PlatformHelper;
import org.eclipse.papyrus.infra.tools.util.StatusUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.IWorkbenchPartOrientation;

public class EditorPart
extends PagePart
implements IEditorPage {
    private IEditorModel editorModel;
    private IEditorPart editorPart;
    private Composite editorControl;
    private IMultiEditorManager multiEditorManager;
    private Listener mouseEnterListener = new Listener(){

        public void handleEvent(Event event) {
        }
    };
    private DisposeListener widgetDisposedListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            EditorPart.this.disposeEditorPart();
        }
    };

    public EditorPart(TabFolderPart parent, IEditorModel editorModel, Object rawModel, IMultiEditorManager multiEditorManager) {
        super(parent, rawModel);
        this.editorModel = editorModel;
        this.multiEditorManager = multiEditorManager;
        if (editorModel instanceof AbstractPageModel) {
            ((AbstractPageModel)((Object)editorModel)).onLabelChanged(label -> this.refreshTab());
        }
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        Supplier<Object> fallbackFallback = () -> super.getAdapter(adapter);
        Supplier<Object> fallback = () -> PlatformHelper.getAdapter((Object)this.editorModel, (Class)adapter, (Supplier)fallbackFallback);
        return (T)PlatformHelper.getAdapter((Object)this.editorPart, adapter, fallback);
    }

    @Override
    public void createPartControl(Composite parent) {
        try {
            this.editorPart = this.createIEditorPart();
            this.editorControl = this.createEditorPartControl(parent, this.editorPart);
            this.attachListeners((Control)this.editorControl, true);
        }
        catch (PartInitException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.infra.core.sasheditor", e.getLocalizedMessage(), (Throwable)e));
            this.createErrorEditorPart(parent, (Exception)((Object)e));
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.infra.core.sasheditor", e.getLocalizedMessage(), (Throwable)e));
            this.createErrorEditorPart(parent, e);
        }
    }

    private Composite createErrorPartControl(Composite parent, Exception e) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new FillLayout());
        StringWriter strOut = new StringWriter();
        PrintWriter out = new PrintWriter(strOut);
        e.printStackTrace(out);
        out.flush();
        out.close();
        Text diag = new Text(comp, 2);
        diag.setSize(64, 32);
        diag.setText(strOut.toString());
        return comp;
    }

    private void createErrorEditorPart(Composite parent, Exception e) {
        try {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic();
            basicDiagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.infra.core.sasheditor", 0, StatusUtils.getLocalizedMessage((Throwable)e), new Object[]{e}));
            this.editorPart = new PapyrusProblemEditorPart();
            ((PapyrusProblemEditorPart)this.editorPart).setDiagnostic((Diagnostic)basicDiagnostic);
            this.editorControl = this.createEditorPartControl(parent, this.editorPart);
        }
        catch (Exception ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.infra.core.sasheditor", e.getLocalizedMessage(), (Throwable)e));
            this.editorControl = this.createErrorPartControl(parent, e);
        }
    }

    private IEditorPart createIEditorPart() throws PartInitException {
        return this.editorModel.createIEditorPart();
    }

    private Composite createEditorPartControl(Composite parentControl, IEditorPart editor) throws PartInitException {
        IEditorSite site = this.createSite(editor);
        editor.init(site, this.getIMultiEditorManager().getEditorInput());
        Composite editorParent = new Composite(parentControl, this.getOrientation(editor));
        editorParent.setLayout((Layout)new FillLayout());
        editorParent.addDisposeListener(this.widgetDisposedListener);
        editor.createPartControl(editorParent);
        editor.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propertyId) {
                EditorPart.this.handlePropertyChange(propertyId);
            }
        });
        return editorParent;
    }

    private void attachListeners(Control theControl, boolean recursive) {
        theControl.addListener(26, this.mouseEnterListener);
    }

    private void detachListeners(Control theControl, boolean recursive) {
        theControl.removeListener(26, this.mouseEnterListener);
    }

    private void handlePropertyChange(int propertyId) {
        this.getSashWindowContainer().firePropertyChange(propertyId);
        this.getSashWindowContainer().getLifeCycleEventProvider().firePageFirePropertyChangeEvent(this, propertyId);
    }

    protected IEditorSite createSite(IEditorPart editor) {
        EditorActionBarContributor contributor = this.createEditorActionBarContributor();
        return new MultiPageEditorSite(this.multiEditorManager.getEditorSite(), editor, contributor);
    }

    private EditorActionBarContributor createEditorActionBarContributor() {
        EditorActionBarContributor contributor = this.editorModel.getActionBarContributor();
        return contributor;
    }

    private int getOrientation(IEditorPart editor) {
        if (editor instanceof IWorkbenchPartOrientation) {
            return ((IWorkbenchPartOrientation)editor).getOrientation();
        }
        return Window.getDefaultOrientation();
    }

    private IMultiEditorManager getIMultiEditorManager() {
        return this.multiEditorManager;
    }

    @Override
    public void dispose() {
        if (!this.editorControl.isDisposed()) {
            this.detachListeners((Control)this.editorControl, true);
            this.editorControl.dispose();
        }
        this.editorModel = null;
        this.rawModel = null;
    }

    @Override
    public void disposeThisAndChildren() {
        this.disposeEditorPart();
        this.editorModel = null;
        this.rawModel = null;
    }

    private void disposeEditorPart() {
        if (this.editorPart == null) {
            return;
        }
        IEditorPart part = this.editorPart;
        this.editorPart = null;
        SafeRunner.run((ISafeRunnable)new ISafeRunnable((IWorkbenchPart)part){
            private final /* synthetic */ IWorkbenchPart val$part;
            {
                this.val$part = iWorkbenchPart;
            }

            public void run() {
                IWorkbenchPartSite partSite = this.val$part.getSite();
                this.val$part.dispose();
                if (partSite instanceof IMultiPageEditorSite) {
                    ((IMultiPageEditorSite)partSite).dispose();
                }
            }

            public void handleException(Throwable e) {
            }
        });
    }

    public PagePart findPart(Point toFind) {
        return this;
    }

    @Override
    public PagePart findPartAt(Point toFind, Class<?> expectedTileType) {
        if (expectedTileType == this.getClass()) {
            return this;
        }
        throw new UnsupportedOperationException("Tile match the expected position '" + toFind + "' but there is no Tile of requested type '" + expectedTileType.getClass().getName() + "'");
    }

    public PagePart findPart(Object control) {
        if (this.getControl() == control) {
            return this;
        }
        return null;
    }

    @Override
    public IEditorPart getIEditorPart() {
        return this.editorPart;
    }

    public Composite getControl() {
        return this.editorControl;
    }

    public IDropTarget getDropTarget(Object draggedObject, TabFolderPart sourcePart, Point position) {
        return null;
    }

    @Override
    public AbstractPart.GarbageState getGarbageState() {
        return this.garbageState;
    }

    public boolean isDirty() {
        return this.editorPart.isDirty();
    }

    @Override
    public void reparent(TabFolderPart newParent) {
        this.parent = newParent;
        this.editorControl.setParent(newParent.getControl());
        if (this.garbageState != AbstractPart.GarbageState.UNVISITED && this.garbageState != AbstractPart.GarbageState.ORPHANED && this.garbageState != AbstractPart.GarbageState.CREATED) {
            throw new IllegalStateException("Try to change state from " + this.garbageState.toString() + " to REPARENTED. This is forbidden.");
        }
        this.garbageState = AbstractPart.GarbageState.REPARENTED;
    }

    @Override
    public void setFocus() {
        if (this.editorPart != null) {
            try {
                this.editorPart.setFocus();
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
        }
    }

    public void synchronize2(PartLists partMap) {
    }

    @Override
    public void garbage() {
        this.dispose();
        this.getSashWindowContainer().getLifeCycleEventProvider().firePageClosedEvent(this);
    }

    @Override
    public boolean visit(IPartVisitor visitor) {
        return visitor.accept(this);
    }

    public boolean visitChildren(IPartVisitor visitor) {
        return true;
    }

    protected void showStatus() {
        String title = this.editorPart != null ? this.editorPart.getTitle() : "no editorPart";
        System.out.printf("EditorTile: disposed=%-5b, visible=%-5b, garbState=%-10s, %s, %s\n", new Object[]{this.editorControl.isDisposed(), this.editorControl.isDisposed() ? false : this.editorControl.isVisible(), this.garbageState, title, this});
    }

    @Override
    public String getPageTitle() {
        try {
            return this.editorModel.getTabTitle();
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
            return "Error";
        }
    }

    @Override
    public Image getPageIcon() {
        try {
            return this.editorModel.getTabIcon();
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
    }
}

