/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.ui.internal.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.IServerModule;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;

public abstract class AbstractSyncLaunch {
    protected String launchMode = "run";
    protected IServer selectedServer;
    protected IModule selectedModule;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectedServer = null;
        this.selectedModule = null;
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof IServer) {
                this.selectedServer = (IServer)obj;
            } else if (obj instanceof IServerModule) {
                IServerModule sm = (IServerModule)obj;
                IModule[] module = sm.getModule();
                this.selectedModule = module[module.length - 1];
                if (this.selectedModule != null) {
                    this.selectedServer = sm.getServer();
                }
            }
        }
    }

    public static void start(IServer server, String launchMode, Shell shell) {
        block9: {
            if (server.getServerState() != 2) {
                if (!ServerUIPlugin.saveEditors()) {
                    return;
                }
                try {
                    server.synchronousStart(launchMode, null);
                }
                catch (CoreException e) {
                    Trace.trace((String)"/severe", (String)"Error starting server", (Throwable)e);
                }
            } else {
                if (shell != null && !ServerUIPlugin.promptIfDirty((Shell)shell, (IServer)server)) {
                    return;
                }
                try {
                    String launchMode2 = launchMode;
                    if (launchMode2 == null) {
                        launchMode2 = server.getMode();
                    }
                    server.restart(launchMode2, null);
                }
                catch (Exception e) {
                    if (!Trace.SEVERE) break block9;
                    Trace.trace((String)"/severe", (String)"Error restarting server", (Throwable)e);
                }
            }
        }
    }

    public void run(IAction action) {
        block8: {
            if (this.selectedServer.getServerState() != 2) {
                if (!ServerUIPlugin.saveEditors()) {
                    return;
                }
                try {
                    this.selectedServer.synchronousStart(this.launchMode, null);
                }
                catch (CoreException e) {
                    Trace.trace((String)"/severe", (String)"Error starting server", (Throwable)e);
                }
            } else {
                try {
                    String launchMode2 = this.launchMode;
                    if (launchMode2 == null) {
                        launchMode2 = this.selectedServer.getMode();
                    }
                    this.selectedServer.restart(launchMode2, null);
                }
                catch (Exception e) {
                    if (!Trace.SEVERE) break block8;
                    Trace.trace((String)"/severe", (String)"Error restarting server", (Throwable)e);
                }
            }
        }
    }
}

