import { GDBBackend } from './GDBBackend';
import { MIVarCreateResponse } from './mi/var';
export interface VarObjType {
    varname: string;
    expression: string;
    numchild: string;
    children: VarObjType[];
    value: string;
    type: string;
    isVar: boolean;
    isChild: boolean;
}
export declare class VarManager {
    protected gdb: GDBBackend;
    protected readonly variableMap: Map<string, VarObjType[]>;
    constructor(gdb: GDBBackend);
    getKey(frameId: number, threadId: number, depth: number): string;
    getVars(frameId: number, threadId: number, depth: number): VarObjType[] | undefined;
    getVar(frameId: number, threadId: number, depth: number, expression: string): VarObjType | undefined;
    getVarByName(frameId: number, threadId: number, depth: number, varname: string): VarObjType | undefined;
    addVar(frameId: number, threadId: number, depth: number, expression: string, isVar: boolean, isChild: boolean, varCreateResponse: MIVarCreateResponse): VarObjType;
    removeVar(frameId: number, threadId: number, depth: number, varname: string): Promise<void>;
    updateVar(frameId: number, threadId: number, depth: number, varobj: VarObjType): Promise<VarObjType>;
}
