/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ComponentEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.papyrus.uml.diagram.sequence.command.SetLocationCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CLifeLineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageCreateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.OLDLifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifelineDotLineCustomFigure;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifelineFigure;
import org.eclipse.papyrus.uml.diagram.sequence.locator.MessageCreateLifelineAnchor;

public class LifelineMessageCreateHelper {
    public static ConnectionAnchor getCreateMessageAnchor(LifelineEditPart part, Request request, Point location) {
        LifelineFigure fig = part.getPrimaryShape();
        fig.translateToRelative((Translatable)location);
        return new MessageCreateLifelineAnchor((IFigure)part.getPrimaryShape(), (CLifeLineEditPart)part);
    }

    @Deprecated
    static ConnectionAnchor getTargetConnectionAnchor(LifelineEditPart part, Request request) {
        NodeFigure nodeFigure = null;
        if (part.getContentPane() instanceof LifelineDotLineCustomFigure) {
            nodeFigure = ((LifelineDotLineCustomFigure)part.getContentPane()).getDashLineRectangle();
        }
        if (nodeFigure == null) {
            return null;
        }
        if (request instanceof ReconnectRequest) {
            if (((DropRequest)request).getLocation() == null) {
                return nodeFigure.getTargetConnectionAnchorAt(null);
            }
            Point pt = ((DropRequest)request).getLocation().getCopy();
            return nodeFigure.getTargetConnectionAnchorAt(pt);
        }
        if (request instanceof DropRequest) {
            return nodeFigure.getTargetConnectionAnchorAt(((DropRequest)request).getLocation());
        }
        return nodeFigure.getTargetConnectionAnchorAt(null);
    }

    public static Command restoreLifelineOnDelete(Command command, LifelineEditPart part) {
        List list = part.getSourceConnections();
        if (list != null && list.size() > 0) {
            for (Object l : list) {
                EditPart target;
                if (!(l instanceof MessageCreateEditPart) || !((target = ((MessageCreateEditPart)l).getTarget()) instanceof LifelineEditPart) || LifelineMessageCreateHelper.getIncomingMessageCreate(target).size() != 1) continue;
                LifelineEditPart lp = (LifelineEditPart)target;
                Rectangle bounds = lp.getPrimaryShape().getBounds();
                Point location = new Point(bounds.x, 10);
                int dy = location.y - bounds.y;
                SetLocationCommand boundsCommand = new SetLocationCommand(lp.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)lp.getNotationView()), location);
                command = command.chain((Command)new ICommandProxy((ICommand)boundsCommand));
                command = LifelineMessageCreateHelper.moveCascadeLifeline(lp, command, dy);
            }
        }
        return command;
    }

    public static boolean hasMessageCreate(GraphicalEditPart sourceEditPart, EditPart targetEditPart) {
        List list = sourceEditPart.getSourceConnections();
        for (Object o : list) {
            if (!(o instanceof MessageCreateEditPart) || !targetEditPart.equals(((MessageCreateEditPart)o).getTarget())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasIncomingMessageCreate(EditPart target) {
        return LifelineMessageCreateHelper.getIncomingMessageCreate(target).size() > 0;
    }

    public static List<?> getIncomingMessageCreate(EditPart target) {
        List list;
        ArrayList<MessageCreateEditPart> create = new ArrayList<MessageCreateEditPart>();
        if (target instanceof LifelineEditPart && (list = ((LifelineEditPart)target).getTargetConnections()) != null && list.size() > 0) {
            for (Object l : list) {
                if (!(l instanceof MessageCreateEditPart)) continue;
                create.add((MessageCreateEditPart)l);
            }
        }
        return create;
    }

    public static boolean canReconnectMessageCreate(ReconnectRequest request) {
        MessageCreateEditPart connPart = (MessageCreateEditPart)request.getConnectionEditPart();
        return !(request.isMovingStartAnchor() ? LifelineMessageCreateHelper.hasMessageCreate((GraphicalEditPart)request.getTarget(), (EditPart)((GraphicalEditPart)connPart.getTarget())) : LifelineMessageCreateHelper.hasMessageCreate((GraphicalEditPart)connPart.getSource(), request.getTarget()));
    }

    @Deprecated
    public static Command reconnectMessageCreateTarget(ReconnectRequest request, Command command) {
        LifelineEditPart oldTarget = (LifelineEditPart)request.getConnectionEditPart().getTarget();
        OLDLifelineEditPart newTarget = (OLDLifelineEditPart)request.getTarget();
        if (LifelineMessageCreateHelper.getIncomingMessageCreate((EditPart)oldTarget).size() == 1) {
            Rectangle bounds = oldTarget.getPrimaryShape().getBounds();
            Point location = new Point(bounds.x, 10);
            int dy = location.y - bounds.y;
            SetLocationCommand boundsCommand = new SetLocationCommand(oldTarget.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)oldTarget.getNotationView()), location);
            command = command.chain((Command)new ICommandProxy((ICommand)boundsCommand));
            command = LifelineMessageCreateHelper.moveCascadeLifeline(oldTarget, command, dy);
        }
        command = LifelineMessageCreateHelper.moveLifelineDown(command, newTarget, request.getLocation().getCopy());
        return command;
    }

    @Deprecated
    public static Command moveLifelineDown(Command command, OLDLifelineEditPart part, Point sourcePointCopy) {
        throw new IllegalStateException();
    }

    @Deprecated
    public static Command moveCascadeLifeline(LifelineEditPart part, Command command, int dy) {
        return command;
    }

    @Deprecated
    public static Command moveCascadeLifelineRecursive(LifelineEditPart part, Command command, int dy) {
        List list = part.getSourceConnections();
        if (list != null && list.size() > 0) {
            for (Object l : list) {
                boolean cfr_ignored_0 = l instanceof MessageCreateEditPart;
            }
        }
        return command;
    }

    public static boolean canMoveLifelineVertical(LifelineEditPart child, Rectangle newBounds) {
        int halfHeight = child.getPrimaryShape().getFigureLifelineNameContainerFigure().getBounds().height / 2;
        List list = child.getSourceConnections();
        if (list != null && list.size() > 0) {
            for (Object l : list) {
                if (!(l instanceof MessageCreateEditPart) || !(((MessageCreateEditPart)l).getTarget() instanceof LifelineEditPart)) continue;
                LifelineEditPart lowPart = (LifelineEditPart)((MessageCreateEditPart)l).getTarget();
                Rectangle outBounds = lowPart.getFigure().getBounds();
                if (outBounds.y - newBounds.y >= halfHeight) continue;
                return false;
            }
        }
        if ((list = child.getTargetConnections()) != null && list.size() > 0) {
            for (Object l : list) {
                if (!(l instanceof MessageCreateEditPart) || !(((MessageCreateEditPart)l).getSource() instanceof LifelineEditPart)) continue;
                LifelineEditPart highPart = (LifelineEditPart)((MessageCreateEditPart)l).getSource();
                Rectangle inBounds = highPart.getFigure().getBounds();
                if (newBounds.y - inBounds.y < halfHeight) {
                    return false;
                }
                if (newBounds.y <= inBounds.getBottom().y - halfHeight) continue;
                return false;
            }
        }
        return true;
    }

    public static class ComponentEditPolicyEx
    extends ComponentEditPolicy {
        protected Command createDeleteViewCommand(GroupRequest deleteRequest) {
            Command command = super.createDeleteViewCommand(deleteRequest);
            if (command != null && this.getHost() instanceof LifelineEditPart) {
                command = LifelineMessageCreateHelper.restoreLifelineOnDelete(command, (LifelineEditPart)this.getHost());
            }
            return command;
        }
    }
}

