/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.architecture.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ChildCreationExtenderManager;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.papyrus.infra.core.architecture.provider.ArchitectureDescriptionItemProvider;
import org.eclipse.papyrus.infra.core.architecture.provider.ArchitectureDescriptionLanguageItemProvider;
import org.eclipse.papyrus.infra.core.architecture.provider.ArchitectureDescriptionPreferencesItemProvider;
import org.eclipse.papyrus.infra.core.architecture.provider.ArchitectureDomainItemProvider;
import org.eclipse.papyrus.infra.core.architecture.provider.ArchitectureEditPlugin;
import org.eclipse.papyrus.infra.core.architecture.provider.ArchitectureFrameworkItemProvider;
import org.eclipse.papyrus.infra.core.architecture.provider.ArchitectureViewpointItemProvider;
import org.eclipse.papyrus.infra.core.architecture.provider.ConcernItemProvider;
import org.eclipse.papyrus.infra.core.architecture.provider.StakeholderItemProvider;
import org.eclipse.papyrus.infra.core.architecture.util.ArchitectureAdapterFactory;

public class ArchitectureItemProviderAdapterFactory
extends ArchitectureAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable,
IChildCreationExtender {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected ChildCreationExtenderManager childCreationExtenderManager = new ChildCreationExtenderManager((ResourceLocator)ArchitectureEditPlugin.INSTANCE, "http://www.eclipse.org/papyrus/infra/core/architecture");
    protected Collection<Object> supportedTypes = new ArrayList<Object>();
    protected ArchitectureDomainItemProvider architectureDomainItemProvider;
    protected ArchitectureDescriptionLanguageItemProvider architectureDescriptionLanguageItemProvider;
    protected StakeholderItemProvider stakeholderItemProvider;
    protected ConcernItemProvider concernItemProvider;
    protected ArchitectureViewpointItemProvider architectureViewpointItemProvider;
    protected ArchitectureFrameworkItemProvider architectureFrameworkItemProvider;
    protected ArchitectureDescriptionItemProvider architectureDescriptionItemProvider;
    protected ArchitectureDescriptionPreferencesItemProvider architectureDescriptionPreferencesItemProvider;

    public ArchitectureItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    public Adapter createArchitectureDomainAdapter() {
        if (this.architectureDomainItemProvider == null) {
            this.architectureDomainItemProvider = new ArchitectureDomainItemProvider((AdapterFactory)this);
        }
        return this.architectureDomainItemProvider;
    }

    public Adapter createArchitectureDescriptionLanguageAdapter() {
        if (this.architectureDescriptionLanguageItemProvider == null) {
            this.architectureDescriptionLanguageItemProvider = new ArchitectureDescriptionLanguageItemProvider((AdapterFactory)this);
        }
        return this.architectureDescriptionLanguageItemProvider;
    }

    public Adapter createStakeholderAdapter() {
        if (this.stakeholderItemProvider == null) {
            this.stakeholderItemProvider = new StakeholderItemProvider((AdapterFactory)this);
        }
        return this.stakeholderItemProvider;
    }

    public Adapter createConcernAdapter() {
        if (this.concernItemProvider == null) {
            this.concernItemProvider = new ConcernItemProvider((AdapterFactory)this);
        }
        return this.concernItemProvider;
    }

    public Adapter createArchitectureViewpointAdapter() {
        if (this.architectureViewpointItemProvider == null) {
            this.architectureViewpointItemProvider = new ArchitectureViewpointItemProvider((AdapterFactory)this);
        }
        return this.architectureViewpointItemProvider;
    }

    public Adapter createArchitectureFrameworkAdapter() {
        if (this.architectureFrameworkItemProvider == null) {
            this.architectureFrameworkItemProvider = new ArchitectureFrameworkItemProvider((AdapterFactory)this);
        }
        return this.architectureFrameworkItemProvider;
    }

    public Adapter createArchitectureDescriptionAdapter() {
        if (this.architectureDescriptionItemProvider == null) {
            this.architectureDescriptionItemProvider = new ArchitectureDescriptionItemProvider((AdapterFactory)this);
        }
        return this.architectureDescriptionItemProvider;
    }

    public Adapter createArchitectureDescriptionPreferencesAdapter() {
        if (this.architectureDescriptionPreferencesItemProvider == null) {
            this.architectureDescriptionPreferencesItemProvider = new ArchitectureDescriptionPreferencesItemProvider((AdapterFactory)this);
        }
        return this.architectureDescriptionPreferencesItemProvider;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    public List<IChildCreationExtender> getChildCreationExtenders() {
        return this.childCreationExtenderManager.getChildCreationExtenders();
    }

    public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
        return this.childCreationExtenderManager.getNewChildDescriptors(object, editingDomain);
    }

    public ResourceLocator getResourceLocator() {
        return this.childCreationExtenderManager;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        if (this.architectureDomainItemProvider != null) {
            this.architectureDomainItemProvider.dispose();
        }
        if (this.architectureDescriptionLanguageItemProvider != null) {
            this.architectureDescriptionLanguageItemProvider.dispose();
        }
        if (this.stakeholderItemProvider != null) {
            this.stakeholderItemProvider.dispose();
        }
        if (this.concernItemProvider != null) {
            this.concernItemProvider.dispose();
        }
        if (this.architectureViewpointItemProvider != null) {
            this.architectureViewpointItemProvider.dispose();
        }
        if (this.architectureFrameworkItemProvider != null) {
            this.architectureFrameworkItemProvider.dispose();
        }
        if (this.architectureDescriptionItemProvider != null) {
            this.architectureDescriptionItemProvider.dispose();
        }
        if (this.architectureDescriptionPreferencesItemProvider != null) {
            this.architectureDescriptionPreferencesItemProvider.dispose();
        }
    }
}

