/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.jpa.annotate.mapping.ColumnAttributes;
import org.eclipse.jpt.jpa.annotate.mapping.EntityRefPropertyElem;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.ui.JptJpaUiImages;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.AssociationAnnotationWizard;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.JptJpaUiMakePersistentMessages;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.SelectColumnDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddJoinColumnDlg
extends Dialog {
    private Table table;
    private Table refTable;
    private Text colNameText;
    private Button colNameBrowseBtn;
    private Button uniqueChkbox;
    private Combo nullableCombo;
    private Combo insertableCombo;
    private Combo updatableCombo;
    private Text refColNameText;
    private Button refColNameBrowseBtn;
    private ColumnAttributes colAttrs;
    private ResourceManager resourceManager;
    private EntityRefPropertyElem entityRefElem;

    public AddJoinColumnDlg(Shell shell, ResourceManager resourceManager, Table table, Table refTable, EntityRefPropertyElem entityRefElem) {
        super(shell);
        this.table = table;
        this.refTable = refTable;
        this.resourceManager = resourceManager;
        this.entityRefElem = entityRefElem;
        this.colAttrs = new ColumnAttributes();
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(JptJpaUiMakePersistentMessages.ADD_JOIN_COLUMN_DLG_TITLE);
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout(3, false);
        composite.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.widthHint = 300;
        composite.setLayoutData((Object)gd);
        AssociationAnnotationWizard.createLabel(composite, 1, JptJpaUiMakePersistentMessages.COLUMN_NAME, -1);
        this.colNameText = AssociationAnnotationWizard.createText(composite, true, 1, 2048);
        this.colNameBrowseBtn = AssociationAnnotationWizard.createImageButton(composite, this.resourceManager.createImage(JptJpaUiImages.LIST_OF_VALUES), 1, 0, JptJpaUiMakePersistentMessages.BROWSE);
        AssociationAnnotationWizard.createLabel(composite, 1, JptJpaUiMakePersistentMessages.UNIQUE, -1);
        this.uniqueChkbox = AssociationAnnotationWizard.createButton(composite, 2, null, -1, 32);
        String[] booleanVals = new String[]{"true", "false"};
        AssociationAnnotationWizard.createLabel(composite, 1, JptJpaUiMakePersistentMessages.NULLABLE, -1);
        this.nullableCombo = AssociationAnnotationWizard.createCombo(composite, true, 1, 2060, -1);
        this.nullableCombo.setItems(booleanVals);
        new Label(composite, 0);
        AssociationAnnotationWizard.createLabel(composite, 1, JptJpaUiMakePersistentMessages.INSERTABLE, -1);
        this.insertableCombo = AssociationAnnotationWizard.createCombo(composite, true, 1, 2060, -1);
        this.insertableCombo.setItems(booleanVals);
        new Label(composite, 0);
        AssociationAnnotationWizard.createLabel(composite, 1, JptJpaUiMakePersistentMessages.UPDATABLE, -1);
        this.updatableCombo = AssociationAnnotationWizard.createCombo(composite, true, 1, 2060, -1);
        this.updatableCombo.setItems(booleanVals);
        new Label(composite, 0);
        AssociationAnnotationWizard.createLabel(composite, 1, JptJpaUiMakePersistentMessages.REF_COLUMN_NAME, -1);
        this.refColNameText = AssociationAnnotationWizard.createText(composite, true, 1, 2048);
        this.refColNameBrowseBtn = AssociationAnnotationWizard.createImageButton(composite, this.resourceManager.createImage(JptJpaUiImages.LIST_OF_VALUES), 1, 0, JptJpaUiMakePersistentMessages.BROWSE);
        this.addListeners();
        return composite;
    }

    protected boolean isResizable() {
        return true;
    }

    private void addListeners() {
        this.colNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddJoinColumnDlg.this.colAttrs.setName(AddJoinColumnDlg.this.colNameText.getText());
            }
        });
        this.colNameBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectColumnDialog dlg = new SelectColumnDialog(Display.getDefault().getActiveShell(), AddJoinColumnDlg.this.table, AddJoinColumnDlg.this.entityRefElem.getPropertyName());
                if (dlg.open() == 0) {
                    AddJoinColumnDlg.this.colNameText.setText(dlg.getSelectedColumn());
                }
            }
        });
        this.uniqueChkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddJoinColumnDlg.this.colAttrs.setUnique(AddJoinColumnDlg.this.uniqueChkbox.getSelection());
            }
        });
        this.nullableCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddJoinColumnDlg.this.colAttrs.setNullable(AddJoinColumnDlg.this.nullableCombo.getSelectionIndex() == 0);
            }
        });
        this.insertableCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddJoinColumnDlg.this.colAttrs.setInsertable(AddJoinColumnDlg.this.insertableCombo.getSelectionIndex() == 0);
            }
        });
        this.updatableCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddJoinColumnDlg.this.colAttrs.setUpdatable(AddJoinColumnDlg.this.updatableCombo.getSelectionIndex() == 0);
            }
        });
        this.refColNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddJoinColumnDlg.this.colAttrs.setReferencedColumnName(AddJoinColumnDlg.this.refColNameText.getText());
            }
        });
        this.refColNameBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectColumnDialog dlg = new SelectColumnDialog(Display.getDefault().getActiveShell(), AddJoinColumnDlg.this.refTable, AddJoinColumnDlg.this.entityRefElem.getPropertyName());
                if (dlg.open() == 0) {
                    AddJoinColumnDlg.this.refColNameText.setText(dlg.getSelectedColumn());
                }
            }
        });
    }

    public ColumnAttributes getNewJoinColumn() {
        return this.colAttrs;
    }
}

