/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.chess.features;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.examples.chess.Messages;
import org.eclipse.graphiti.examples.mm.chess.Board;
import org.eclipse.graphiti.examples.mm.chess.ChessFactory;
import org.eclipse.graphiti.examples.mm.chess.Colors;
import org.eclipse.graphiti.examples.mm.chess.Files;
import org.eclipse.graphiti.examples.mm.chess.Piece;
import org.eclipse.graphiti.examples.mm.chess.Ranks;
import org.eclipse.graphiti.examples.mm.chess.Square;
import org.eclipse.graphiti.examples.mm.chess.Types;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.impl.AbstractCreateFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;

public class CreateAllInitialChessPiecesFeature
extends AbstractCreateFeature {
    public CreateAllInitialChessPiecesFeature(IFeatureProvider fp) {
        super(fp, Messages.CreateAllInitialChessPiecesFeature_name, Messages.CreateAllInitialChessPiecesFeature_description);
    }

    public boolean canCreate(ICreateContext context) {
        Board board = this.getBoard(context);
        return board != null && board.getPieces().size() == 0;
    }

    public Object[] create(ICreateContext context) {
        ArrayList<Piece> addedPieces = new ArrayList<Piece>(32);
        Board board = this.getBoard(context);
        for (Colors color : Colors.VALUES) {
            if (Colors.NONE.equals((Object)color)) continue;
            for (Types type : Types.VALUES) {
                if (Types.NONE.equals((Object)type)) continue;
                ArrayList<Square> relevantSquares = new ArrayList<Square>();
                Ranks rank = Types.ROOK.equals((Object)type) || Types.KNIGHT.equals((Object)type) || Types.BISHOP.equals((Object)type) || Types.QUEEN.equals((Object)type) || Types.KING.equals((Object)type) ? (Colors.DARK.equals((Object)color) ? Ranks.EIGHT : Ranks.ONE) : (Colors.DARK.equals((Object)color) ? Ranks.SEVEN : Ranks.TWO);
                if (Types.ROOK.equals((Object)type)) {
                    relevantSquares.add(board.getSquare(rank, Files.A));
                    relevantSquares.add(board.getSquare(rank, Files.H));
                } else if (Types.KNIGHT.equals((Object)type)) {
                    relevantSquares.add(board.getSquare(rank, Files.B));
                    relevantSquares.add(board.getSquare(rank, Files.G));
                } else if (Types.BISHOP.equals((Object)type)) {
                    relevantSquares.add(board.getSquare(rank, Files.C));
                    relevantSquares.add(board.getSquare(rank, Files.F));
                } else if (Types.QUEEN.equals((Object)type)) {
                    relevantSquares.add(board.getSquare(rank, Files.D));
                } else if (Types.KING.equals((Object)type)) {
                    relevantSquares.add(board.getSquare(rank, Files.E));
                } else if (Types.PAWN.equals((Object)type)) {
                    for (Files file : Files.VALUES) {
                        if (Files.NONE.equals((Object)file)) continue;
                        relevantSquares.add(board.getSquare(rank, file));
                    }
                }
                for (Square square : relevantSquares) {
                    Piece piece = ChessFactory.eINSTANCE.createPiece();
                    board.eResource().getContents().add((Object)piece);
                    piece.setBoard(board);
                    piece.setOwner(color);
                    piece.setType(type);
                    piece.setSquare(square);
                    AddContext addContext = new AddContext((IAreaContext)context, (Object)piece);
                    List pictogramElements = Graphiti.getLinkService().getPictogramElements(this.getDiagram(), (EObject)square);
                    if (pictogramElements.size() <= 0) {
                        throw new IllegalStateException();
                    }
                    addContext.setTargetContainer((ContainerShape)pictogramElements.get(0));
                    this.addGraphicalRepresentation((IAreaContext)addContext, piece);
                    addedPieces.add(piece);
                }
            }
        }
        return addedPieces.toArray(new Piece[addedPieces.size()]);
    }

    private Board getBoard(ICreateContext context) {
        ContainerShape targetContainer = context.getTargetContainer();
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)targetContainer);
        if (bo instanceof Board) {
            return (Board)bo;
        }
        if (bo instanceof Square) {
            return ((Square)bo).getBoard();
        }
        return null;
    }
}

