/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.id;

import java.io.IOException;
import java.io.ObjectStreamException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDExternal;
import org.eclipse.emf.cdo.common.id.CDOIDString;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.spi.common.id.AbstractCDOID;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.ref.Interner;

public final class CDOIDExternalImpl
extends AbstractCDOID
implements CDOIDExternal,
CDOIDString {
    private static final long serialVersionUID = 1L;
    private static final boolean checkFragment = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.common.id.CDOIDExternal.checkFragment");
    private static final StringInterner INTERNER = new StringInterner();
    private final String uri;

    private CDOIDExternalImpl(String uri) {
        CDOIDExternalImpl.checkURI(uri);
        this.uri = uri;
    }

    private CDOIDExternalImpl() {
        this.uri = null;
    }

    public void write(CDODataOutput out) throws IOException {
        out.writeString(this.uri);
    }

    public String toURIFragment() {
        return this.uri;
    }

    public String getURI() {
        return this.uri;
    }

    public String getStringValue() {
        return this.uri;
    }

    public CDOID.Type getType() {
        return CDOID.Type.EXTERNAL_OBJECT;
    }

    public boolean isExternal() {
        return true;
    }

    public boolean isObject() {
        return true;
    }

    public boolean isTemporary() {
        return false;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public String toString() {
        return "oid:" + this.uri;
    }

    protected int doCompareTo(CDOID o) throws ClassCastException {
        return this.uri.compareTo(((CDOIDExternalImpl)o).uri);
    }

    private Object readResolve() throws ObjectStreamException {
        return CDOIDExternalImpl.create(this.uri);
    }

    private static int getHashCode(String uri) {
        return uri.hashCode();
    }

    static void checkURI(String uri) {
        CheckUtil.checkArg((Object)uri, (String)"Null not allowed");
        if (checkFragment) {
            CheckUtil.checkArg((!uri.endsWith("#NNULL") ? 1 : 0) != 0, (String)"Fragment 'NNULL' not allowed");
        }
    }

    public static CDOIDExternalImpl create(String uri) {
        return INTERNER.intern(uri);
    }

    public static CDOIDExternalImpl create(CDODataInput in) throws IOException {
        String uri = in.readString();
        return CDOIDExternalImpl.create(uri);
    }

    /* synthetic */ CDOIDExternalImpl(String string, CDOIDExternalImpl cDOIDExternalImpl) {
        this(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StringInterner
    extends Interner<CDOIDExternalImpl> {
        private StringInterner() {
        }

        public synchronized CDOIDExternalImpl intern(String uri) {
            int hashCode = CDOIDExternalImpl.getHashCode(uri);
            Interner.Entry entry = this.getEntry(hashCode);
            while (entry != null) {
                CDOIDExternalImpl id = (CDOIDExternalImpl)entry.get();
                if (id != null && id.uri.equals(uri)) {
                    return id;
                }
                entry = entry.getNextEntry();
            }
            CDOIDExternalImpl id = new CDOIDExternalImpl(uri, null);
            this.addEntry(this.createEntry(id, hashCode));
            return id;
        }

        protected int hashCode(CDOIDExternalImpl id) {
            return CDOIDExternalImpl.getHashCode(id.uri);
        }
    }
}

