/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.wb.core.model.JavaInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlaceholderUtils {
    private static String KEY_EXCEPTIONS = String.valueOf(PlaceholderUtils.class.getName()) + ".exceptions";
    private static String KEY_PLACEHOLDER = String.valueOf(PlaceholderUtils.class.getName()) + ".placeholder";

    private PlaceholderUtils() {
    }

    public static boolean isPlaceholder(JavaInfo javaInfo) {
        ASTNode node = javaInfo.getCreationSupport().getNode();
        return PlaceholderUtils.isPlaceholder(node);
    }

    public static List<Throwable> getExceptions(JavaInfo javaInfo) {
        ASTNode node = javaInfo.getCreationSupport().getNode();
        return PlaceholderUtils.getExceptions(node);
    }

    public static List<Throwable> getExceptions(ASTNode node) {
        ImmutableList exceptions = PlaceholderUtils.getExceptions0(node);
        return exceptions != null ? exceptions : ImmutableList.of();
    }

    public static void clear(ASTNode node) {
        node.setProperty(KEY_EXCEPTIONS, null);
        node.setProperty(KEY_PLACEHOLDER, null);
    }

    public static void addException(ASTNode node, Throwable e) {
        ArrayList exceptions = PlaceholderUtils.getExceptions0(node);
        if (exceptions == null) {
            exceptions = Lists.newArrayList();
            node.setProperty(KEY_EXCEPTIONS, (Object)exceptions);
        }
        exceptions.add(e);
    }

    private static List<Throwable> getExceptions0(ASTNode node) {
        return (List)node.getProperty(KEY_EXCEPTIONS);
    }

    public static boolean isPlaceholder(ASTNode node) {
        return node != null && node.getProperty(KEY_PLACEHOLDER) == Boolean.TRUE;
    }

    public static void markPlaceholder(ASTNode node) {
        node.setProperty(KEY_PLACEHOLDER, (Object)Boolean.TRUE);
    }
}

