/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlActionCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlConditionCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlFsmStateCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenAction;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenCondition;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenFsm;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenFsmState;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenRuntimeData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternStateProvider;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TmfXmlPatternEventHandler {
    public static final String SAVE_STORED_FIELDS_STRING = "saveStoredFields";
    public static final String CLEAR_STORED_FIELDS_STRING = "clearStoredFields";
    private final XmlPatternStateProvider fParent;
    private final List<DataDrivenFsm> fInitialFsm = new ArrayList<DataDrivenFsm>();
    private final Map<String, DataDrivenCondition> fTestMap;
    private final Map<String, DataDrivenAction> fActionMap;
    private final Map<String, DataDrivenFsm> fFsmMap = new HashMap<String, DataDrivenFsm>();
    private final List<DataDrivenFsm> fActiveFsmList = new ArrayList<DataDrivenFsm>();

    public TmfXmlPatternEventHandler(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer parent) {
        this.fParent = (XmlPatternStateProvider)parent;
        HashMap<String, DataDrivenCondition> testMap = new HashMap<String, DataDrivenCondition>();
        NodeList nodesTest = node.getElementsByTagName("test");
        int i = 0;
        while (i < nodesTest.getLength()) {
            Element element = (Element)nodesTest.item(i);
            if (element == null) {
                throw new IllegalArgumentException();
            }
            String testId = modelFactory.createTransitionValidator(element, this.fParent);
            TmfXmlConditionCu test = Objects.requireNonNull(this.fParent.getAnalysisCompilationData().getTest(testId));
            testMap.put(testId, test.generate());
            ++i;
        }
        this.fTestMap = Collections.unmodifiableMap(testMap);
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull ImmutableMap.Builder builder = ImmutableMap.builder();
        NodeList nodesAction = node.getElementsByTagName("action");
        int i2 = 0;
        while (i2 < nodesAction.getLength()) {
            Element element = (Element)nodesAction.item(i2);
            if (element == null) {
                throw new IllegalArgumentException();
            }
            String actionId = modelFactory.createAction(element, this.fParent);
            TmfXmlActionCu action = Objects.requireNonNull(this.fParent.getAnalysisCompilationData().getAction(actionId));
            builder.put((Object)actionId, (Object)action.generate());
            ++i2;
        }
        this.fActionMap = builder.build();
        NodeList nodesFsm = node.getElementsByTagName("fsm");
        int i3 = 0;
        while (i3 < nodesFsm.getLength()) {
            Element element = (Element)nodesFsm.item(i3);
            if (element == null) {
                throw new IllegalArgumentException();
            }
            String fsmId = Objects.requireNonNull(TmfXmlFsmStateCu.compileFsm(this.fParent.getAnalysisCompilationData(), element), "The FSM did not compile properly");
            TmfXmlFsmStateCu fsmCu = Objects.requireNonNull(this.fParent.getAnalysisCompilationData().getFsm(fsmId));
            DataDrivenFsmState fsm = fsmCu.generate();
            if (!(fsm instanceof DataDrivenFsm)) {
                throw new NullPointerException("fsm not of the right type");
            }
            this.fFsmMap.put(fsmId, (DataDrivenFsm)fsm);
            ++i3;
        }
        String initialFsm = node.getAttribute("initial");
        if (!initialFsm.isEmpty()) {
            String[] stringArray = initialFsm.split(":");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String initial = stringArray[n2];
                DataDrivenFsm fsm = this.fFsmMap.get(initial);
                if (fsm != null) {
                    this.fInitialFsm.add(fsm);
                }
                ++n2;
            }
        }
    }

    public void startScenario(List<DataDrivenFsm> fsms, ITmfEvent event, boolean force, DataDrivenRuntimeData executionData) {
        for (DataDrivenFsm fsm : fsms) {
            if (!this.fActiveFsmList.contains(fsm)) {
                this.fActiveFsmList.add(fsm);
            }
            fsm.createScenario(event, force, executionData, this.fParent);
        }
    }

    public Map<String, DataDrivenCondition> getTestMap() {
        return this.fTestMap;
    }

    public Map<String, DataDrivenAction> getActionMap() {
        return this.fActionMap;
    }

    public void handleEvent(ITmfEvent event) {
        List<DataDrivenFsm> activeFsmList = this.fActiveFsmList;
        Map<String, DataDrivenFsm> fsmMap = this.fFsmMap;
        if (activeFsmList.isEmpty()) {
            List<DataDrivenFsm> fsms = this.fInitialFsm;
            if (this.fInitialFsm.isEmpty()) {
                fsms = new ArrayList<DataDrivenFsm>();
                for (DataDrivenFsm fsm : fsmMap.values()) {
                    fsms.add(fsm);
                }
            }
            if (!fsms.isEmpty()) {
                this.startScenario(fsms, event, true, this.fParent.getExecutionData());
            }
        } else {
            ArrayList<DataDrivenFsm> fsmToStart = new ArrayList<DataDrivenFsm>();
            for (DataDrivenFsm fsm : fsmMap.values()) {
                if (!fsm.isNewScenarioAllowed(this.fParent.getExecutionData().getRuntimeForFsm(fsm))) continue;
                fsmToStart.add(fsm);
            }
            if (!fsmToStart.isEmpty()) {
                this.startScenario(fsmToStart, event, false, this.fParent.getExecutionData());
            }
        }
        for (DataDrivenFsm fsm : activeFsmList) {
            fsm.handleEvent(event, this.fParent.getExecutionData(), this.fParent);
        }
    }

    public void dispose() {
        for (DataDrivenFsm fsm : this.fActiveFsmList) {
            fsm.dispose(this.fParent.getExecutionData());
        }
    }
}

