package org.eclipse.epp.internal.logging.aeri.ide.processors;

/**
 * Copyright (c) 2016 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.epp.logging.aeri.core.IReport;
import org.eclipse.epp.logging.aeri.core.IReportProcessor;
import org.eclipse.epp.logging.aeri.core.util.Reports;

public class AnonymizeMessagesProcessor implements IReportProcessor {

    @Override
    public boolean canContribute(IStatus status, IEclipseContext context) {
        return true;
    }

    @Override
    public boolean wantsToContribute(IStatus status, IEclipseContext context) {
        return false;
    }

    @Override
    public void process(IReport report, IStatus status, IEclipseContext context) {
        Reports.anonymizeMessages(report);
    }

}
