/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.iterator;

import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseDependentConnectionIteration<T>
extends AbstractCloseableIteration<T> {
    private static final Logger logger = LoggerFactory.getLogger(CloseDependentConnectionIteration.class);
    protected final CloseableIteration<T> inner;
    protected final RepositoryConnection dependentConn;

    public CloseDependentConnectionIteration(CloseableIteration<T> inner, RepositoryConnection dependentConn) {
        this.inner = inner;
        this.dependentConn = dependentConn;
    }

    @Override
    public boolean hasNext() throws QueryEvaluationException {
        try {
            if (Thread.interrupted()) {
                Thread.currentThread().interrupt();
                this.close();
                return false;
            }
            boolean res = this.inner.hasNext();
            if (!res) {
                this.close();
            }
            return res;
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
    }

    @Override
    public T next() throws QueryEvaluationException {
        try {
            return (T)this.inner.next();
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
    }

    @Override
    public void remove() throws QueryEvaluationException {
        try {
            this.inner.remove();
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        try {
            this.inner.close();
        }
        finally {
            this.dependentConn.close();
        }
    }
}

