/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated;

import org.eclipse.rdf4j.federated.EndpointManager;
import org.eclipse.rdf4j.federated.FedX;
import org.eclipse.rdf4j.federated.FedXConfig;
import org.eclipse.rdf4j.federated.FederationManager;
import org.eclipse.rdf4j.federated.QueryManager;
import org.eclipse.rdf4j.federated.cache.SourceSelectionCache;
import org.eclipse.rdf4j.federated.cache.SourceSelectionCacheFactory;
import org.eclipse.rdf4j.federated.cache.SourceSelectionMemoryCache;
import org.eclipse.rdf4j.federated.evaluation.DelegateFederatedServiceResolver;
import org.eclipse.rdf4j.federated.evaluation.FederationEvalStrategy;
import org.eclipse.rdf4j.federated.monitoring.Monitoring;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;

public class FederationContext {
    private final FederationManager manager;
    private final EndpointManager endpointManager;
    private final Monitoring monitoring;
    private final QueryManager queryManager;
    private final DelegateFederatedServiceResolver serviceResolver;
    private final FedXConfig fedXConfig;
    private final SourceSelectionCache sourceSelectionCache;

    public FederationContext(FederationManager manager, EndpointManager endpointManager, QueryManager queryManager, DelegateFederatedServiceResolver federatedServiceResolver, Monitoring monitoring, FedXConfig fedXConfig) {
        this.manager = manager;
        this.endpointManager = endpointManager;
        this.queryManager = queryManager;
        this.serviceResolver = federatedServiceResolver;
        this.monitoring = monitoring;
        this.fedXConfig = fedXConfig;
        this.sourceSelectionCache = this.createSourceSelectionCache();
    }

    public FedX getFederation() {
        return this.manager.getFederation();
    }

    public FederationManager getManager() {
        return this.manager;
    }

    public QueryManager getQueryManager() {
        return this.queryManager;
    }

    public EndpointManager getEndpointManager() {
        return this.endpointManager;
    }

    public Monitoring getMonitoringService() {
        return this.monitoring;
    }

    public DelegateFederatedServiceResolver getFederatedServiceResolver() {
        return this.serviceResolver;
    }

    public FedXConfig getConfig() {
        return this.fedXConfig;
    }

    public SourceSelectionCache getSourceSelectionCache() {
        return this.sourceSelectionCache;
    }

    public FederationEvalStrategy createStrategy(Dataset dataset) {
        TripleSource tripleSource = null;
        EvaluationStatistics evaluationStatistics = null;
        return this.manager.getFederationEvaluationStrategyFactory().createEvaluationStrategy(dataset, tripleSource, evaluationStatistics);
    }

    private SourceSelectionCache createSourceSelectionCache() {
        SourceSelectionCacheFactory factory = this.getConfig().getSourceSelectionCacheFactory();
        if (factory != null) {
            return factory.create();
        }
        String cacheSpec = this.getConfig().getSourceSelectionCacheSpec();
        return new SourceSelectionMemoryCache(cacheSpec);
    }
}

