/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.jsonld;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import no.hasmac.jsonld.JsonLdError;
import no.hasmac.jsonld.document.Document;
import no.hasmac.jsonld.loader.DocumentLoader;
import no.hasmac.jsonld.loader.DocumentLoaderOptions;
import no.hasmac.jsonld.loader.SchemeRouter;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingDocumentLoader
implements DocumentLoader {
    private static final DocumentLoader defaultLoader = SchemeRouter.defaultInstance();
    private static final Logger logger = LoggerFactory.getLogger(CachingDocumentLoader.class);
    private static final LoadingCache<URI, Document> cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).concurrencyLevel(8).build((CacheLoader)new CacheLoader<URI, Document>(){

        public Document load(URI url) throws Exception {
            return defaultLoader.loadDocument(url, new DocumentLoaderOptions());
        }
    });
    private final boolean secureMode;
    private final Set<String> whitelist;
    private final boolean documentLoaderCache;

    public CachingDocumentLoader(boolean secureMode, Set<String> whitelist, boolean documentLoaderCache) {
        this.secureMode = secureMode;
        this.whitelist = whitelist;
        this.documentLoaderCache = documentLoaderCache;
    }

    public Document loadDocument(URI uri, DocumentLoaderOptions options) {
        try {
            if (!this.secureMode || this.whitelist.contains(uri.toString())) {
                if (this.documentLoaderCache) {
                    try {
                        return (Document)cache.get((Object)uri);
                    }
                    catch (ExecutionException e) {
                        if (e.getCause() != null) {
                            throw new RDFParseException("Could not load document from " + uri, e.getCause());
                        }
                        throw new RDFParseException("Could not load document from " + uri, (Throwable)e);
                    }
                }
                try {
                    return defaultLoader.loadDocument(uri, options);
                }
                catch (JsonLdError e) {
                    throw new RDFParseException("Could not load document from " + uri, (Throwable)e);
                }
            }
            throw new RDFParseException("Could not load document from " + uri + " because it is not whitelisted. See: JSONLDSettings.WHITELIST and JSONLDSettings.SECURE_MODE");
        }
        catch (RDFParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

