/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin;

import com.google.common.base.Function;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.AFN;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SP;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.Avg;
import org.eclipse.rdf4j.query.algebra.BNodeGenerator;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.Bound;
import org.eclipse.rdf4j.query.algebra.Clear;
import org.eclipse.rdf4j.query.algebra.Coalesce;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.Count;
import org.eclipse.rdf4j.query.algebra.Create;
import org.eclipse.rdf4j.query.algebra.Datatype;
import org.eclipse.rdf4j.query.algebra.DeleteData;
import org.eclipse.rdf4j.query.algebra.Difference;
import org.eclipse.rdf4j.query.algebra.Distinct;
import org.eclipse.rdf4j.query.algebra.Exists;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.FunctionCall;
import org.eclipse.rdf4j.query.algebra.Group;
import org.eclipse.rdf4j.query.algebra.GroupConcat;
import org.eclipse.rdf4j.query.algebra.IRIFunction;
import org.eclipse.rdf4j.query.algebra.If;
import org.eclipse.rdf4j.query.algebra.InsertData;
import org.eclipse.rdf4j.query.algebra.IsBNode;
import org.eclipse.rdf4j.query.algebra.IsLiteral;
import org.eclipse.rdf4j.query.algebra.IsNumeric;
import org.eclipse.rdf4j.query.algebra.IsURI;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.Lang;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.Load;
import org.eclipse.rdf4j.query.algebra.LocalName;
import org.eclipse.rdf4j.query.algebra.MathExpr;
import org.eclipse.rdf4j.query.algebra.Max;
import org.eclipse.rdf4j.query.algebra.Min;
import org.eclipse.rdf4j.query.algebra.Modify;
import org.eclipse.rdf4j.query.algebra.MultiProjection;
import org.eclipse.rdf4j.query.algebra.Not;
import org.eclipse.rdf4j.query.algebra.Or;
import org.eclipse.rdf4j.query.algebra.Order;
import org.eclipse.rdf4j.query.algebra.OrderElem;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.Reduced;
import org.eclipse.rdf4j.query.algebra.Regex;
import org.eclipse.rdf4j.query.algebra.Sample;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.Slice;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Str;
import org.eclipse.rdf4j.query.algebra.Sum;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.UpdateExpr;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.QueryModelVisitorBase;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.query.parser.ParsedDescribeQuery;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.ParsedOperation;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.ParsedUpdate;
import org.eclipse.rdf4j.query.parser.sparql.SPARQLUpdateDataBlockParser;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;
import org.eclipse.rdf4j.spin.SpinWellKnownFunctions;
import org.eclipse.rdf4j.spin.SpinWellKnownVars;

public class SpinRenderer {
    private final ValueFactory valueFactory;
    private final Output output;
    private final Function<String, IRI> wellKnownVars;
    private final Function<String, IRI> wellKnownFunctions;

    public SpinRenderer() {
        this(Output.TEXT_AND_RDF);
    }

    public SpinRenderer(Output output) {
        this(output, (Function<String, IRI>)((Function)SpinWellKnownVars.INSTANCE::getURI), (Function<String, IRI>)((Function)SpinWellKnownFunctions.INSTANCE::getURI), SimpleValueFactory.getInstance());
    }

    public SpinRenderer(Output output, Function<String, IRI> wellKnownVarMapper, Function<String, IRI> wellKnownFuncMapper, ValueFactory vf) {
        this.output = output;
        this.wellKnownVars = wellKnownVarMapper;
        this.wellKnownFunctions = wellKnownFuncMapper;
        this.valueFactory = vf;
    }

    public void render(ParsedOperation operation, RDFHandler handler) throws RDFHandlerException {
        if (operation instanceof ParsedQuery) {
            this.render((ParsedQuery)operation, handler);
        } else if (operation instanceof ParsedUpdate) {
            this.render((ParsedUpdate)operation, handler);
        } else {
            throw new AssertionError((Object)("Unrecognised ParsedOperation: " + operation.getClass()));
        }
    }

    public void render(ParsedQuery query, RDFHandler handler) throws RDFHandlerException {
        if (query instanceof ParsedBooleanQuery) {
            this.render((ParsedBooleanQuery)query, handler);
        } else if (query instanceof ParsedTupleQuery) {
            this.render((ParsedTupleQuery)query, handler);
        } else if (query instanceof ParsedDescribeQuery) {
            this.render((ParsedDescribeQuery)query, handler);
        } else if (query instanceof ParsedGraphQuery) {
            this.render((ParsedGraphQuery)query, handler);
        } else {
            throw new AssertionError((Object)("Unrecognised ParsedQuery: " + query.getClass()));
        }
    }

    public void render(ParsedBooleanQuery query, RDFHandler handler) throws RDFHandlerException {
        handler.startRDF();
        BNode querySubj = this.valueFactory.createBNode();
        handler.handleStatement(this.valueFactory.createStatement(querySubj, RDF.TYPE, SP.ASK_CLASS));
        if (this.output.text) {
            handler.handleStatement(this.valueFactory.createStatement(querySubj, SP.TEXT_PROPERTY, this.valueFactory.createLiteral(query.getSourceString())));
        }
        if (this.output.rdf) {
            BNode whereBNode = this.valueFactory.createBNode();
            handler.handleStatement(this.valueFactory.createStatement(querySubj, SP.WHERE_PROPERTY, whereBNode));
            TupleExpr expr = query.getTupleExpr();
            AskVisitor visitor = new AskVisitor(handler, whereBNode, query.getDataset());
            expr.visit(visitor);
            visitor.end();
        }
        handler.endRDF();
    }

    public void render(ParsedTupleQuery query, RDFHandler handler) throws RDFHandlerException {
        handler.startRDF();
        BNode querySubj = this.valueFactory.createBNode();
        handler.handleStatement(this.valueFactory.createStatement(querySubj, RDF.TYPE, SP.SELECT_CLASS));
        if (this.output.text) {
            handler.handleStatement(this.valueFactory.createStatement(querySubj, SP.TEXT_PROPERTY, this.valueFactory.createLiteral(query.getSourceString())));
        }
        if (this.output.rdf) {
            TupleExpr expr = query.getTupleExpr();
            SpinVisitor visitor = new SpinVisitor(handler, null, querySubj, query.getDataset());
            expr.visit(visitor);
            visitor.end();
        }
        handler.endRDF();
    }

    public void render(ParsedDescribeQuery query, RDFHandler handler) throws RDFHandlerException {
        handler.startRDF();
        BNode querySubj = this.valueFactory.createBNode();
        handler.handleStatement(this.valueFactory.createStatement(querySubj, RDF.TYPE, SP.DESCRIBE_CLASS));
        if (this.output.text) {
            handler.handleStatement(this.valueFactory.createStatement(querySubj, SP.TEXT_PROPERTY, this.valueFactory.createLiteral(query.getSourceString())));
        }
        if (this.output.rdf) {
            TupleExpr expr = query.getTupleExpr();
            DescribeVisitor visitor = new DescribeVisitor(handler, querySubj, query.getDataset());
            expr.visit(visitor);
            visitor.end();
        }
        handler.endRDF();
    }

    public void render(ParsedGraphQuery query, RDFHandler handler) throws RDFHandlerException {
        handler.startRDF();
        BNode querySubj = this.valueFactory.createBNode();
        handler.handleStatement(this.valueFactory.createStatement(querySubj, RDF.TYPE, SP.CONSTRUCT_CLASS));
        if (this.output.text) {
            handler.handleStatement(this.valueFactory.createStatement(querySubj, SP.TEXT_PROPERTY, this.valueFactory.createLiteral(query.getSourceString())));
        }
        if (this.output.rdf) {
            TupleExpr expr = query.getTupleExpr();
            ConstructVisitor visitor = new ConstructVisitor(handler, querySubj, query.getDataset());
            expr.visit(visitor);
            visitor.end();
        }
        handler.endRDF();
    }

    public void render(ParsedUpdate update, RDFHandler handler) throws RDFHandlerException {
        handler.startRDF();
        for (Map.Entry<String, String> entry : update.getNamespaces().entrySet()) {
            handler.handleNamespace(entry.getKey(), entry.getValue());
        }
        String[] sourceStrings = update.getSourceString().split("\\s*;\\s*");
        List<UpdateExpr> updateExprs = update.getUpdateExprs();
        Map<UpdateExpr, Dataset> datasets = update.getDatasetMapping();
        for (int i = 0; i < updateExprs.size(); ++i) {
            IRI updateClass;
            UpdateExpr updateExpr = updateExprs.get(i);
            BNode updateSubj = this.valueFactory.createBNode();
            Dataset dataset = datasets.get(updateExpr);
            if (updateExpr instanceof Modify) {
                Modify modify = (Modify)updateExpr;
                updateClass = modify.getInsertExpr() == null && modify.getWhereExpr().equals(modify.getDeleteExpr()) ? SP.DELETE_WHERE_CLASS : SP.MODIFY_CLASS;
            } else if (updateExpr instanceof InsertData) {
                updateClass = SP.INSERT_DATA_CLASS;
            } else if (updateExpr instanceof DeleteData) {
                updateClass = SP.DELETE_DATA_CLASS;
            } else if (updateExpr instanceof Load) {
                updateClass = SP.LOAD_CLASS;
            } else if (updateExpr instanceof Clear) {
                updateClass = SP.CLEAR_CLASS;
            } else if (updateExpr instanceof Create) {
                updateClass = SP.CREATE_CLASS;
            } else {
                throw new RDFHandlerException("Unrecognised UpdateExpr: " + updateExpr.getClass());
            }
            handler.handleStatement(this.valueFactory.createStatement(updateSubj, RDF.TYPE, updateClass));
            if (this.output.text) {
                handler.handleStatement(this.valueFactory.createStatement(updateSubj, SP.TEXT_PROPERTY, this.valueFactory.createLiteral(sourceStrings[i])));
            }
            if (!this.output.rdf) continue;
            SpinVisitor visitor = new SpinVisitor(handler, null, updateSubj, dataset);
            updateExpr.visit(visitor);
            visitor.end();
        }
        handler.endRDF();
    }

    private static final class ListContext {
        Resource list;
        Resource subject;

        ListContext(Resource list, Resource subject) {
            this.list = list;
            this.subject = subject;
        }
    }

    private static final class ExtensionContext
    extends QueryModelVisitorBase<RuntimeException> {
        Extension extension;
        Map<String, ValueExpr> extensionExprs;

        private ExtensionContext() {
        }

        public ValueExpr getValueExpr(String name) {
            return this.extensionExprs.get(name);
        }

        @Override
        public void meet(Order node) {
            node.getArg().visit(this);
        }

        @Override
        public void meet(Extension node) {
            this.extension = node;
            List<ExtensionElem> elements = node.getElements();
            this.extensionExprs = new LinkedHashMap<String, ValueExpr>(elements.size());
            for (ExtensionElem elem : elements) {
                this.extensionExprs.put(elem.getName(), elem.getExpr());
            }
        }

        @Override
        protected void meetNode(QueryModelNode node) {
        }
    }

    private class SpinVisitor
    extends QueryModelVisitorBase<RDFHandlerException> {
        final RDFHandler handler;
        final Dataset dataset;
        final Map<String, BNode> varBNodes = new HashMap<String, BNode>();
        final Map<String, ListContext> namedGraphLists = new HashMap<String, ListContext>();
        ExtensionContext inlineBindings;
        Resource list;
        Resource subject;
        IRI predicate;
        ListContext namedGraphContext;
        boolean isMultiProjection;
        boolean isSubQuery;
        boolean hasGroup;

        SpinVisitor(RDFHandler handler, Resource list, Resource subject, Dataset dataset) {
            this.handler = handler;
            this.list = list;
            this.subject = subject;
            this.dataset = dataset;
        }

        private ExtensionContext meetExtension(TupleExpr expr) {
            ExtensionContext extVisitor = new ExtensionContext();
            expr.visit(extVisitor);
            ExtensionContext oldInlineBindings = this.inlineBindings;
            this.inlineBindings = extVisitor.extension != null ? extVisitor : null;
            return oldInlineBindings;
        }

        ListContext save() {
            return new ListContext(this.list, this.subject);
        }

        void update(ListContext ctx) {
            ctx.list = this.list;
            ctx.subject = this.subject;
        }

        void restore(ListContext ctx) {
            this.list = ctx.list;
            this.subject = ctx.subject;
        }

        ListContext newList(Resource res) {
            ListContext ctx = this.save();
            this.list = res;
            this.subject = null;
            return ctx;
        }

        void listEntry() throws RDFHandlerException {
            this.listEntry(null);
        }

        void listEntry(Value entry) throws RDFHandlerException {
            if (this.list == null) {
                this.list = SpinRenderer.this.valueFactory.createBNode();
            }
            if (this.subject != null) {
                this.nextListEntry(SpinRenderer.this.valueFactory.createBNode());
            }
            if (entry == null) {
                entry = SpinRenderer.this.valueFactory.createBNode();
            }
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.list, RDF.FIRST, entry));
            this.subject = entry instanceof Resource ? (Resource)entry : RDF.NIL;
        }

        void endList(ListContext ctx) throws RDFHandlerException {
            this.nextListEntry(RDF.NIL);
            if (ctx != null) {
                this.restore(ctx);
            }
        }

        private void nextListEntry(Resource nextEntry) throws RDFHandlerException {
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.list, RDF.REST, nextEntry));
            this.list = nextEntry;
            this.subject = null;
        }

        Resource getVar(String name) throws RDFHandlerException {
            Resource res;
            Resource resource = res = SpinRenderer.this.wellKnownVars != null ? (Resource)SpinRenderer.this.wellKnownVars.apply((Object)name) : null;
            if (res == null && (res = (Resource)this.varBNodes.get(name)) == null) {
                BNode bnode = SpinRenderer.this.valueFactory.createBNode(name);
                this.varBNodes.put(name, bnode);
                res = bnode;
            }
            return res;
        }

        ListContext getNamedGraph(Var context) throws RDFHandlerException {
            ListContext currentCtx;
            this.namedGraphContext = this.namedGraphLists.get(context.getName());
            if (this.namedGraphContext == null) {
                this.listEntry();
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, SP.NAMED_GRAPH_CLASS));
                this.predicate = SP.GRAPH_NAME_NODE_PROPERTY;
                context.visit(this);
                BNode elementsList = SpinRenderer.this.valueFactory.createBNode();
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.ELEMENTS_PROPERTY, elementsList));
                currentCtx = this.newList(elementsList);
                this.namedGraphContext = this.save();
                this.namedGraphLists.put(context.getName(), this.namedGraphContext);
            } else {
                currentCtx = this.save();
                this.restore(this.namedGraphContext);
            }
            return currentCtx;
        }

        void restoreNamedGraph(ListContext ctx) {
            this.update(this.namedGraphContext);
            this.restore(ctx);
        }

        public void end() throws RDFHandlerException {
            if (this.list != null) {
                this.endList(null);
            }
            for (ListContext listContext : this.namedGraphLists.values()) {
                this.restore(listContext);
                this.endList(null);
            }
            for (Map.Entry entry : this.varBNodes.entrySet()) {
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement((Resource)entry.getValue(), SP.VAR_NAME_PROPERTY, SpinRenderer.this.valueFactory.createLiteral((String)entry.getKey())));
            }
        }

        @Override
        public void meet(MultiProjection node) throws RDFHandlerException {
            ExtensionContext oldInlineBindings = this.meetExtension(node.getArg());
            ListContext ctx = this.startTemplateList();
            this.isMultiProjection = true;
            for (ProjectionElemList proj : node.getProjections()) {
                proj.visit(this);
            }
            this.endTemplateList(ctx);
            this.isMultiProjection = false;
            this.visitWhere(node.getArg());
            this.inlineBindings = oldInlineBindings;
        }

        ListContext startTemplateList() throws RDFHandlerException {
            BNode elemListBNode = SpinRenderer.this.valueFactory.createBNode();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.TEMPLATES_PROPERTY, elemListBNode));
            return this.newList(elemListBNode);
        }

        void endTemplateList(ListContext ctx) throws RDFHandlerException {
            this.endList(ctx);
        }

        @Override
        public void meet(Projection node) throws RDFHandlerException {
            ExtensionContext oldInlineBindings = this.meetExtension(node.getArg());
            if (this.isSubQuery) {
                this.listEntry();
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, SP.SUB_QUERY_CLASS));
                BNode queryBNode = SpinRenderer.this.valueFactory.createBNode();
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.QUERY_PROPERTY, queryBNode));
                this.subject = queryBNode;
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, SP.SELECT_CLASS));
            }
            node.getProjectionElemList().visit(this);
            this.visitWhere(node.getArg());
            node.getArg().visit(new GroupVisitor());
            node.getArg().visit(new OrderVisitor());
            this.inlineBindings = oldInlineBindings;
            this.hasGroup = false;
        }

        private void visitWhere(TupleExpr where) throws RDFHandlerException {
            BNode whereBNode = SpinRenderer.this.valueFactory.createBNode();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.WHERE_PROPERTY, whereBNode));
            this.isSubQuery = true;
            ListContext ctx = this.newList(whereBNode);
            where.visit(this);
            this.endList(ctx);
        }

        @Override
        public void meet(ProjectionElemList node) throws RDFHandlerException {
            BNode elemListBNode = SpinRenderer.this.valueFactory.createBNode();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.RESULT_VARIABLES_PROPERTY, elemListBNode));
            ListContext ctx = this.newList(elemListBNode);
            super.meet(node);
            this.endList(ctx);
        }

        @Override
        public void meet(ProjectionElem node) throws RDFHandlerException {
            ValueExpr valueExpr = null;
            if (this.inlineBindings != null) {
                String varName = node.getName();
                valueExpr = this.inlineBindings.getValueExpr(varName);
            }
            Resource targetVar = this.getVar(node.getProjectionAlias().orElse(node.getName()));
            this.listEntry(targetVar);
            if (valueExpr != null && !(valueExpr instanceof Var)) {
                Resource currentSubj = this.subject;
                this.subject = SpinRenderer.this.valueFactory.createBNode();
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(targetVar, SP.EXPRESSION_PROPERTY, this.subject));
                valueExpr.visit(new ExtensionVisitor());
                this.subject = currentSubj;
            }
        }

        @Override
        public void meet(Extension node) throws RDFHandlerException {
            if (this.inlineBindings != null && this.inlineBindings.extension == node) {
                node.getArg().visit(this);
            } else {
                node.getArg().visit(this);
                for (ExtensionElem elem : node.getElements()) {
                    elem.visit(this);
                }
            }
        }

        @Override
        public void meet(ExtensionElem node) throws RDFHandlerException {
            this.listEntry();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, SP.BIND_CLASS));
            Resource var = this.getVar(node.getName());
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.VARIABLE_PROPERTY, var));
            this.meet(node.getExpr());
        }

        private void meet(ValueExpr node) throws RDFHandlerException {
            this.predicate = SP.EXPRESSION_PROPERTY;
            ListContext ctx = this.save();
            this.list = null;
            node.visit(this);
            this.restore(ctx);
        }

        private void flushPendingStatement() throws RDFHandlerException {
            if (this.predicate != null) {
                BNode res = SpinRenderer.this.valueFactory.createBNode();
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, this.predicate, res));
                this.subject = res;
            }
        }

        @Override
        public void meet(StatementPattern node) throws RDFHandlerException {
            ListContext ctxList = null;
            if (StatementPattern.Scope.NAMED_CONTEXTS == node.getScope()) {
                ctxList = this.getNamedGraph(node.getContextVar());
            }
            this.listEntry();
            this.predicate = SP.SUBJECT_PROPERTY;
            node.getSubjectVar().visit(this);
            this.predicate = SP.PREDICATE_PROPERTY;
            node.getPredicateVar().visit(this);
            this.predicate = SP.OBJECT_PROPERTY;
            node.getObjectVar().visit(this);
            this.predicate = null;
            if (ctxList != null) {
                this.restoreNamedGraph(ctxList);
            }
        }

        @Override
        public void meet(Var node) throws RDFHandlerException {
            Value value = node.isConstant() ? node.getValue() : this.getVar(node.getName());
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, this.predicate, value));
        }

        @Override
        public void meet(ValueConstant node) throws RDFHandlerException {
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, this.predicate, node.getValue()));
        }

        @Override
        public void meet(Filter node) throws RDFHandlerException {
            this.hasGroup = false;
            node.getArg().visit(this);
            if (!this.hasGroup) {
                this.listEntry();
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, SP.FILTER_CLASS));
                this.meet(node.getCondition());
            }
        }

        @Override
        public void meet(Compare node) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, this.toValue(node.getOperator())));
            this.predicate = SP.ARG1_PROPERTY;
            node.getLeftArg().visit(this);
            this.predicate = SP.ARG2_PROPERTY;
            node.getRightArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        private Value toValue(Compare.CompareOp op) {
            switch (op) {
                case EQ: {
                    return SP.EQ;
                }
                case NE: {
                    return SP.NE;
                }
                case LT: {
                    return SP.LT;
                }
                case LE: {
                    return SP.LE;
                }
                case GE: {
                    return SP.GE;
                }
                case GT: {
                    return SP.GT;
                }
            }
            throw new AssertionError((Object)("Unrecognised CompareOp: " + op));
        }

        @Override
        public void meet(MathExpr node) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, this.toValue(node.getOperator())));
            this.predicate = SP.ARG1_PROPERTY;
            node.getLeftArg().visit(this);
            this.predicate = SP.ARG2_PROPERTY;
            node.getRightArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(And node) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, SP.AND));
            this.predicate = SP.ARG1_PROPERTY;
            node.getLeftArg().visit(this);
            this.predicate = SP.ARG2_PROPERTY;
            node.getRightArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(Or node) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, SP.OR));
            this.predicate = SP.ARG1_PROPERTY;
            node.getLeftArg().visit(this);
            this.predicate = SP.ARG2_PROPERTY;
            node.getRightArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(Bound node) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, SP.BOUND));
            this.predicate = SP.ARG1_PROPERTY;
            node.getArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(If node) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, SP.IF));
            this.predicate = SP.ARG1_PROPERTY;
            node.getCondition().visit(this);
            this.predicate = SP.ARG2_PROPERTY;
            node.getResult().visit(this);
            this.predicate = SP.ARG3_PROPERTY;
            node.getAlternative().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(Coalesce node) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, SP.COALESCE));
            List<ValueExpr> args = node.getArguments();
            for (int i = 0; i < args.size(); ++i) {
                this.predicate = this.toArgProperty(i + 1);
                args.get(i).visit(this);
            }
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(IsURI node) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, SP.IS_IRI));
            this.predicate = SP.ARG1_PROPERTY;
            node.getArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(IsBNode node) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, SP.IS_BLANK));
            this.predicate = SP.ARG1_PROPERTY;
            node.getArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(IsLiteral node) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, SP.IS_LITERAL));
            this.predicate = SP.ARG1_PROPERTY;
            node.getArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(IsNumeric node) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, SP.IS_NUMERIC));
            this.predicate = SP.ARG1_PROPERTY;
            node.getArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(Str node) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, SP.STR));
            this.predicate = SP.ARG1_PROPERTY;
            node.getArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(Lang node) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, SP.LANG));
            this.predicate = SP.ARG1_PROPERTY;
            node.getArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(Datatype node) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, SP.DATATYPE));
            this.predicate = SP.ARG1_PROPERTY;
            node.getArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(IRIFunction node) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, SP.IRI));
            this.predicate = SP.ARG1_PROPERTY;
            node.getArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(BNodeGenerator node) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, SP.BNODE));
            if (node.getNodeIdExpr() != null) {
                this.predicate = SP.ARG1_PROPERTY;
                node.getNodeIdExpr().visit(this);
            }
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(Regex node) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, SP.REGEX));
            this.predicate = SP.ARG1_PROPERTY;
            node.getLeftArg().visit(this);
            this.predicate = SP.ARG2_PROPERTY;
            node.getRightArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(LocalName node) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, AFN.LOCALNAME));
            this.predicate = SP.ARG1_PROPERTY;
            node.getArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        private Value toValue(MathExpr.MathOp op) {
            switch (op) {
                case PLUS: {
                    return SP.ADD;
                }
                case MINUS: {
                    return SP.SUB;
                }
                case MULTIPLY: {
                    return SP.MUL;
                }
                case DIVIDE: {
                    return SP.DIVIDE;
                }
            }
            throw new AssertionError((Object)("Unrecognised MathOp: " + op));
        }

        @Override
        public void meet(FunctionCall node) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, this.toValue(node)));
            List<ValueExpr> args = node.getArgs();
            for (int i = 0; i < args.size(); ++i) {
                this.predicate = this.toArgProperty(i + 1);
                args.get(i).visit(this);
            }
            this.subject = currentSubj;
            this.predicate = null;
        }

        private Value toValue(FunctionCall node) {
            String funcName = node.getURI();
            IRI funcUri = (IRI)SpinRenderer.this.wellKnownFunctions.apply((Object)funcName);
            if (funcUri == null) {
                funcUri = SpinRenderer.this.valueFactory.createIRI(funcName);
            }
            return funcUri;
        }

        private IRI toArgProperty(int i) {
            switch (i) {
                case 1: {
                    return SP.ARG1_PROPERTY;
                }
                case 2: {
                    return SP.ARG2_PROPERTY;
                }
                case 3: {
                    return SP.ARG3_PROPERTY;
                }
                case 4: {
                    return SP.ARG4_PROPERTY;
                }
                case 5: {
                    return SP.ARG5_PROPERTY;
                }
            }
            return SpinRenderer.this.valueFactory.createIRI("http://spinrdf.org/sp#", "arg" + i);
        }

        @Override
        public void meet(Not node) throws RDFHandlerException {
            if (node.getArg() instanceof Exists) {
                super.meet(node);
            } else {
                Resource currentSubj = this.subject;
                this.flushPendingStatement();
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, SP.NOT));
                this.predicate = SP.ARG1_PROPERTY;
                node.getArg().visit(this);
                this.subject = currentSubj;
                this.predicate = null;
            }
        }

        @Override
        public void meet(Exists node) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            IRI op = node.getParentNode() instanceof Not ? SP.NOT_EXISTS : SP.EXISTS;
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, op));
            BNode elementsList = SpinRenderer.this.valueFactory.createBNode();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.ELEMENTS_PROPERTY, elementsList));
            ListContext elementsCtx = this.newList(elementsList);
            node.getSubQuery().visit(this);
            this.endList(elementsCtx);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(Group node) throws RDFHandlerException {
            node.getArg().visit(this);
            this.hasGroup = true;
        }

        @Override
        public void meet(Order node) throws RDFHandlerException {
            node.getArg().visit(this);
        }

        @Override
        public void meet(Slice node) throws RDFHandlerException {
            node.getArg().visit(this);
            if (node.hasLimit()) {
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.LIMIT_PROPERTY, SpinRenderer.this.valueFactory.createLiteral(Long.toString(node.getLimit()), XSD.INTEGER)));
            }
            if (node.hasOffset()) {
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.OFFSET_PROPERTY, SpinRenderer.this.valueFactory.createLiteral(Long.toString(node.getOffset()), XSD.INTEGER)));
            }
        }

        @Override
        public void meet(Distinct node) throws RDFHandlerException {
            node.getArg().visit(this);
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.DISTINCT_PROPERTY, BooleanLiteral.TRUE));
        }

        @Override
        public void meet(Reduced node) throws RDFHandlerException {
            node.getArg().visit(this);
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.REDUCED_PROPERTY, BooleanLiteral.TRUE));
        }

        @Override
        public void meet(Join node) throws RDFHandlerException {
            boolean isGroupGraphPattern = node.getRightArg() instanceof Join;
            if (!isGroupGraphPattern) {
                super.meet(node);
            } else {
                this.listEntry();
                ListContext leftGroupCtx = this.newList(this.subject);
                node.getLeftArg().visit(this);
                this.endList(leftGroupCtx);
                this.listEntry();
                ListContext rightGroupCtx = this.newList(this.subject);
                node.getRightArg().visit(this);
                this.endList(rightGroupCtx);
            }
        }

        @Override
        public void meet(LeftJoin node) throws RDFHandlerException {
            node.getLeftArg().visit(this);
            this.listEntry();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, SP.OPTIONAL_CLASS));
            BNode elementsList = SpinRenderer.this.valueFactory.createBNode();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.ELEMENTS_PROPERTY, elementsList));
            ListContext elementsCtx = this.newList(elementsList);
            node.getRightArg().visit(this);
            this.endList(elementsCtx);
        }

        @Override
        public void meet(Union node) throws RDFHandlerException {
            this.listEntry();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, SP.UNION_CLASS));
            BNode elementsList = SpinRenderer.this.valueFactory.createBNode();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.ELEMENTS_PROPERTY, elementsList));
            ListContext elementsCtx = this.newList(elementsList);
            this.listEntry();
            ListContext leftCtx = this.newList(this.subject);
            node.getLeftArg().visit(this);
            this.endList(leftCtx);
            this.listEntry();
            ListContext rightCtx = this.newList(this.subject);
            node.getRightArg().visit(this);
            this.endList(rightCtx);
            this.endList(elementsCtx);
        }

        @Override
        public void meet(Difference node) throws RDFHandlerException {
            node.getLeftArg().visit(this);
            this.listEntry();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, SP.MINUS_CLASS));
            BNode elementsList = SpinRenderer.this.valueFactory.createBNode();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.ELEMENTS_PROPERTY, elementsList));
            ListContext elementsCtx = this.newList(elementsList);
            node.getRightArg().visit(this);
            this.endList(elementsCtx);
        }

        @Override
        public void meet(Service node) throws RDFHandlerException {
            this.listEntry();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, SP.SERVICE_CLASS));
            this.predicate = SP.SERVICE_URI_PROPERTY;
            node.getServiceRef().visit(this);
            this.predicate = null;
            BNode elementsList = SpinRenderer.this.valueFactory.createBNode();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.ELEMENTS_PROPERTY, elementsList));
            ListContext elementsCtx = this.newList(elementsList);
            node.getArg().visit(this);
            this.endList(elementsCtx);
        }

        @Override
        public void meet(BindingSetAssignment node) throws RDFHandlerException {
            this.listEntry();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, SP.VALUES_CLASS));
            BNode bindingList = SpinRenderer.this.valueFactory.createBNode();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.BINDINGS_PROPERTY, bindingList));
            ListContext bindingCtx = this.newList(bindingList);
            ArrayList<String> bindingVars = new ArrayList<String>(node.getBindingNames());
            for (BindingSet bs : node.getBindingSets()) {
                this.listEntry();
                ListContext setCtx = this.newList(this.subject);
                for (String varName : bindingVars) {
                    Value v = bs.getValue(varName);
                    if (v == null) {
                        v = SP.UNDEF;
                    }
                    this.listEntry(v);
                }
                this.endList(setCtx);
            }
            this.endList(bindingCtx);
            BNode varNameList = SpinRenderer.this.valueFactory.createBNode();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.VAR_NAMES_PROPERTY, varNameList));
            ListContext varnameCtx = this.newList(varNameList);
            for (String varName : bindingVars) {
                this.listEntry(SpinRenderer.this.valueFactory.createLiteral(varName));
            }
            this.endList(varnameCtx);
        }

        @Override
        public void meet(Modify node) throws RDFHandlerException {
            TupleExpr insertExpr = node.getInsertExpr();
            TupleExpr deleteExpr = node.getDeleteExpr();
            TupleExpr whereExpr = node.getWhereExpr();
            if (insertExpr == null && whereExpr.equals(deleteExpr)) {
                this.visitWhere(whereExpr);
            } else {
                if (insertExpr != null) {
                    BNode insertList = SpinRenderer.this.valueFactory.createBNode();
                    this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.INSERT_PATTERN_PROPERTY, insertList));
                    ListContext insertCtx = this.newList(insertList);
                    insertExpr.visit(this);
                    this.endList(insertCtx);
                }
                if (deleteExpr != null) {
                    BNode deleteList = SpinRenderer.this.valueFactory.createBNode();
                    this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.DELETE_PATTERN_PROPERTY, deleteList));
                    ListContext deleteCtx = this.newList(deleteList);
                    deleteExpr.visit(this);
                    this.endList(deleteCtx);
                }
                if (whereExpr != null) {
                    BNode whereList = SpinRenderer.this.valueFactory.createBNode();
                    this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.WHERE_PROPERTY, whereList));
                    ListContext whereCtx = this.newList(whereList);
                    whereExpr.visit(this);
                    this.endList(whereCtx);
                }
            }
        }

        @Override
        public void meet(InsertData node) throws RDFHandlerException {
            BNode dataList = SpinRenderer.this.valueFactory.createBNode();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.DATA_PROPERTY, dataList));
            ListContext dataCtx = this.newList(dataList);
            this.renderDataBlock(node.getDataBlock());
            this.endList(dataCtx);
        }

        @Override
        public void meet(DeleteData node) throws RDFHandlerException {
            BNode dataList = SpinRenderer.this.valueFactory.createBNode();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.DATA_PROPERTY, dataList));
            ListContext dataCtx = this.newList(dataList);
            this.renderDataBlock(node.getDataBlock());
            this.endList(dataCtx);
        }

        private void renderDataBlock(String data) throws RDFHandlerException {
            SPARQLUpdateDataBlockParser parser = new SPARQLUpdateDataBlockParser(SpinRenderer.this.valueFactory);
            parser.setAllowBlankNodes(false);
            parser.setRDFHandler(new AbstractRDFHandler(){
                final Map<Resource, ListContext> namedGraphLists = new HashMap<Resource, ListContext>();
                ListContext namedGraphContext;

                @Override
                public void handleStatement(Statement st) throws RDFHandlerException {
                    ListContext ctxList = null;
                    if (st.getContext() != null) {
                        ctxList = this.getNamedGraph(st.getContext());
                    }
                    SpinVisitor.this.listEntry();
                    SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.SUBJECT_PROPERTY, st.getSubject()));
                    SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.PREDICATE_PROPERTY, st.getPredicate()));
                    SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.OBJECT_PROPERTY, st.getObject()));
                    if (ctxList != null) {
                        this.restoreNamedGraph(ctxList);
                    }
                }

                @Override
                public void endRDF() throws RDFHandlerException {
                    for (ListContext ctxList : this.namedGraphLists.values()) {
                        SpinVisitor.this.endList(ctxList);
                    }
                }

                private ListContext getNamedGraph(Resource context) throws RDFHandlerException {
                    ListContext currentCtx;
                    this.namedGraphContext = this.namedGraphLists.get(context);
                    if (this.namedGraphContext == null) {
                        SpinVisitor.this.listEntry();
                        SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, RDF.TYPE, SP.NAMED_GRAPH_CLASS));
                        SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.GRAPH_NAME_NODE_PROPERTY, context));
                        BNode elementsList = SpinRenderer.this.valueFactory.createBNode();
                        SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.ELEMENTS_PROPERTY, elementsList));
                        currentCtx = SpinVisitor.this.newList(elementsList);
                        this.namedGraphContext = SpinVisitor.this.save();
                        this.namedGraphLists.put(context, this.namedGraphContext);
                    } else {
                        currentCtx = SpinVisitor.this.save();
                        SpinVisitor.this.restore(this.namedGraphContext);
                    }
                    return currentCtx;
                }

                private void restoreNamedGraph(ListContext ctx) {
                    SpinVisitor.this.update(this.namedGraphContext);
                    SpinVisitor.this.restore(ctx);
                }
            });
            try {
                parser.parse(new StringReader(data), "");
            }
            catch (IOException | RDFParseException e) {
                throw new RDFHandlerException(e);
            }
        }

        @Override
        public void meet(Load node) throws RDFHandlerException {
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.DOCUMENT_PROPERTY, node.getSource().getValue()));
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.INTO_PROPERTY, node.getGraph().getValue()));
        }

        @Override
        public void meet(Clear node) throws RDFHandlerException {
            if (node.isSilent()) {
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.SILENT_PROPERTY, BooleanLiteral.TRUE));
            }
            if (node.getGraph() != null) {
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.GRAPH_IRI_PROPERTY, node.getGraph().getValue()));
            } else if (node.getScope() != null) {
                switch (node.getScope()) {
                    case DEFAULT_CONTEXTS: {
                        this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.DEFAULT_PROPERTY, BooleanLiteral.TRUE));
                        break;
                    }
                    case NAMED_CONTEXTS: {
                        this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.NAMED_PROPERTY, BooleanLiteral.TRUE));
                    }
                }
            } else {
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.ALL_PROPERTY, BooleanLiteral.TRUE));
            }
        }

        @Override
        public void meet(Create node) throws RDFHandlerException {
            if (node.isSilent()) {
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.SILENT_PROPERTY, BooleanLiteral.TRUE));
            }
            if (node.getGraph() != null) {
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.GRAPH_IRI_PROPERTY, node.getGraph().getValue()));
            }
        }

        private final class OrderVisitor
        extends QueryModelVisitorBase<RDFHandlerException> {
            private OrderVisitor() {
            }

            @Override
            public void meet(Order node) throws RDFHandlerException {
                BNode orderByList = SpinRenderer.this.valueFactory.createBNode();
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.ORDER_BY_PROPERTY, orderByList));
                ListContext orderByCtx = SpinVisitor.this.newList(orderByList);
                for (OrderElem elem : node.getElements()) {
                    elem.visit(this);
                }
                SpinVisitor.this.endList(orderByCtx);
            }

            @Override
            public void meet(OrderElem node) throws RDFHandlerException {
                IRI asc = node.isAscending() ? SP.ASC_CLASS : SP.DESC_CLASS;
                SpinVisitor.this.listEntry();
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, RDF.TYPE, asc));
                SpinVisitor.this.meet(node.getExpr());
            }

            @Override
            protected void meetNode(QueryModelNode node) {
            }
        }

        private final class GroupVisitor
        extends QueryModelVisitorBase<RDFHandlerException> {
            Group group;

            private GroupVisitor() {
            }

            @Override
            public void meet(Order node) throws RDFHandlerException {
                node.getArg().visit(this);
            }

            @Override
            public void meet(Extension node) throws RDFHandlerException {
                node.getArg().visit(this);
            }

            @Override
            public void meet(Group node) throws RDFHandlerException {
                this.group = node;
                Set<String> groupNames = node.getGroupBindingNames();
                if (!groupNames.isEmpty()) {
                    BNode groupByList = SpinRenderer.this.valueFactory.createBNode();
                    SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.GROUP_BY_PROPERTY, groupByList));
                    ListContext groupByCtx = SpinVisitor.this.newList(groupByList);
                    for (String groupName : groupNames) {
                        Resource var = SpinVisitor.this.getVar(groupName);
                        SpinVisitor.this.listEntry(var);
                    }
                    SpinVisitor.this.endList(groupByCtx);
                }
            }

            @Override
            public void meet(Filter node) throws RDFHandlerException {
                node.getArg().visit(this);
                if (this.group != null) {
                    BNode havingList = SpinRenderer.this.valueFactory.createBNode();
                    SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.HAVING_PROPERTY, havingList));
                    ListContext havingCtx = SpinVisitor.this.newList(havingList);
                    SpinVisitor.this.listEntry();
                    node.getCondition().visit(SpinVisitor.this);
                    SpinVisitor.this.endList(havingCtx);
                }
            }

            @Override
            protected void meetNode(QueryModelNode node) {
            }
        }

        private final class ExtensionVisitor
        extends QueryModelVisitorBase<RDFHandlerException> {
            private ExtensionVisitor() {
            }

            @Override
            public void meet(Count node) throws RDFHandlerException {
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, RDF.TYPE, SP.COUNT_CLASS));
                if (node.isDistinct()) {
                    SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.DISTINCT_PROPERTY, BooleanLiteral.TRUE));
                }
                Resource oldSubject = SpinVisitor.this.subject;
                super.meet(node);
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(oldSubject, SP.EXPRESSION_PROPERTY, SpinVisitor.this.subject));
                SpinVisitor.this.subject = oldSubject;
            }

            @Override
            public void meet(Max node) throws RDFHandlerException {
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, RDF.TYPE, SP.MAX_CLASS));
                if (node.isDistinct()) {
                    SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.DISTINCT_PROPERTY, BooleanLiteral.TRUE));
                }
                Resource oldSubject = SpinVisitor.this.subject;
                super.meet(node);
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(oldSubject, SP.EXPRESSION_PROPERTY, SpinVisitor.this.subject));
                SpinVisitor.this.subject = oldSubject;
            }

            @Override
            public void meet(Min node) throws RDFHandlerException {
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, RDF.TYPE, SP.MIN_CLASS));
                if (node.isDistinct()) {
                    SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.DISTINCT_PROPERTY, BooleanLiteral.TRUE));
                }
                Resource oldSubject = SpinVisitor.this.subject;
                super.meet(node);
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(oldSubject, SP.EXPRESSION_PROPERTY, SpinVisitor.this.subject));
                SpinVisitor.this.subject = oldSubject;
            }

            @Override
            public void meet(Sum node) throws RDFHandlerException {
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, RDF.TYPE, SP.SUM_CLASS));
                if (node.isDistinct()) {
                    SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.DISTINCT_PROPERTY, BooleanLiteral.TRUE));
                }
                Resource oldSubject = SpinVisitor.this.subject;
                super.meet(node);
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(oldSubject, SP.EXPRESSION_PROPERTY, SpinVisitor.this.subject));
                SpinVisitor.this.subject = oldSubject;
            }

            @Override
            public void meet(Avg node) throws RDFHandlerException {
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, RDF.TYPE, SP.AVG_CLASS));
                if (node.isDistinct()) {
                    SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.DISTINCT_PROPERTY, BooleanLiteral.TRUE));
                }
                Resource oldSubject = SpinVisitor.this.subject;
                super.meet(node);
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(oldSubject, SP.EXPRESSION_PROPERTY, SpinVisitor.this.subject));
                SpinVisitor.this.subject = oldSubject;
            }

            @Override
            public void meet(GroupConcat node) throws RDFHandlerException {
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, RDF.TYPE, SP.GROUP_CONCAT_CLASS));
                if (node.isDistinct()) {
                    SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.DISTINCT_PROPERTY, BooleanLiteral.TRUE));
                }
                Resource oldSubject = SpinVisitor.this.subject;
                super.meet(node);
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(oldSubject, SP.EXPRESSION_PROPERTY, SpinVisitor.this.subject));
                SpinVisitor.this.subject = oldSubject;
            }

            @Override
            public void meet(Sample node) throws RDFHandlerException {
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, RDF.TYPE, SP.SAMPLE_CLASS));
                if (node.isDistinct()) {
                    SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.DISTINCT_PROPERTY, BooleanLiteral.TRUE));
                }
                Resource oldSubject = SpinVisitor.this.subject;
                super.meet(node);
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(oldSubject, SP.EXPRESSION_PROPERTY, SpinVisitor.this.subject));
                SpinVisitor.this.subject = oldSubject;
            }

            @Override
            public void meet(Var node) throws RDFHandlerException {
                SpinVisitor.this.subject = SpinVisitor.this.getVar(node.getName());
            }
        }
    }

    private class ConstructVisitor
    extends SpinVisitor {
        ConstructVisitor(RDFHandler handler, Resource subject, Dataset dataset) {
            super(handler, null, subject, dataset);
        }

        @Override
        public void meet(Reduced node) throws RDFHandlerException {
            if (!this.isSubQuery) {
                node.getArg().visit(this);
            } else {
                super.meet(node);
            }
        }

        @Override
        public void meet(ProjectionElemList node) throws RDFHandlerException {
            if (this.isSubQuery) {
                super.meet(node);
            } else if (this.isMultiProjection) {
                this.listEntry();
                this.meetNode(node);
            } else {
                ListContext ctx = this.startTemplateList();
                this.listEntry();
                this.meetNode(node);
                this.endTemplateList(ctx);
            }
        }

        @Override
        public void meet(ProjectionElem node) throws RDFHandlerException {
            if (this.isSubQuery) {
                super.meet(node);
            } else {
                IRI pred;
                String varName = node.getName();
                ValueExpr valueExpr = this.inlineBindings.getValueExpr(varName);
                Value value = valueExpr instanceof ValueConstant ? ((ValueConstant)valueExpr).getValue() : this.getVar(varName);
                String targetName = node.getProjectionAlias().orElse(null);
                if ("subject".equals(targetName)) {
                    pred = SP.SUBJECT_PROPERTY;
                } else if ("predicate".equals(targetName)) {
                    pred = SP.PREDICATE_PROPERTY;
                } else if ("object".equals(targetName)) {
                    pred = SP.OBJECT_PROPERTY;
                } else {
                    throw new AssertionError((Object)("Unexpected ProjectionElem: " + node));
                }
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, pred, value));
            }
        }
    }

    private class DescribeVisitor
    extends SpinVisitor {
        DescribeVisitor(RDFHandler handler, Resource subject, Dataset dataset) {
            super(handler, null, subject, dataset);
        }

        @Override
        public void meet(ProjectionElemList node) throws RDFHandlerException {
            if (this.isSubQuery) {
                super.meet(node);
            } else {
                BNode elemListBNode = SpinRenderer.this.valueFactory.createBNode();
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.RESULT_NODES_PROPERTY, elemListBNode));
                ListContext ctx = this.newList(elemListBNode);
                this.meetNode(node);
                this.endList(ctx);
            }
        }
    }

    private class AskVisitor
    extends SpinVisitor {
        AskVisitor(RDFHandler handler, Resource list, Dataset dataset) {
            super(handler, list, null, dataset);
        }

        @Override
        public void meet(Slice node) throws RDFHandlerException {
            if (!this.isSubQuery) {
                node.getArg().visit(this);
            } else {
                super.meet(node);
            }
        }
    }

    public static enum Output {
        TEXT_AND_RDF(true, true),
        TEXT_ONLY(true, false),
        RDF_ONLY(false, true);

        final boolean text;
        final boolean rdf;

        private Output(boolean text, boolean rdf) {
            this.text = text;
            this.rdf = rdf;
        }
    }
}

