/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.core;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.rcptt.ecl.core.CoreFactory;
import org.eclipse.rcptt.ecl.core.CorePackage;
import org.eclipse.rcptt.ecl.core.EclException;
import org.eclipse.rcptt.ecl.core.EclStackTraceEntry;
import org.eclipse.rcptt.ecl.core.ProcessStatus;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;
import org.eclipse.rcptt.ecl.internal.core.EMFConverterManager;
import org.eclipse.rcptt.ecl.runtime.IEMFConverter;

public class ProcessStatusConverter
implements IEMFConverter<IStatus, ProcessStatus> {
    @Override
    public Class<IStatus> getJavaClass() {
        return IStatus.class;
    }

    @Override
    public EClass getEClass() {
        return CorePackage.eINSTANCE.getProcessStatus();
    }

    @Override
    public IStatus fromEObject(ProcessStatus ps) {
        Throwable th = null;
        EclException exception = ps.getException();
        if (exception != null) {
            th = ProcessStatusConverter.getThrowable(exception);
        }
        if (!ps.getChildren().isEmpty()) {
            ArrayList<IStatus> children = new ArrayList<IStatus>(ps.getChildren().size());
            for (ProcessStatus child : ps.getChildren()) {
                try {
                    children.add((IStatus)EMFConverterManager.INSTANCE.fromEObject(child));
                }
                catch (CoreException e) {
                    CorePlugin.log(e.getStatus());
                    children.add(e.getStatus());
                }
                catch (ClassCastException e) {
                    CorePlugin.log(e);
                    children.add(CorePlugin.err(e));
                }
            }
            return new MultiStatus(ps.getPluginId(), ps.getCode(), children.toArray(new IStatus[children.size()]), ps.getMessage(), th);
        }
        return new Status(ps.getSeverity(), ps.getPluginId(), ps.getCode(), ps.getMessage(), th);
    }

    public static Throwable getThrowable(EclException exception) {
        if (exception == null) {
            return null;
        }
        Throwable th = null;
        try {
            th = exception.getThrowable();
            if (!Objects.equals(th.getClass().getName(), exception.getClassName())) {
                throw new IllegalStateException(String.format("Bad class, expected: %s, actual: %s ", exception.getClassName(), th.getClass().getName()));
            }
        }
        catch (Throwable ee) {
            try {
                String className = exception.getClassName();
                Class<?> forName = Class.forName(className);
                try {
                    Throwable newInstance;
                    Constructor<?> constructor = forName.getConstructor(String.class, Throwable.class);
                    th = newInstance = (Throwable)constructor.newInstance(exception.getMessage(), ProcessStatusConverter.getThrowable(exception.getCause()));
                }
                catch (NoSuchMethodException e) {
                    Throwable newInstance;
                    if (exception.getStatus() == null) {
                        throw e;
                    }
                    Constructor<?> constructor = forName.getConstructor(IStatus.class);
                    th = newInstance = (Throwable)constructor.newInstance(ProcessStatusConverter.toIStatus(exception.getStatus()));
                    th.addSuppressed(e);
                }
                th.addSuppressed(ee);
            }
            catch (Exception eee) {
                th = exception.getStatus() != null ? new CoreException(ProcessStatusConverter.toIStatus(exception.getStatus())) : new Exception(exception.getMessage(), ProcessStatusConverter.getThrowable(exception.getCause()));
                th.addSuppressed(eee);
            }
        }
        if (th != null) {
            ProcessStatusConverter.copyAttributesFromEObject(exception, th);
        }
        return th;
    }

    private static void copyAttributesFromEObject(EclException exception, Throwable newInstance) {
        EList<EclStackTraceEntry> list = exception.getStackTrace();
        if (list.size() > 0) {
            newInstance.setStackTrace(ProcessStatusConverter.constructStack(list));
        }
    }

    private static StackTraceElement[] constructStack(EList<EclStackTraceEntry> list) {
        StackTraceElement[] stack = new StackTraceElement[list.size()];
        int i = 0;
        while (i < list.size()) {
            EclStackTraceEntry entry = (EclStackTraceEntry)list.get(i);
            stack[i] = new StackTraceElement(entry.getDeclaringClass(), entry.getMethodName(), entry.getFileName(), entry.getLineNumber());
            ++i;
        }
        return stack;
    }

    @Override
    public ProcessStatus toEObject(IStatus status) throws CoreException {
        ProcessStatus rv = CoreFactory.eINSTANCE.createProcessStatus();
        ProcessStatusConverter.toEObject(status, rv);
        return rv;
    }

    public static ProcessStatus toProcessStatus(IStatus status) {
        block6: {
            if (status != null) break block6;
            return null;
        }
        try {
            return (ProcessStatus)EMFConverterManager.INSTANCE.toEObject(status);
        }
        catch (CoreException e) {
            try {
                return (ProcessStatus)EMFConverterManager.INSTANCE.toEObject(e.getStatus());
            }
            catch (CoreException e1) {
                CorePlugin.log(e1.getStatus());
                ProcessStatus ps = CoreFactory.eINSTANCE.createProcessStatus();
                ps.setSeverity(4);
                ps.setMessage("Failed to convert result status " + status.getClass().getName() + ". See AUT's log");
                ps.setPluginId("org.eclipse.rcptt.ecl.core");
                return ps;
            }
        }
        catch (ClassCastException e) {
            return ProcessStatusConverter.toProcessStatus(CorePlugin.err(e));
        }
    }

    public static IStatus toIStatus(ProcessStatus status) {
        try {
            return (IStatus)EMFConverterManager.INSTANCE.fromEObject(status);
        }
        catch (CoreException e) {
            try {
                return (IStatus)EMFConverterManager.INSTANCE.toEObject(e.getStatus());
            }
            catch (CoreException e1) {
                CorePlugin.log(e1.getStatus());
                return new Status(4, "org.eclipse.rcptt.ecl.core", "Failed to convert result status. See IDE's log");
            }
        }
    }

    public static void toEObject(IStatus status, ProcessStatus ps) throws CoreException {
        ps.setCode(status.getCode());
        ps.setMessage(status.getMessage());
        ps.setPluginId(status.getPlugin());
        ps.setSeverity(status.getSeverity());
        Throwable exception = status.getException();
        if (exception != null) {
            ps.setException(ProcessStatusConverter.toException(exception));
        }
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                ProcessStatus s;
                IStatus child = iStatusArray[n2];
                try {
                    s = (ProcessStatus)EMFConverterManager.INSTANCE.toEObject(child);
                }
                catch (ClassCastException e) {
                    s = CoreFactory.eINSTANCE.createProcessStatus();
                    ProcessStatusConverter.toEObject(CorePlugin.err(e), s);
                }
                ps.getChildren().add((Object)s);
                ++n2;
            }
        }
    }

    private static EclException toException(Throwable exception) {
        EclException ex = CoreFactory.eINSTANCE.createEclException();
        ex.setClassName(exception.getClass().getName());
        ex.setMessage(exception.getMessage());
        ex.setThrowable(exception);
        StackTraceElement[] elements = exception.getStackTrace();
        int index = 0;
        StackTraceElement[] stackTraceElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement ee = stackTraceElementArray[n2];
            EclStackTraceEntry e = CoreFactory.eINSTANCE.createEclStackTraceEntry();
            e.setDeclaringClass(ee.getClassName());
            e.setFileName(ee.getFileName());
            e.setLineNumber(ee.getLineNumber());
            e.setMethodName(ee.getMethodName());
            e.setIndex(index++);
            e.setNativeMethod(ee.isNativeMethod());
            ex.getStackTrace().add((Object)e);
            ++n2;
        }
        Throwable cause = exception.getCause();
        if (cause != null) {
            ex.setCause(ProcessStatusConverter.toException(cause));
        }
        if (exception instanceof CoreException) {
            ex.setStatus(ProcessStatusConverter.toProcessStatus(((CoreException)exception).getStatus()));
        }
        return ex;
    }
}

