/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core.swt;

import org.eclipse.rcptt.tesla.core.protocol.ControlUIElement;
import org.eclipse.rcptt.tesla.core.protocol.DragKind;
import org.eclipse.rcptt.tesla.core.protocol.UIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.ui.player.FindResult;
import org.eclipse.rcptt.tesla.recording.core.TeslaRecorder;
import org.eclipse.rcptt.tesla.recording.core.swt.IRecordingDescriber;
import org.eclipse.rcptt.tesla.recording.core.swt.RecordingDescriberManager;
import org.eclipse.rcptt.tesla.recording.core.swt.SWTRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.swt.SWTWidgetLocator;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DNDSupport {
    private TeslaRecorder recorder;
    private Element enterWidget;

    public void setRecorder(TeslaRecorder recorder) {
        this.recorder = recorder;
    }

    public void processUniversalDND(Event event) {
        if (this.recorder == null) {
            return;
        }
        SWTWidgetLocator locator = SWTRecordingHelper.getHelper().getLocator();
        Object style = "";
        style = (String)style + "detail:" + event.detail + ",";
        style = (String)style + "button:" + event.button + ",";
        style = (String)style + "mask:" + event.stateMask + ",";
        style = (String)style + "operations:-1";
        if (event.widget instanceof DragSource) {
            DragSource source = (DragSource)event.widget;
            Control widget = source.getControl();
            ControlUIElement control = new ControlUIElement(locator.findElement((Widget)widget, (boolean)true, (boolean)false, (boolean)false).element, (UIPlayer)locator.getRecorder());
            switch (event.type) {
                case 2008: {
                    control.drag(DragKind.START, Integer.valueOf(event.x), Integer.valueOf(event.y), (String)style);
                    break;
                }
                case 2001: {
                    control.drag(DragKind.SET_DATA, null, null, (String)style);
                    break;
                }
                case 2000: {
                    control.drag(DragKind.END, null, null, (String)style);
                }
            }
        } else if (event.widget instanceof DropTarget) {
            DropTarget target = (DropTarget)event.widget;
            Control widget = target.getControl();
            if (widget instanceof Shell) {
                return;
            }
            FindResult el = locator.findElement((Widget)widget, true, false, false);
            if (el == null) {
                return;
            }
            ControlUIElement control = new ControlUIElement(el.element, (UIPlayer)locator.getRecorder());
            Point clientPoint = widget.toControl(event.x, event.y);
            switch (event.type) {
                case 2002: {
                    control.drag(DragKind.ENTER, Integer.valueOf(clientPoint.x), Integer.valueOf(clientPoint.y), (String)style);
                    break;
                }
                case 2004: {
                    control.drag(DragKind.OVER, Integer.valueOf(clientPoint.x), Integer.valueOf(clientPoint.y), (String)style);
                    break;
                }
                case 2003: {
                    control.drag(DragKind.LEAVE, null, null, (String)style);
                    break;
                }
                case 2007: {
                    control.drag(DragKind.ACCEPT, Integer.valueOf(clientPoint.x), Integer.valueOf(clientPoint.y), (String)style);
                    break;
                }
                case 2006: {
                    control.drag(DragKind.DROP, Integer.valueOf(clientPoint.x), Integer.valueOf(clientPoint.y), (String)style);
                }
            }
        }
    }

    public void processDND(Event event) {
        ControlUIElement control;
        if (this.recorder == null) {
            return;
        }
        Control realWidget = null;
        if (event.widget instanceof DropTarget) {
            realWidget = ((DropTarget)event.widget).getControl();
        } else if (event.widget instanceof DragSource) {
            realWidget = ((DragSource)event.widget).getControl();
        }
        if (realWidget == null) {
            return;
        }
        Widget item = event.item;
        if (item == null) {
            item = realWidget;
        }
        Point controlPoint = new Point(event.x, event.y);
        if (event.widget instanceof DropTarget) {
            controlPoint = realWidget.toControl(event.x, event.y);
        }
        IRecordingDescriber describer = null;
        describer = RecordingDescriberManager.getDescriber(item, controlPoint.x, controlPoint.y, false);
        Point point = null;
        Point offset = null;
        Element itemElement = null;
        if (describer != null) {
            if (!describer.supportsDND()) {
                this.processUniversalDND(event);
                return;
            }
            point = describer.getRealPoint();
            point = realWidget.toControl(point);
            offset = new Point(controlPoint.x - point.x, controlPoint.y - point.y);
            if (event.type == 2003 || event.type == 2001 || event.type == 2000) {
                offset = new Point(0, 0);
            }
        } else {
            TeslaCore.log((String)("Failed to locate element for drag&drop operation:" + realWidget.getClass().getCanonicalName()));
            return;
        }
        itemElement = describer.searchForElement(this.recorder);
        if (event.type != 2000 && event.type != 2001) {
            control = new ControlUIElement(itemElement, (UIPlayer)this.recorder);
        } else {
            SWTWidgetLocator locator = SWTRecordingHelper.getHelper().getLocator();
            control = new ControlUIElement(locator.findElement((Widget)realWidget, (boolean)false, (boolean)false, (boolean)false).element, (UIPlayer)locator.getRecorder());
        }
        Object style = "";
        style = (String)style + "detail:" + event.detail + ",";
        style = (String)style + "button:" + event.button + ",";
        style = (String)style + "mask:" + event.stateMask + ",";
        style = (String)style + "operations:-1";
        switch (event.type) {
            case 2008: {
                control.drag(DragKind.START, Integer.valueOf(offset.x), Integer.valueOf(offset.y), (String)style);
                break;
            }
            case 2000: {
                control.drag(DragKind.END, null, null, (String)style);
                break;
            }
            case 2004: {
                control.drag(DragKind.OVER, Integer.valueOf(offset.x), Integer.valueOf(offset.y), (String)style);
                break;
            }
            case 2002: {
                this.enterWidget = itemElement;
                control.drag(DragKind.ENTER, Integer.valueOf(offset.x), Integer.valueOf(offset.y), (String)style);
                break;
            }
            case 2001: {
                control.drag(DragKind.SET_DATA, null, null, (String)style);
                break;
            }
            case 2007: {
                control.drag(DragKind.ACCEPT, Integer.valueOf(offset.x), Integer.valueOf(offset.y), (String)style);
                break;
            }
            case 2003: {
                control = new ControlUIElement(this.enterWidget, (UIPlayer)this.recorder);
                control.drag(DragKind.LEAVE, null, null, (String)style);
                break;
            }
            case 2006: {
                control.drag(DragKind.DROP, Integer.valueOf(offset.x), Integer.valueOf(offset.y), (String)style);
            }
        }
    }
}

