/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.panels.assertion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.rcptt.tesla.core.protocol.Assert;
import org.eclipse.rcptt.tesla.core.protocol.AssertKind;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum AssertValue {
    BOOLEAN(new AssertKind[]{AssertKind.EQUALS, AssertKind.NOT_EQUALS}){

        @Override
        protected boolean matches(String type) {
            return "EBoolean".equals(type) || "EBooleanObject".equals(type);
        }
    }
    ,
    INTEGER(new AssertKind[]{AssertKind.EQUALS, AssertKind.NOT_EQUALS}){

        @Override
        protected boolean matches(String type) {
            return "EInt".equals(type) || "EIntObject".equals(type);
        }
    }
    ,
    STRING(AssertKind.EQUALS, AssertKind.NOT_EQUALS, AssertKind.CONTAINS, AssertKind.NOT_CONTAINS, AssertKind.IS_EMPTY, AssertKind.NOT_EMPTY),
    CONTAINS_TEXT(AssertKind.IMAGE_CONTAINS_TEXT),
    CONTAINS_IMAGE(AssertKind.CONTAINS_IMAGE);

    private List<String> names = new ArrayList<String>();

    public static AssertValue forAssert(Assert a) {
        if (a.getKind().equals((Object)AssertKind.CONTAINS_IMAGE)) {
            return CONTAINS_IMAGE;
        }
        if (a.getKind().equals((Object)AssertKind.IMAGE_CONTAINS_TEXT)) {
            return CONTAINS_TEXT;
        }
        EClassifier type = a.getValueType();
        if (type == null) {
            return STRING;
        }
        AssertValue[] assertValueArray = AssertValue.values();
        int n = assertValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            AssertValue v = assertValueArray[n2];
            if (v.matches(type.getName())) {
                return v;
            }
            ++n2;
        }
        return STRING;
    }

    private AssertValue(AssertKind ... values) {
        AssertKind[] assertKindArray = values;
        int n2 = values.length;
        int n3 = 0;
        while (n3 < n2) {
            AssertKind v = assertKindArray[n3];
            this.names.add(v.getLiteral());
            ++n3;
        }
    }

    public String[] getOperationNames() {
        return this.names.toArray(new String[this.names.size()]);
    }

    public int getOperationIndex(String name) {
        return this.names.indexOf(name);
    }

    protected boolean matches(String type) {
        return true;
    }
}

