/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.filesystem.internal;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.rcptt.ecl.filesystem.EclFile;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;

public class ResourceFile
implements EclFile {
    private final IPath path;
    private static final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();

    protected ResourceFile(IPath path) {
        if (path == null) {
            throw new NullPointerException();
        }
        this.path = path;
    }

    @Override
    public String getName() {
        IResource member = root.findMember(this.path);
        if (member != null) {
            return member.getName();
        }
        return this.path.lastSegment();
    }

    @Override
    public boolean exists() {
        IResource member = root.findMember(this.path);
        if (member == null) {
            return false;
        }
        return member.exists();
    }

    @Override
    public URI toURI() {
        try {
            return new URI("workspace", this.path.toPortableString(), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void delete() throws CoreException {
        IResource member = root.findMember(this.path);
        if (member == null) {
            return;
        }
        try {
            member.delete(true, null);
        }
        catch (CoreException e) {
            this.throwError("Failed to delete %s", e);
        }
    }

    public void refresh() throws CoreException {
        IResource member = root.findMember(this.path);
        if (member == null) {
            return;
        }
        try {
            member.refreshLocal(2, null);
        }
        catch (CoreException e) {
            this.throwError("Failed to refresh %s", e);
        }
    }

    private void createFolder(IContainer container) throws CoreException {
        container.refreshLocal(0, null);
        if (container instanceof IProject) {
            if (!container.exists()) {
                ((IProject)container).create(null);
            }
            ((IProject)container).open(null);
            return;
        }
        if (container.exists()) {
            return;
        }
        this.createFolder(container.getParent());
        if (!(container instanceof IFolder)) {
            throw new IllegalArgumentException("Unknown container type: " + container.getClass().getName());
        }
        ((IFolder)container).create(true, false, null);
    }

    @Override
    public void append(InputStream data) throws CoreException {
        IFile file = this.getFileForWrite();
        try {
            if (!file.exists()) {
                file.create(data, true, null);
            } else {
                file.appendContents(data, 1, null);
            }
        }
        catch (CoreException e) {
            this.throwError("failed to append %s", e);
        }
    }

    @Override
    public void write(InputStream data) throws CoreException {
        IFile file = this.getFileForWrite();
        try {
            if (!file.exists()) {
                file.create(data, true, null);
            } else {
                file.setContents(data, 1, null);
            }
        }
        catch (CoreException e) {
            this.throwError("Fialed to write %s", e);
        }
    }

    private IFile getFileForWrite() throws CoreException {
        IFile file = root.getFile(this.path);
        this.refresh();
        try {
            this.createFolder(file.getParent());
        }
        catch (CoreException e) {
            this.throwError("Failed to create folder " + String.valueOf(file.getParent()) + " to write %s", e);
        }
        if (this.isDirectory()) {
            this.throwError("%s is a directory", null);
        }
        return file;
    }

    @Override
    public InputStream read() throws CoreException {
        IFile file = root.getFile(this.path);
        try {
            this.refresh();
            return file.getContents();
        }
        catch (CoreException e) {
            throw new CoreException(CorePlugin.err((String)("Failed to read " + String.valueOf(this)), (Throwable)e));
        }
    }

    IContainer getContainer() {
        if (this.path.segmentCount() > 1) {
            return root.getFolder(this.path);
        }
        if (this.path.segmentCount() == 1) {
            return root.getProject(this.path.lastSegment());
        }
        if (this.path.segmentCount() == 0) {
            return root;
        }
        throw new IllegalStateException("Path can't be a container " + String.valueOf(this.path));
    }

    public Collection<EclFile> getChildren() throws CoreException {
        try {
            this.refresh();
            IResource[] members = this.getContainer().members();
            ArrayList<EclFile> rv = new ArrayList<EclFile>(members.length);
            IResource[] iResourceArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                rv.add(new ResourceFile(resource.getFullPath()));
                ++n2;
            }
            return rv;
        }
        catch (CoreException e) {
            throw new CoreException(CorePlugin.err((String)("Failed to read childen of " + String.valueOf(this)), (Throwable)e));
        }
    }

    @Override
    public boolean isDirectory() {
        IResource member = root.findMember(this.path);
        if (member == null) {
            return false;
        }
        return member instanceof IContainer;
    }

    private void throwError(String message, Throwable reason) throws CoreException {
        assert (message.contains("%s"));
        String formatted = String.format(message, this.toString());
        throw new CoreException(CorePlugin.err((String)formatted, (Throwable)reason));
    }

    public String toString() {
        return this.path.makeAbsolute().toPortableString();
    }

    @Override
    public File toFile() {
        return new File(root.getLocation().append(this.path).makeAbsolute().toPortableString());
    }
}

