/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOBooleanSupplier;

public abstract class BaseTermsEnum
extends TermsEnum {
    private AttributeSource atts = null;

    protected BaseTermsEnum() {
    }

    @Override
    public TermState termState() throws IOException {
        return new TermState(this){

            @Override
            public void copyFrom(TermState other) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean seekExact(BytesRef text) throws IOException {
        return this.seekCeil(text) == TermsEnum.SeekStatus.FOUND;
    }

    @Override
    public IOBooleanSupplier prepareSeekExact(BytesRef text) throws IOException {
        return () -> this.seekExact(text);
    }

    @Override
    public void seekExact(BytesRef term, TermState state) throws IOException {
        if (!this.seekExact(term)) {
            throw new IllegalArgumentException("term=" + String.valueOf(term) + " does not exist");
        }
    }

    @Override
    public AttributeSource attributes() {
        if (this.atts == null) {
            this.atts = new AttributeSource();
        }
        return this.atts;
    }
}

