/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.util.swt;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TableTreeUtil {
    public static String getName(Widget widget) {
        return widget instanceof TableColumn ? ((TableColumn)widget).getText() : ((TreeColumn)widget).getText();
    }

    public static int getWidth(Widget widget) {
        return widget instanceof TableColumn ? ((TableColumn)widget).getWidth() : ((TreeColumn)widget).getWidth();
    }

    public static int[] getColumnOrder(Widget widget) {
        return widget instanceof Table ? ((Table)widget).getColumnOrder() : ((Tree)widget).getColumnOrder();
    }

    public static Widget getColumn(Widget widget, int index) {
        return widget instanceof Table ? ((Table)widget).getColumn(index) : ((Tree)widget).getColumn(index);
    }

    public static int getColumnIndex(Widget widget, String columnName) {
        Widget column;
        if (widget instanceof TableItem || widget instanceof TreeItem) {
            widget = TableTreeUtil.getParent(widget);
        }
        if ((column = TableTreeUtil.findColumn(widget, columnName, 0)) == null) {
            return -1;
        }
        int count = TableTreeUtil.getColumnCount(widget);
        int i = 0;
        while (i < count) {
            if (column == TableTreeUtil.getColumn(widget, i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static Widget getParent(Widget widget) {
        if (widget instanceof TableColumn) {
            return ((TableColumn)widget).getParent();
        }
        if (widget instanceof TreeColumn) {
            return ((TreeColumn)widget).getParent();
        }
        if (widget instanceof TableItem) {
            return ((TableItem)widget).getParent();
        }
        return ((TreeItem)widget).getParent();
    }

    public static Widget[] getColumns(Widget widget) {
        int[] columnOrder = TableTreeUtil.getColumnOrder(widget);
        Widget[] result = new Widget[TableTreeUtil.getColumnCount(widget)];
        int i = 0;
        while (i < result.length) {
            result[i] = TableTreeUtil.getColumn(widget, columnOrder[i]);
            ++i;
        }
        return result;
    }

    public static void showItem(Widget item) {
        if (item instanceof TableItem) {
            TableItem tableItem = (TableItem)item;
            tableItem.getParent().showItem(tableItem);
        } else if (item instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)item;
            treeItem.getParent().showItem(treeItem);
        }
    }

    public static void showColumn(Widget column) {
        if (column instanceof TableColumn) {
            TableColumn tableColumn = (TableColumn)column;
            tableColumn.getParent().showColumn(tableColumn);
        } else if (column instanceof TreeColumn) {
            TreeColumn treeColumn = (TreeColumn)column;
            treeColumn.getParent().showColumn(treeColumn);
        }
    }

    public static int getColumnWidth(Widget widget) {
        return widget instanceof TreeColumn ? ((TreeColumn)widget).getWidth() : ((TableColumn)widget).getWidth();
    }

    public static int getColumnCount(Widget widget) {
        if (widget instanceof Table) {
            return ((Table)widget).getColumnCount();
        }
        if (widget instanceof Tree) {
            return ((Tree)widget).getColumnCount();
        }
        if (widget instanceof TableItem) {
            return ((TableItem)widget).getParent().getColumnCount();
        }
        return ((TreeItem)widget).getParent().getColumnCount();
    }

    public static Item[] getItems(Widget widget) {
        if (widget instanceof TableItem) {
            return new Item[0];
        }
        return widget instanceof Table ? ((Table)widget).getItems() : (widget instanceof Tree ? ((Tree)widget).getItems() : ((TreeItem)widget).getItems());
    }

    public static Item[] getExpandedItems(Widget widget) {
        if (widget instanceof Table) {
            return ((Table)widget).getItems();
        }
        ArrayList<Item> result = new ArrayList<Item>();
        Item[] itemArray = TableTreeUtil.getItems(widget);
        int n = itemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Item child = itemArray[n2];
            result.add(child);
            result.addAll(Arrays.asList(TableTreeUtil.getAllChildren(child)));
            ++n2;
        }
        return (Item[])result.toArray(new TreeItem[result.size()]);
    }

    public static Rectangle getBounds(Item item, int column) {
        if (item instanceof TableItem) {
            return ((TableItem)item).getBounds(column);
        }
        return ((TreeItem)item).getBounds(column);
    }

    public static Rectangle getBounds(Item item) {
        if (item instanceof TableItem) {
            return ((TableItem)item).getBounds();
        }
        return ((TreeItem)item).getBounds();
    }

    public static int getTopIndex(Widget widget) {
        if (widget instanceof Table) {
            return ((Table)widget).getTopIndex();
        }
        TreeItem topItem = ((Tree)widget).getTopItem();
        Item[] items = TableTreeUtil.getExpandedItems(widget);
        int i = 0;
        while (i < items.length) {
            if (items[i] == topItem) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static Point findCell(Widget widget, Point coords) {
        Item[] items = TableTreeUtil.getExpandedItems(widget);
        int firstRow = TableTreeUtil.getTopIndex(widget);
        int columnCount = TableTreeUtil.getColumnCount(widget);
        int row = firstRow;
        while (row < items.length) {
            Item item = items[row];
            int column = 0;
            while (column < columnCount) {
                if (TableTreeUtil.getBounds(item, column).contains(coords)) {
                    return new Point(row, column);
                }
                ++column;
            }
            ++row;
        }
        return null;
    }

    public static int findRow(Widget widget, Point coords) {
        int firstRow;
        Item[] items = TableTreeUtil.getExpandedItems(widget);
        int row = firstRow = TableTreeUtil.getTopIndex(widget);
        while (row < items.length) {
            Rectangle bounds = TableTreeUtil.getBounds(items[row]);
            if (coords.y >= bounds.y && coords.y <= bounds.y + bounds.height && coords.x >= bounds.x) {
                return row;
            }
            ++row;
        }
        return -1;
    }

    public static Item getItem(Widget widget, int row) {
        return TableTreeUtil.getExpandedItems(widget)[row];
    }

    public static StyleRange[] getStyleRanges(Item item) {
        return TableTreeUtil.getStyleRanges(item, 0);
    }

    public static String getRangeDataKey(int column) {
        return String.format("%sstyled_label_key_%d", "org.eclipse.jface", column);
    }

    public static StyleRange[] getStyleRanges(Item item, int column) {
        return (StyleRange[])item.getData(TableTreeUtil.getRangeDataKey(column));
    }

    public static Item[] getAllChildren(Item item) {
        if (item instanceof TableItem) {
            return new TableItem[0];
        }
        ArrayList<Item> result = new ArrayList<Item>();
        Item[] itemArray = TableTreeUtil.getChildren((Widget)item);
        int n = itemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Item child = itemArray[n2];
            result.add(child);
            result.addAll(Arrays.asList(TableTreeUtil.getAllChildren(child)));
            ++n2;
        }
        return result.toArray(new Item[result.size()]);
    }

    public static String[] getValues(Item item) {
        ArrayList<String> result = new ArrayList<String>();
        if (TableTreeUtil.getColumnCount(TableTreeUtil.getParent((Widget)item)) == 0) {
            return new String[]{TableTreeUtil.getValue(item)};
        }
        int[] nArray = TableTreeUtil.getColumnOrder(TableTreeUtil.getParent((Widget)item));
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            result.add(TableTreeUtil.getValue(item, i));
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    public static String getValue(Item item, int column) {
        return item instanceof TreeItem ? ((TreeItem)item).getText(column) : ((TableItem)item).getText(column);
    }

    public static Image getColumnImage(Widget column) {
        return column instanceof TreeColumn ? ((TreeColumn)column).getImage() : ((TableColumn)column).getImage();
    }

    public static Image getImage(Item item) {
        return item instanceof TreeItem ? ((TreeItem)item).getImage() : ((TableItem)item).getImage();
    }

    public static void setImage(Item item, Image image) {
        if (item instanceof TreeItem) {
            ((TreeItem)item).setImage(image);
        } else {
            ((TableItem)item).setImage(image);
        }
    }

    public static Image getImage(Item item, int column) {
        return item instanceof TreeItem ? ((TreeItem)item).getImage(column) : ((TableItem)item).getImage(column);
    }

    public static String getValue(Item item) {
        return item instanceof TreeItem ? ((TreeItem)item).getText() : ((TableItem)item).getText();
    }

    public static String getTooltip(Widget widget) {
        return widget instanceof TableColumn ? ((TableColumn)widget).getToolTipText() : ((TreeColumn)widget).getToolTipText();
    }

    public static Item[] getChildren(Widget item) {
        if (item instanceof TableItem) {
            return new Item[0];
        }
        TreeItem ti = (TreeItem)item;
        return ti.getExpanded() ? ti.getItems() : new Item[]{};
    }

    public static boolean isChecked(Widget item) {
        return item instanceof TableItem ? ((TableItem)item).getChecked() : ((TreeItem)item).getChecked();
    }

    public static Rectangle getItemBounds(Widget item, int column) {
        if (item instanceof TableItem) {
            return ((TableItem)item).getBounds(column);
        }
        return ((TreeItem)item).getBounds(column);
    }

    public static Rectangle getItemBounds(Widget item) {
        if (item instanceof TableItem) {
            return ((TableItem)item).getBounds();
        }
        return ((TreeItem)item).getBounds();
    }

    private static Widget findColumn(Widget[] columns, String name, int index, boolean regex) {
        Widget[] widgetArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            String nameFromTooltip;
            Widget column = widgetArray[n2];
            if (TableTreeUtil.matches(TableTreeUtil.getName(column), name, regex) || (nameFromTooltip = TableTreeUtil.getTooltip(column)) != null && TableTreeUtil.matches(nameFromTooltip, name, regex)) {
                if (index == 0) {
                    return column;
                }
                --index;
            }
            ++n2;
        }
        return null;
    }

    public static Widget findColumn(Widget widget, String name, int index) {
        Widget[] columns = TableTreeUtil.getColumns(widget);
        if (name == null || name.length() == 0) {
            return index < columns.length ? columns[index] : null;
        }
        Widget result = TableTreeUtil.findColumn(columns, name, index, false);
        if (result == null) {
            result = TableTreeUtil.findColumn(columns, name, index, true);
        }
        return result;
    }

    public static void setSelection(Widget parent, Widget item) {
        if (parent instanceof Tree) {
            ((Tree)parent).setSelection((TreeItem)item);
        } else {
            ((Table)parent).setSelection((TableItem)item);
        }
    }

    public static void deselectAll(Widget widget) {
        if (widget instanceof Table) {
            ((Table)widget).deselectAll();
        } else {
            ((Tree)widget).deselectAll();
        }
    }

    public static void setSelection(Widget parent, Widget[] items) {
        if (parent instanceof Tree) {
            TreeItem[] treeItems = new TreeItem[items.length];
            int i = 0;
            while (i < items.length) {
                treeItems[i] = (TreeItem)items[i];
                ++i;
            }
            ((Tree)parent).setSelection(treeItems);
        } else {
            TableItem[] tableItems = new TableItem[items.length];
            int i = 0;
            while (i < items.length) {
                tableItems[i] = (TableItem)items[i];
                ++i;
            }
            ((Table)parent).setSelection(tableItems);
        }
    }

    private static boolean matches(String name, String pattern, boolean useRegex) {
        return useRegex ? name.matches(pattern) : name.equals(pattern);
    }

    public static boolean isVirtual(Object item) {
        int style = 0;
        if (item instanceof TreeItem) {
            if (((TreeItem)item).isDisposed()) {
                return false;
            }
            style = ((TreeItem)item).getParent().getStyle();
        } else if (item instanceof TableItem) {
            if (((TableItem)item).isDisposed()) {
                return false;
            }
            style = ((TreeItem)item).getParent().getStyle();
        } else if (item instanceof Tree) {
            if (((Tree)item).isDisposed()) {
                return false;
            }
            style = ((Tree)item).getStyle();
        } else if (item instanceof Table) {
            if (((Table)item).isDisposed()) {
                return false;
            }
            style = ((Table)item).getStyle();
        }
        return (style & 0x10000000) != 0;
    }

    public static void setRowChecked(Widget item, boolean checked) {
        if (item instanceof TableItem) {
            ((TableItem)item).setChecked(checked);
        } else if (item instanceof TreeItem) {
            ((TreeItem)item).setChecked(checked);
        }
    }

    public static void setRowGrayed(Widget item, boolean grayed) {
        if (item instanceof TableItem) {
            ((TableItem)item).setGrayed(grayed);
        } else if (item instanceof TreeItem) {
            ((TreeItem)item).setGrayed(grayed);
        }
    }

    public static Color getForeground(Widget item, int columnInd) {
        if (item instanceof TreeItem) {
            return ((TreeItem)item).getForeground(columnInd);
        }
        return ((TableItem)item).getForeground(columnInd);
    }

    public static Color getForeground(Widget item) {
        if (item instanceof TreeItem) {
            return ((TreeItem)item).getForeground();
        }
        return ((TableItem)item).getForeground();
    }

    public static void setForeground(Widget item, Color color) {
        if (item instanceof TreeItem) {
            ((TreeItem)item).setForeground(color);
        } else {
            ((TableItem)item).setForeground(color);
        }
    }

    public static Color getBackground(Widget item, int columnInd) {
        if (item instanceof TreeItem) {
            return ((TreeItem)item).getBackground(columnInd);
        }
        return ((TableItem)item).getBackground(columnInd);
    }

    public static Color getBackground(Widget item) {
        if (item instanceof TreeItem) {
            return ((TreeItem)item).getBackground();
        }
        return ((TableItem)item).getBackground();
    }

    public static void setBackground(Widget item, Color color) {
        if (item instanceof TreeItem) {
            ((TreeItem)item).setBackground(color);
        } else {
            ((TableItem)item).setBackground(color);
        }
    }

    public static boolean getGrayed(Widget item) {
        if (item instanceof TreeItem) {
            return ((TreeItem)item).getGrayed();
        }
        return ((TableItem)item).getGrayed();
    }

    public static int getHorizontalScrollPos(Widget tableOrTree) {
        if (!(tableOrTree instanceof Scrollable)) {
            return 0;
        }
        Scrollable scrollable = (Scrollable)tableOrTree;
        ScrollBar scrollBar = scrollable.getHorizontalBar();
        if (scrollBar == null) {
            return 0;
        }
        return scrollBar.getSelection();
    }

    public static boolean getEnabled(Widget tableOrTree) {
        if (tableOrTree instanceof Tree) {
            return ((Tree)tableOrTree).getEnabled();
        }
        return ((Table)tableOrTree).getEnabled();
    }

    public static boolean getHeaderVisible(Widget tableOrTree) {
        if (tableOrTree instanceof Tree) {
            return ((Tree)tableOrTree).getHeaderVisible();
        }
        return ((Table)tableOrTree).getHeaderVisible();
    }

    public static boolean getLinesVisible(Widget tableOrTree) {
        if (tableOrTree instanceof Tree) {
            return ((Tree)tableOrTree).getLinesVisible();
        }
        return ((Table)tableOrTree).getLinesVisible();
    }

    public static int getSortColumn(Widget tableOrTree) {
        TreeColumn sortCol = null;
        if (tableOrTree instanceof Tree) {
            sortCol = ((Tree)tableOrTree).getSortColumn();
        } else if (tableOrTree instanceof Table) {
            sortCol = ((Table)tableOrTree).getSortColumn();
        }
        if (sortCol == null) {
            return -1;
        }
        Widget[] cols = TableTreeUtil.getColumns(tableOrTree);
        int i = 0;
        while (i < cols.length) {
            if (cols[i] == sortCol) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getSortDirection(Widget tableOrTree) {
        if (tableOrTree instanceof Tree) {
            return ((Tree)tableOrTree).getSortDirection();
        }
        return ((Table)tableOrTree).getSortDirection();
    }

    public static int getHeaderHeight(Widget tableOrTree) {
        if (tableOrTree instanceof Tree) {
            return ((Tree)tableOrTree).getHeaderHeight();
        }
        return ((Table)tableOrTree).getHeaderHeight();
    }

    public static Rectangle getColumnBounds(Widget column) {
        Widget tableOrTree = TableTreeUtil.getParent(column);
        if (!TableTreeUtil.getHeaderVisible(tableOrTree)) {
            return null;
        }
        int h = TableTreeUtil.getHeaderHeight(tableOrTree);
        int x = TableTreeUtil.getHorizontalScrollPos(tableOrTree);
        Widget[] widgetArray = TableTreeUtil.getColumns(tableOrTree);
        int n = widgetArray.length;
        int n2 = 0;
        while (n2 < n) {
            Widget c = widgetArray[n2];
            int w = TableTreeUtil.getColumnWidth(c);
            if (c == column) {
                return new Rectangle(x, -h, w, h);
            }
            x += w;
            ++n2;
        }
        return null;
    }

    public static Widget getColumnFromPoint(Widget tableOrTree, Point point) {
        if (!TableTreeUtil.getHeaderVisible(tableOrTree)) {
            return null;
        }
        Widget[] widgetArray = TableTreeUtil.getColumns(tableOrTree);
        int n = widgetArray.length;
        int n2 = 0;
        while (n2 < n) {
            Widget c = widgetArray[n2];
            Rectangle bounds = TableTreeUtil.getColumnBounds(c);
            if (bounds != null && bounds.contains(point)) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    public static Object[] getSelection(Widget tableOrTree) {
        if (tableOrTree instanceof Table) {
            Table table = (Table)tableOrTree;
            return table.getSelection();
        }
        Tree tree = (Tree)tableOrTree;
        return tree.getSelection();
    }
}

